#!/bin/sh
#
# Build the version.c file which contains all the version related info and
# needs to be updated on a per-build basis.

# $PROGRAM is the string returned as the first part of a /VERSION reply,
# and must not contain spaces.  It is not used anywhere else.
PROGRAM=ircservices
VERSION=5.0.39

# Increment Services build number
if [ -f version.c ] ; then
	BUILD=`fgrep '#define BUILD' version.c | sed 's/^#define BUILD.*"\([0-9]*\)".*$/\1/'`
	BUILD=`expr $BUILD + 1 2>/dev/null`
else
	BUILD=1
fi
if [ ! "$BUILD" ] ; then
	BUILD=1
fi

DATE=`date`
if [ $? -ne "0" ] ; then
    DATE="\" __DATE__ \" \" __TIME__ \""
fi

cat >version.c <<EOF
/* Version information for IRC Services.
 *
 * IRC Services is copyright (c) 1996-2004 Andrew Church.
 *     E-mail: <achurch@achurch.org>
 * Parts written by Andrew Kempe and others.
 * This program is free but copyrighted software; see the file COPYING for
 * details.
 */

#include "version.h"

#define BUILD	"$BUILD"

const char program_name[] = "$PROGRAM";
const char version_number[] = "$VERSION";
const char version_build[] = "build #" BUILD ", compiled $DATE";


/* Look folks, please leave this INFO reply intact and unchanged.  If you do
 * have the urge to mention yourself, please simply add your name to the list.
 * The other people listed below have just as much right, if not more, to be
 * mentioned.  Leave everything else untouched.  Thanks.
 */

const char *info_text[] =
    {
	"IRC Services developed by and copyright (c) 1996-2004",
	"Andrew Church <achurch@achurch.org>.",
	"Parts written by Andrew Kempe and others.",
	"IRC Services may be freely redistributed under the GNU",
	"General Public License, version 2.",
	"-",
	"Many people have contributed to the ongoing development of",
	"IRC Services.  Particularly noteworthy contributers include:",
	"Erdem Sener",
	"Jose R. Holzmann",
	"Mauritz Antunes",
	"Michael Raff",
	"Raul S. Villarreal",
	"Yusuf Iskenderoglu",
	"A full list of contributers and their contributions can be",
	"found in the Changes file included in the IRC Services",
	"distribution archive.  Many thanks to all of them!",
	"-",
	"For more information and a list of distribution sites,",
	"please visit: http://www.ircservices.za.net/",
	0,
    };
EOF
