/* Structures and declarations for ignore code.
 *
 * IRC Services is copyright (c) 1996-2005 Andrew Church.
 *     E-mail: <achurch@achurch.org>
 * Parts written by Andrew Kempe and others.
 * This program is free but copyrighted software; see the file COPYING for
 * details.
 */

#ifndef IGNORE_H
#define IGNORE_H

/*************************************************************************/

/* Ignorance list data. */

typedef struct ignore_data {
    struct ignore_data *next, *prev;
    char who[NICKMAX];
    time_t time;	/* When do we stop ignoring them? */
} IgnoreData;

/*************************************************************************/

E int allow_ignore;

E void add_ignore(const char *nick, time_t delta);
E int del_ignore(const char *nick);
E IgnoreData *get_ignore(const char *nick);
E IgnoreData *first_ignore(void);
E IgnoreData *next_ignore(void);

/*************************************************************************/

#endif	/* IGNORE_H */
