/* Include file for OperServ.
 *
 * IRC Services is copyright (c) 1996-2005 Andrew Church.
 *     E-mail: <achurch@achurch.org>
 * Parts written by Andrew Kempe and others.
 * This program is free but copyrighted software; see the file COPYING for
 * details.
 */

#ifndef OPERSERV_H
#define OPERSERV_H

/*************************************************************************/

/* Functions provided by database module: */

E int get_operserv_data(int what, void *ret);
E int put_operserv_data(int what, void *ptr);
E int open_operserv_db(const char *dbname);
E int sync_operserv_db(const char *dbname);
E int close_operserv_db(const char *dbname);

/* Constants for {get,put}_operserv_data: */
#define OSDATA_MAXUSERCNT	0
#define OSDATA_MAXUSERTIME	1
#define OSDATA_SUPASS		2

/*************************************************************************/

/* Exports: */

E char *s_OperServ;
E char *s_GlobalNoticer;
E char *ServicesRoot;

E int is_services_root(User *u);
E int is_services_admin(User *u);
E int is_services_oper(User *u);
E int nick_is_services_admin(NickInfo *ni);

/*************************************************************************/

#endif	/* OPERSERV_H */
