/* S-line data structure and interface.
 *
 * IRC Services is copyright (c) 1996-2005 Andrew Church.
 *     E-mail: <achurch@achurch.org>
 * Parts written by Andrew Kempe and others.
 * This program is free but copyrighted software; see the file COPYING for
 * details.
 */

#ifndef SLINE_H
#define SLINE_H

/*************************************************************************/

/* A single structure is used for all types of s-lines; each type has a
 * separate list of structures, and the `mask' field represents a real-name
 * mask, IP address mask, etc. depending on the type.
 */

typedef struct sline_ Sline;
struct sline_ {
    Sline *next, *prev;
    int modified;
    int locked;

    char *mask;			/* Data for this s-line */
    char who[NICKMAX];		/* Nick of person who added the s-line */
    char *reason;		/* Reason for s-line addition */
    time_t time;		/* When this s-line was added */
    int num;			/* Position in list */
};

#define SLINE_G		'G'	/* sgline */
#define SLINE_Q		'Q'	/* sqline */
#define SLINE_Z		'Z'	/* szline */

#define MAX_SLINE	32767	/* Maximum for a single type */

E int open_sline_db(const char *dbname);
E int sync_sline_db(const char *dbname);
E int close_sline_db(const char *dbname);

E void create_sline(uint8 type, char *mask, const char *reason,
		    const char *who, time_t expiry);

/*************************************************************************/

#endif  /* SLINE_H */
