# Emacs: -*- mode: fundamental; coding: binary; -*-

# French language file.
#
# IRC Services is copyright (c) 1996-2007 Andrew Church.
#     E-mail: <achurch@achurch.org>
# Parts written by Andrew Kempe and others.
# This program is free but copyrighted software; see the file COPYING for
# details.

# When translating this file to another language, keep in mind that the
# order of parameters for sprintf() is fixed in the source code, so your
# messages need to take the same parameters in the same order as the
# English messages do.  (Obviously, this doesn't hold for the strftime()
# format lines immediately below.)  If you can't get a natural translation
# of a message without changing the order of the parameters, please inform
# the Services developers.
#
# In help messages, "%S" (capital S, not lowercase) refers to the name of
# the service sending the message; for example, in NickServ help messages,
# "%S" is replaced by "NickServ" (or whatever it is renamed to in
# config.h).  The %S's do not count as sprintf() parameters, so they can be
# rearranged, removed, or added as necessary.
#
# Also in help messages, please try to limit line lengths to 60 characters
# of text (not including the leading tab).  This length was chosen because
# it does not cause line wrap under default settings on most current IRC
# clients.  Remember that format characters (control-B, control-_) are not
# included in that 60-character limit (since they don't show on the user's
# screen).  Also remember that format specifiers (%S, etc.) will expand
# when displayed, so remember to take this into account; you can assume
# that the length of a pseudoclient name (%S replacement) will be eight
# characters, so reduce the maximum line length by 6 for every %S on a
# line.
#
# Finally, remember to put a tab at the beginning of every line of text
# (including empty lines).  This has to be a tab, not spaces.
#
# This translation courtesy of
#	elijah (admin@nevernet.net)
#	Maxime (maxime_imbeau@hotmail.com)
#
###########################################################################
#
# Name of this language
#
###########################################################################

# For languages other than English, this string should have the following
# format:
#     language-name-in-language (language-name-in-English)
# For example, "Espaol (Spanish)" or "Franais (French)".

LANG_NAME
	Franais (French)

###########################################################################
#
# General messages
#
###########################################################################

# strftime() format strings.  man 3 strftime for information on the
# meanings of the format specifiers.  Short version:
#	%a = weekday name (short)	%H = hour
#	%b = month name (short)		%M = minute
#	%d = day of month		%S = second
#	%Y = year			%Z = time zone

# This is used as the format string for strftime() for a date and time
# together.
STRFTIME_DATE_TIME_FORMAT
	%b %d %H:%M:%S %Y %Z
# This is used as the format string for strftime() for a date alone in long
# format (English: including weekday).
STRFTIME_LONG_DATE_FORMAT
	%a %b %d %Y
# This is used as the format string for strftime() for a date alone in
# short format (English: without weekday).
STRFTIME_SHORT_DATE_FORMAT
	%b %d %Y

# These tell our strftime() what the names of months and days are.  If you
# don't use %a, %A, %b, or %B in your strftime() strings above, you can
# leave these empty.  However, if you enter names, they MUST stay in order,
# one per line, and the list MUST be complete!

# %a
STRFTIME_DAYS_SHORT
	Dim
	Lun
	Mar
	Mer
	Jeu
	Ven
	Sam
# %A
STRFTIME_DAYS_LONG
	Dimanche
	Lundi
	Mardi
	Mercredi
	Jeudi
	Vendredi
	Samedi
# %b
STRFTIME_MONTHS_SHORT
	Jan
	Fev
	Mar
	Avr
	Mai
	Jun
	Jul
	Aou
	Sep
	Oct
	Nov
	Dec
# %B
STRFTIME_MONTHS_LONG
	Janvier
	Fvrier
	Mars
	Avril
	Mai
	Juin
	Juillet
	Aot
	Septembre
	Octobre
	Novembre
	Dcembre


# "day", "hour", "minute", and "second" in singular and plural.
# These must be preceded by spaces if the language requires them
# (e.g. in English: "10 hours", not "10hours").
STR_DAY
	 jour
STR_DAYS
	 jours
STR_HOUR
	 heure
STR_HOURS
	 heures
STR_MINUTE
	 minute
STR_MINUTES
	 minutes
STR_SECOND
	 seconde
STR_SECONDS
	 secondes
# Separator used between units of time; in English, a comma followed by a
# space (the ", " in "3 hours, 10 minutes").
STR_TIMESEP
	,

# This is used in ChanServ/NickServ INFO displays, and is a comma followed
# by a space (", " -- trailing space is significant), or the equivalent in
# the language's character set.
COMMA_SPACE
	,


# Various error messages.
INTERNAL_ERROR
	Erreur interne--impossible de donner suite  la requte.
SERVICES_IS_BUSY
	Les Services sont prsentement occups; s.v.p. essayer de nouveau plus tard.

UNKNOWN_COMMAND
	Commande inconnue %s.
UNKNOWN_COMMAND_HELP
	Commande inconnue %s.  Tapez /msg %s HELP pour de l'aide.
SYNTAX_ERROR
	Syntaxe: %s
MORE_INFO
	Tapez /msg %s HELP %s pour plus d'information.
NO_HELP_AVAILABLE
	Pas d'aide disponible pour %s.
MISSING_QUOTE
	Guillemets (") manquants.

BAD_EMAIL
	L'adresse courriel doit avoir la forme username@hostname. Vous ne pouvez utiliser de couleur, caractres gras, soulign, ou invers ou les caractres suivants: , : ; | \ " ( ) < > [ ]
BAD_URL
	Les URLs doivent avoir la forme suivante http://hostname[:port]/... (or ftp://, etc.).
BAD_USERHOST_MASK
	Le masque doit prendre la forme user@host.
BAD_NICKUSERHOST_MASK
	Le masque doit prendre la forme surnom!user@host.
BAD_EXPIRY_TIME
	Temps d'expiration invalide.

SENDMAIL_NO_RESOURCES
	Le systme est prsentement trop surcharg pour expdier du courrier; s'il vous plait, essayez plus tard.
READ_ONLY_MODE
	Notice: Les Services sont prsentement en mode lecture-seulement; les modifications ne seront pas sauvegardes!
PASSWORD_INCORRECT
	Mot de passe invalide.
PASSWORD_WARNING
	Attention: Aprs un autre mot de passe invalide vous serez dconnect.

# What's the difference between "Access denied" and "Permission denied"?
# Very little; you can safely make them the same message with no real loss
# of meaning.  If you want to make a distinction, "Access denied" is
# usually used more generally; for example, a non-oper trying to access
# OperServ gets "Access denied", while a non-Services admin trying to use
# NickServ SET NOEXPIRE gets "Permission denied".
ACCESS_DENIED
	Accs refus.
PERMISSION_DENIED
	Permission refuse.

MORE_OBSCURE_PASSWORD
	S.V.P. essayez plus tard avec un mot de passe plus compliqu.  Le mot de passe doit comporter au moins 5 caractres, et ne devrait pas tre quelque chose facile  trouver (ex : votre vrai nom ou votre surnom).
PASSWORD_TRUNCATED
	Attention:  Votre mot de passe a t tronqu  %d caractres.

NICK_NOT_REGISTERED
	Votre surnom n'est pas enregistr.
NICK_NOT_REGISTERED_HELP
	Votre surnom n'est pas enregistr.  Tapez /msg %s HELP pour de l'information sur l'enregistrement de votre surnom.
NICK_TOO_LONG
	Les surnoms ne doivent pas comporter plus de %d caractres.
NICK_INVALID
	%s n'est pas un surnom valide.
NICK_X_NOT_REGISTERED
	Le surnom %s n'est pas enregistr.
NICK_X_ALREADY_REGISTERED
	Le surnom %s est dj enregistr!
NICK_X_NOT_IN_USE
	Le surnom %s n'est pas utilis prsentement.
NICK_X_FORBIDDEN
	Le surnom %s ne peut tre enregistr ou utilis.
NICK_X_SUSPENDED
	Le surnom %s est suspendu vous ne pouvez vous y tre identifi ni l'utiliser.
NICK_X_SUSPENDED_MEMOS
	Le surnom %s est suspendu et ne peut pas recevoir de mmos.
NICK_IDENTIFY_REQUIRED
	Authentification par mot de passe requise pour l'utilisation de cette commande.
	Ressayez aprs avoit tap /msg %s IDENTIFY mot de passe.
NICK_PLEASE_AUTH
	Votre surnom n'est pas encore authentifi.  S'il vous plait authentifiez-le en utilisant le code inclus dans le message expdi : %s
NICK_X_NOT_ON_CHAN_X
	Le surnom %s n'est pas actuellement sur le canal %s.

CHAN_INVALID
	%s n'est pas valide pour un nom de canal.
CHAN_X_NOT_REGISTERED
	Le canal %s n'est pas enregistr.
CHAN_X_NOT_IN_USE
	Le canal %s n'est pas utilis prsentment.
CHAN_X_FORBIDDEN
	Le canal %s ne peut tre enregistr ou utilis.
CHAN_X_SUSPENDED
	Le canal %s est suspendu vous ne pouvez vous y tre identifi ni l'utiliser.
CHAN_X_SUSPENDED_MEMOS
	Le canal %s est suspendu et ne peut pas recevoir de mmos.
CHAN_IDENTIFY_REQUIRED
	Authentification par mot de passe requise pour l'utilisation de cette commande.
	Ressayez aprs avoit tap /msg %s IDENTIFY %s mot de passe.

SERV_X_NOT_FOUND
	Le server %s n'a pas t trouv.

EXPIRES_NONE
	n'expirera pas
EXPIRES_SOON
	expire  la prochaine mise--jour de la banque de donne
EXPIRES_IN
	expire dans %s

###########################################################################
#
# NickServ messages
#
###########################################################################

# Automatic messages
NICK_IS_REGISTERED
	Ce surnom appartient  quelqu'un d'autre. S.V.P. en choisir un autre. (S'il s'agit de votre surnom, tapez: /msg %s IDENTIFY mot de passe.)
NICK_IS_SECURE
	Ce surnom est enregistr et protg.  S'il s'agit de votre surnom, tapez: /msg %s IDENTIFY mot de passe. Autrement, S.V.P. en choisir un autre.
NICK_MAY_NOT_BE_USED
	Ce surnom ne peut pas tre utilis. S.V.P. en choisir un autre.
DISCONNECT_IN_1_MINUTE
	Si vous ne changez pas  l'intrieur d'une minute, vous serez dconnect.
DISCONNECT_IN_20_SECONDS
	Si vous ne changez pas  l'intrieur de 20 secondes, vous serez dconnect.
DISCONNECT_NOW
	Ce surnom a dj t enregistr; vous ne pouvez l'utiliser. S.V.P. en choisir un autre avant d'tre dconnect.
FORCENICKCHANGE_IN_1_MINUTE
	Si vous ne changez pas  l'intrieur d'une minute, Je changerai votre surnom.
FORCENICKCHANGE_IN_20_SECONDS
	Si vous ne changez pas  l'intrieur de 20 secondes, Je changerai votre surnom.
FORCENICKCHANGE_NOW
	Ce surnom a t enregistr; vous ne pouvez l'utiliser.  Votre surnom est maintenant chang pour %s.
NICK_EXPIRES_SOON
	Attention: Votre enregistrement de surnom va expirer dans %s.  Si vous dsirez continuer de l'utiliser, S.V.P. identifiez-vous  %s en tapant: /msg %s IDENTIFY mot de passe
NICK_EXPIRED
	Attention: L'enregistrement de votre surnom a expir.  S.V.P. r-enregistrez votre surnom si vous dsirez continuer  l'utiliser.

# REGISTER responses
NICK_REGISTER_SYNTAX
	REGISTER mot de passe [courriel]
NICK_REGISTER_REQ_EMAIL_SYNTAX
	REGISTER mot de passe courriel
NICK_REGISTRATION_DISABLED
	Dsol, l'enregistrement de surnom est temporairement hors service.
NICK_REGISTRATION_FAILED
	Dsol, l'enregistrement a chou.
NICK_REG_PLEASE_WAIT
	S.V.P. attendez %s avant d'utiliser la commande REGISTER  nouveau.
NICK_CANNOT_BE_REGISTERED
	Le surnom %s ne peut pas tre enregistr.
NICK_REGISTER_EMAIL_UNAUTHED
	L'adresse courriel que vous avez fourni n'a pas encore t autorise.  S.V.P. utilisez la commande AUTH pour autoriser l'adresse avant d'enregistrer de nouveaux surnoms avec elle.
NICK_REGISTER_TOO_MANY_NICKS
	Vous avez trop de surnoms enregistrs ((%d, maximum de %d).  Vous ne pouvez en enregistrer d'autre  moins d'abandonner quelques uns de vos surnoms actuels.
NICK_REGISTERED
	Le surnom %s a t enregistr pour vous.
NICK_PASSWORD_IS
	Votre mot de passe est %s -- retenez-le pour usage ultrieur.

# IDENTIFY responses
NICK_IDENTIFY_SYNTAX
	IDENTIFY mot de passe
NICK_IDENTIFY_FAILED
	Dsol, l'identification a choue.
NICK_IDENTIFY_EMAIL_MISSING
	Vous devez slectionner une adresse courriel pour votre surnom avant de pouvoir continuer  l'utiliser. S.V.P. slectionnez-en un maintenant avec la commande: /msg %s SET EMAIL addresse
NICK_IDENTIFY_SUCCEEDED
	Mot de passe accept -- vous tes maintenant reconnu.

# DROP responses
NICK_DROP_SYNTAX
	DROP mot de passe
NICK_DROP_WARNING
	Attention: La commande DROP d-enregistrera tous vos surnoms lis!
NICK_DROP_DISABLED
	Dsol, le dsenregistrement de surnom est temporairement hors-service.
NICK_DROP_FAILED
	Dsol, le dsenregistrement de surnom a chou.
NICK_DROPPED
	Votre surnom a t dsenregistr.
NICK_DROPPED_LINKS
	Votre surnom ainsi que tous les surnoms qui y taient lis ont t dsenregistrs.

# DROPNICK responses
NICK_DROPNICK_SYNTAX
	DROPNICK surnom
NICK_X_DROPPED
	Le surnom %s a t dsenregistr.
NICK_X_DROPPED_LINKS
	Le surnom %s ainsi que tous les surnoms qui y taient lis ont t dsenregistrs.

# SET responses
NICK_SET_SYNTAX
	SET option paramtres
NICK_SET_OPER_SYNTAX
	SET [surnom] option paramtres
NICK_SET_DISABLED
	Dsol, la slection d'options de surnom est temporairement hors-service.
NICK_SET_UNKNOWN_OPTION
	Option SET %s inconnue.
NICK_SET_UNKNOWN_OPTION_OR_BAD_NICK
	Option SET %s inconnue, ou surnom non enregistr.

# SET PASSWORD responses
NICK_SET_PASSWORD_FAILED
	Dsol, le mot de passe ne peut chang.
NICK_SET_PASSWORD_CHANGED
	Mot de passe chang.
NICK_SET_PASSWORD_CHANGED_TO
	Mot de passe chang  %s.

# SET LANGUAGE responses
NICK_SET_LANGUAGE_SYNTAX
	SET LANGUAGE numro
NICK_SET_LANGUAGE_UNKNOWN
	Numro de langue inconnu %d.  Tapez : /msg %s HELP SET LANGUAGE pour la liste des langues.
NICK_SET_LANGUAGE_CHANGED
	Langue change  %s.

# SET URL responses
NICK_SET_URL_CHANGED
	L'URL pour %s change pour %s.

# SET EMAIL responses
NICK_SET_EMAIL_UNAUTHED
	L'adresse courriel que vous avez fourni n'a pas encore t autorise.  S.V.P. utilisez la commande AUTH pour autoriser l'adresse d'abord.
NICK_SET_EMAIL_TOO_MANY_NICKS
	%s a prsentement %d surnoms enregistrs (maximum de %d).  Le changement d'adresse courriel a choue.
NICK_SET_EMAIL_CHANGED
	L'adresse courriel pour %s a t change pour %s.

# SET INFO responses
NICK_SET_INFO_CHANGED
	 L'information pour %s a t change.

# SET KILL responses
NICK_SET_KILL_SYNTAX
	SET KILL {ON | QUICK | OFF}
NICK_SET_KILL_IMMED_SYNTAX
	SET KILL {ON | QUICK | IMMED | OFF}
NICK_SET_KILL_ON
	La protection Kill est maintenant ON.
NICK_SET_KILL_QUICK
	La protection Kill est maintenant ON, avec un dlais rduit.
NICK_SET_KILL_IMMED
	La protection Kill est maintenant ON, sans dlais.
NICK_SET_KILL_IMMED_DISABLED
	L'option IMMED n'est pas disponible sur ce rseau.
NICK_SET_KILL_OFF
	La protection Kill est maintenant OFF.

# SET SECURE responses
NICK_SET_SECURE_SYNTAX
	SET SECURE {ON | OFF}
NICK_SET_SECURE_ON
	L'option Secure est maintenant ON.
NICK_SET_SECURE_OFF
	L'option Secure est maintenant OFF.

# SET PRIVATE responses
NICK_SET_PRIVATE_SYNTAX
	SET PRIVATE {ON | OFF}
NICK_SET_PRIVATE_ON
	L'option Private est maintenant ON.
NICK_SET_PRIVATE_OFF
	L'option Private est maintenant OFF.

# SET HIDE responses
NICK_SET_HIDE_SYNTAX
	SET HIDE {EMAIL | USERMASK | QUIT} {ON | OFF}
NICK_SET_HIDE_EMAIL_ON
	Votre adresse courriel sera maintenant cache de l'affichage %s INFO.
NICK_SET_HIDE_EMAIL_OFF
	Votre adresse courriel sera maintenant prsente lors de l'affichage %s INFO.
NICK_SET_HIDE_MASK_ON
	Votre dernier masque user@host appercu sera maintenant cach lors de l'affichage %s INFO.
NICK_SET_HIDE_MASK_OFF
	Votre dernier masque user@host appercu sera maintenant prsente lors de l'affichage %s INFO.
NICK_SET_HIDE_QUIT_ON
	Votre dernier message de sortie sera maintenant cach lors de l'affichage %s INFO.
NICK_SET_HIDE_QUIT_OFF
	Votre dernier message de sortie sera maintenant prsent lors de l'affichage %s INFO.

# SET TIMEZONE responses
NICK_SET_TIMEZONE_SYNTAX
	SET TIMEZONE {UTC-offset | fuseau horaire | DEFAULT}
NICK_SET_TIMEZONE_TO
	Votre fuseau horaire est slectionn  UTC%c%d:%02d.
	L'heure actuelle dans ce fuseau horaire est %s.
NICK_SET_TIMEZONE_DEFAULT
	Votre fuseau horaire a t ramen au fuseau horaire des Services.

# SET MAINNICK responses
NICK_SET_MAINNICK_NOT_FOUND
	Le surnom %s n'est pas li  votre surnom.
NICK_SET_MAINNICK_CHANGED
	Votre surnom principal a t chang pour %s.

# SET NOEXPIRE responses
NICK_SET_NOEXPIRE_SYNTAX
	SET [surnom] NOEXPIRE {ON | OFF}
NICK_SET_NOEXPIRE_ON
	Le surnom %s n'expirera pas.
NICK_SET_NOEXPIRE_OFF
	Le surnom %s va expirer.

# UNSET responses
NICK_UNSET_SYNTAX
	UNSET {URL | EMAIL | INFO}
NICK_UNSET_SYNTAX_REQ_EMAIL
	UNSET {URL | INFO}
NICK_UNSET_URL
	L'URL pour %s unset.
NICK_UNSET_EMAIL
	L'adresse courriel %s unset.
NICK_UNSET_INFO
	L'information pour %s unset.
NICK_UNSET_EMAIL_BAD
	Vous ne pouvez pas effacer votre adresse courriel.
NICK_UNSET_EMAIL_OTHER_BAD
	L'adresse courriel du surnom ne peut tre efface.

# ACCESS responses
NICK_ACCESS_SYNTAX
	ACCESS {ADD | DEL | LIST} [masque]
NICK_ACCESS_ALREADY_PRESENT
	Le masque %s est dj prsent dans votre liste d'accs.
NICK_ACCESS_REACHED_LIMIT
	Dsol, vous pouvez avoir seulement %d entres d'accs pour un surnom.
NICK_ACCESS_NO_NICKS
	Attention: Les masques d'accs des surnoms ne peuvent pas inclure de surnoms.  >S.V.P. vrifiez et assurez-vous que vous avez entr le masque usager@hte correctement.
NICK_ACCESS_ADDED
	%s a t ajout  votre liste d'accs.
NICK_ACCESS_NOT_FOUND
	%s n'apparait pas  la liste de vos accs.
NICK_ACCESS_DELETED
	%s effac de votre liste d'accs.
NICK_ACCESS_LIST_EMPTY
	Votre liste d'accs est vide.
NICK_ACCESS_LIST
	Liste d'accs:
NICK_ACCESS_LIST_X_EMPTY
	Liste d'accs pour %s est vide.
NICK_ACCESS_LIST_X
	Liste d'accs pour %s:

# LINK responses
NICK_OLD_LINK_SYNTAX
	LINK surnom mot de passe
NICK_LINK_SYNTAX
	LINK surnom
NICK_LINK_DISABLED
	Dsol, l'option de liaison de surnom est temporairement hors-service.
NICK_LINK_FAILED
	Dsol, le lien n'a pu tre tabli.
NICK_CANNOT_BE_LINKED
	Le surnom %s ne peut pas tre li.
NICK_OLD_LINK_SAME
	Vous ne pouvez pas vous lier  votre surnom actuel!
NICK_LINK_SAME
	Vous ne pouvez lier votre surnom actuel!
NICK_LINK_ALREADY_LINKED
	Le surnom %s est prsentement li  votre surnom.
NICK_LINK_IN_USE
	Le surnom %s est prsentement utilis.
NICK_LINK_TOO_MANY
	Vous ne pouvez pas avoir plus de %d surnoms lis ensembles.
NICK_LINK_TOO_MANY_NICKS
	Vous avez prsentement %d surnoms enregistrs (maximum de %d).  Le lien a chou.
NICK_OLD_LINK_TOO_MANY_CHANNELS
	Ne peut tre li au surnom %s: trop de canaux enregistrs (combinaison maximale de %d).
NICK_OLD_LINKED
	Votre surnom a t li  %s.
NICK_LINKED
	Le surnom %s a t li  votre surnom.

# UNLINK responses
NICK_OLD_UNLINK_SYNTAX
	UNLINK [surnom mot de passe]
NICK_UNLINK_SYNTAX
	UNLINK surnom
NICK_UNLINK_OPER_SYNTAX
	UNLINK surnom [FORCE]
NICK_UNLINK_DISABLED
	Dsol, l'option de retrait de liaison de surnom est temporairement hors-service.
NICK_UNLINK_FAILED
	Dsol, le retrait du lien chou.
NICK_UNLINK_SAME
	Vous ne pouvez enlever le lien de votre surnom actuel!
NICK_OLD_UNLINK_NOT_LINKED
	Votre surnom n'est pas li.
NICK_UNLINK_NOT_LINKED_YOURS
	Le surnom %s n'est pas li  votre surnom.
NICK_UNLINK_NOT_LINKED
	Le surnom %s n'est pas li.
NICK_OLD_UNLINKED
	Votre surnom n'est plus li  %s.
NICK_UNLINKED
	Le surnom %s n'est plus li  votre surnom actuel.
NICK_X_UNLINKED
	Le surnom %s n'est plus li  %s.

# LISTLINKS responses
NICK_OLD_LISTLINKS_SYNTAX
	LISTLINKS surnom [ALL]
NICK_LISTLINKS_SYNTAX
	LISTLINKS
NICK_LISTLINKS_HEADER
	Liste des surnoms lis  %s:
NICK_LISTLINKS_FOOTER
	%d surnoms lis.

# INFO responses
NICK_INFO_SYNTAX
	INFO surnom [ALL]
NICK_INFO_REALNAME
	   %s est %s
NICK_INFO_ADDRESS
	 Dernire adresse apperue: %s
NICK_INFO_ADDRESS_ONLINE
	       Branch  partir de: %s
NICK_INFO_ADDRESS_ONLINE_NOHOST
	%s est prsentement en ligne.
NICK_INFO_TIME_REGGED
	      Enregistr depuis le: %s
NICK_INFO_LAST_SEEN
	Apperu la dernire fois : %s
NICK_INFO_LAST_QUIT
	 Dernier message de sortie: %s
NICK_INFO_URL
	                       URL: %s
NICK_INFO_EMAIL
	          Adresse courriel: %s
NICK_INFO_EMAIL_UNAUTHED
	          Adresse courriel: %s (non vrifie)
NICK_INFO_INFO
	               Information: %s
NICK_INFO_OPTIONS
	                   Options: %s
# These strings MUST NOT be empty
NICK_INFO_OPT_KILL
	Protection Kill
NICK_INFO_OPT_SECURE
	Securit active
NICK_INFO_OPT_PRIVATE
	Priv
NICK_INFO_OPT_NONE
	Aucune
NICK_INFO_NO_EXPIRE
	Ce surnom n'expirera pas.
NICK_INFO_SUSPEND_DETAILS
	Suspendu par %s sur %s (%s).
NICK_INFO_SUSPEND_REASON
	Raison: %s
NICK_INFO_SHOW_ALL
	 Pour plus d'information, tapez: /msg %s INFO %s ALL

# LISTCHANS responses
NICK_LISTCHANS_SYNTAX
	LISTCHANS
NICK_LISTCHANS_NONE
	%s n'a pas enregistr aucun canal.
NICK_LISTCHANS_HEADER
	Canaux enregistrs par %s:
NICK_LISTCHANS_END
	Fin de la liste (%d canaux enregistrs).

# LIST/LISTEMAIL responses
NICK_LIST_SYNTAX
	%s modle
NICK_LIST_OPER_SYNTAX
	%s modle [FORBIDDEN] [NOEXPIRE] [SUSPENDED]
NICK_LIST_OPER_SYNTAX_AUTH
	%s modle [FORBIDDEN] [NOEXPIRE] [SUSPENDED] [NOAUTH]
NICK_LIST_HEADER
	Liste des entres correspondantes  %s:
NICK_LIST_RESULTS
	Fin de la liste; %d/%d correspondances affiches.
NICK_LISTEMAIL_NONE
	(non slectionn)

# RECOVER responses
NICK_RECOVER_SYNTAX
	RECOVER surnom [mot de passe]
NICK_NO_RECOVER_SELF
	Vous ne pouvez vous reprendre vous-mme!
NICK_RECOVERED
	L'usager qui avait pris votre surnom a t dconnect.  Tapez /msg %s RELEASE %s pour le reprendre avant l'expiration du dlais d'une minute.

# RELEASE responses
NICK_RELEASE_SYNTAX
	RELEASE surnom [mot de passe]
NICK_RELEASE_NOT_HELD
	Le surnom %s n'est pas retenu.
NICK_RELEASED
	Les services ont libr votre surnom.

# GHOST responses
NICK_GHOST_SYNTAX
	GHOST surnom [mot de passe]
NICK_NO_GHOST_SELF
	Vous ne pouvez utiliser ghost pour vous-mme!
NICK_GHOST_KILLED
	Votre fantme a t tu grce  la commande Ghost.

# GETPASS responses
NICK_GETPASS_SYNTAX
	GETPASS surnom
NICK_GETPASS_UNAVAILABLE
	La commande GETPASS n'es pas disponible parce que l'encryption est en cours.
NICK_GETPASS_PASSWORD_IS
	Le mot de passe pour %s est %s.

# FORBID responses
NICK_FORBID_SYNTAX
	FORBID surnom
NICK_FORBID_SUCCEEDED
	Le surnom %s est maintenant interdit.
NICK_FORBID_FAILED
	Ne peut interdire le nick %s!

# SUSPEND responses
NICK_SUSPEND_SYNTAX
	SUSPEND [+expiration] surnom raison
NICK_SUSPEND_SUCCEEDED
	Le surnom %s, et tous les surnoms qui y taient lis, ont t suspendus.
NICK_SUSPEND_ALREADY_SUSPENDED
	Le surnom %s est prsentement suspendu.

# UNSUSPEND responses
NICK_UNSUSPEND_SYNTAX
	UNSUSPEND surnom
NICK_UNSUSPEND_SUCCEEDED
	Le surnom %s a t d-suspendu.
NICK_UNSUSPEND_NOT_SUSPENDED
	 Le surnom %s n'est pas suspendu.

################ autojoin module messages/responses

# AJOIN responses
NICK_AJOIN_SYNTAX
	AJOIN {ADD | DEL | LIST} [canal]
NICK_AJOIN_ADD_SYNTAX
	AJOIN ADD canal
NICK_AJOIN_DEL_SYNTAX
	AJOIN DEL canal
NICK_AJOIN_ALREADY_PRESENT
	Le canal %s est actuellement sur votre liste d'autojoin.
NICK_AJOIN_LIST_FULL
	Dsol, vous pouvez avoir seulement %d entres dans la liste autojoin pour un surnom.
NICK_AJOIN_ADDED
	%s ajout  votre liste autojoin.
NICK_AJOIN_NOT_FOUND
	%s abscent de votre liste autojoin.
NICK_AJOIN_DELETED
	%s effac de votre liste autojoin.
NICK_AJOIN_LIST_EMPTY
	Votre liste d'autojoin est vide.
NICK_AJOIN_LIST
	Liste d'autojoin:
NICK_AJOIN_LIST_X_EMPTY
	Liste d'autojoin pour %s est vide.
NICK_AJOIN_LIST_X
	Liste d'autojoin pour %s:

################ mail-auth module messages/responses

# General-purpose messages
NICK_AUTH_SENT
	Un code d'autorisation pour votre surnom a t expdi  l'adresse courriel %s.
NICK_AUTH_FOR_REGISTER
	Lorsque vous recevrez ce message, tapez /msg %s AUTH code (remplacez code par le code d'autorisation inclus au message) pour complter votre enregistrement de surnom.
NICK_AUTH_FOR_SET_EMAIL
	Lorsque vous recevrez ce message, tapez /msg %s AUTH code (remplacez code par le code d'autorisation inclus au message) pour complter votre changement d'adresse.
	S.V.P. notez que vous ne pourrez plus continuer d'utiliser votre surnom tant que vous n'aurez pas complt le changement.
NICK_AUTH_NOT_NEEDED
	Il n'y a pour le moment rien qui requiert une autorisation.
NICK_AUTH_NO_AUTHCODE
	 Le surnom %s n'a pas de code d'autorisation.
NICK_AUTH_HAS_AUTHCODE
	Le surnom %s a dj un code d'autorisation.
PASSWORD_WARNING_FOR_AUTH
	Attention: Aprs un autre code d'autorisation incorrect vous serez dbranch.

# Mail text.  The last "%s" (before the user@host) in the body text is
# replaced by one of the NICK_AUTH_MAIL_TEXT_* messages.
NICK_AUTH_MAIL_SUBJECT
	Code d'autorisation pour %s
NICK_AUTH_MAIL_BODY
	Le code d'autorisation pour votre surnom (%s) est : %09d
	S.V.P. soumettez ce code  %s avec la commande:
	    /msg %s AUTH %09d
	
	Si vous avec quelque question que ce soit, s.v.p. joindre #aide pour de l'assistance.
	
	Ce message sera expdi par %s en rponse  %s
	%s@%s.
NICK_AUTH_MAIL_TEXT_REG
	enregistrement par
NICK_AUTH_MAIL_TEXT_EMAIL
	adresse courriel change par
NICK_AUTH_MAIL_TEXT_SENDAUTH
	une commande SENDAUTH de
NICK_AUTH_MAIL_BODY_SETAUTH
	Le code d'autorisation pour votre surnom (%s) est: %09d
	S.V.P. soumettez ce code  %s avec la commande:
	    /msg %s AUTH %09d

# AUTH responses
NICK_AUTH_SYNTAX
	AUTH code
NICK_AUTH_DISABLED
	Dsol, l'autorisation de surnom est temporairement hors-service.
NICK_AUTH_FAILED
	Le code d'autorisation est incorrect.
NICK_AUTH_SUCCEEDED_REGISTER
	Autorisation russie; votre enregistrement de surnom est maintenant complte.
NICK_AUTH_SUCCEEDED_SET_EMAIL
	Autorisation russie; votre changement d'adresse courriel est maintenant complte.
NICK_AUTH_SUCCEEDED_SETAUTH
	Autorisation russie; vous pouvez maintenant utiliser votre surnom.

# SENDAUTH responses
NICK_SENDAUTH_SYNTAX
	SENDAUTH
NICK_SENDAUTH_TOO_SOON
	 S.V.P. attendez %s avant d'utiliser la commande SENDAUTH  nouveau.
NICK_SENDAUTH_FAILED
	Dsol, incapable d'expdier le code d'autorisation.

# SETAUTH responses
NICK_SETAUTH_SYNTAX
	SETAUTH surnom
NICK_SETAUTH_NO_EMAIL
	Le surnom %s n'a aucune adresse courriel de slectionne.
NICK_SETAUTH_AUTHCODE_SET
	Un nouveau code d'autorisation (%09d) a t slectionn pour le surnom %s.
NICK_SETAUTH_SEND_FAILED
	Attention: incapable d'expdier de courrier  %s.
NICK_SETAUTH_SEND_TEMPFAIL
	Attention: incapable d'expdier du courrier  %s (ressources insuffisantes).
NICK_SETAUTH_USER_NOTICE
	Vous devez autoriser votre surnom avant de continuer de l'utiliser.  Un code d'autorisation  vous a t expdi  l'adresse courriel: %s
	Tapez /msg %s HELP AUTH pour plus d'information.

# GETAUTH responses
NICK_GETAUTH_SYNTAX
	GETAUTH surnom
NICK_GETAUTH_AUTHCODE_IS
	Le code d'autorisation pour le surnom %s est: %09d

# CLEARAUTH responses
NICK_CLEARAUTH_SYNTAX
	CLEARAUTH surnom
NICK_CLEARAUTH_CLEARED
	Le code d'autorisation pour le surnom %s a t effac.

################ sendpass module messages/responses

# Mail text
NICK_SENDPASS_MAIL_SUBJECT
	Mot de passe pour %s
NICK_SENDPASS_MAIL_BODY
	Le mot de passe pour votre surnom est: %s
	
	Ce courrier a t expdi par %s en rponse  la requte SENDPASS de
	%s@%s.

# SENDPASS responses
NICK_SENDPASS_SYNTAX
	SENDPASS surnom
NICK_SENDPASS_FAILED
	Dsol, l'envois de mot de passe a choue.
NICK_SENDPASS_NO_EMAIL
	Le surnom %s n'a pas d'adresse courriel slectionne.
NICK_SENDPASS_NOT_AUTHED
	L'adresse courriel pour le surnom %s n'est pas encore autorise.
# parameter is "NNN days/hours/minutes"
NICK_SENDPASS_TOO_SOON
	S.V.P. attendez %s avant d'utiliser la commande SENDPASS  nouveau.
NICK_SENDPASS_SENT
	Le mot de passe pour le surnom %s a t expdi  son adresse courriel enregistre.

###########################################################################
#
# ChanServ messages
#
###########################################################################

# Access level descriptions
CHAN_LEVEL_AUTOOP
	Status d'oprateur de canal automatique
CHAN_LEVEL_AUTOVOICE
	Mode +v automatique
CHAN_LEVEL_INVITE
	Autoris  utiliser la commande INVITE
CHAN_LEVEL_AKICK
	Autoris  utiliser la commande AKICK
CHAN_LEVEL_SET
	Autoris  utiliser la commande SET (exception faite de FOUNDER/PASSWORD)
CHAN_LEVEL_CLEAR
	Autoris  utiliser la commande CLEAR
CHAN_LEVEL_UNBAN
	Autoris  utiliser la commande UNBAN
CHAN_LEVEL_OPDEOP
	Autoris  utiliser les commandes OP/DEOP
CHAN_LEVEL_ACCESS_LIST
	Autoris  visualiser la liste des accs
CHAN_LEVEL_ACCESS_CHANGE
	Autoris  modifier la liste d'accs
CHAN_LEVEL_MEMO
	Autoris  lister et lire les messages du canal
CHAN_LEVEL_VOICE
	Autoris  utiliser les commandes VOICE/DEVOICE
CHAN_LEVEL_AUTOHALFOP
	Mode +h automatique
CHAN_LEVEL_HALFOP
	Autoris  utiliser les commandes HALFOP/DEHALFOP
CHAN_LEVEL_AUTOPROTECT
	Status automatique de protection de canal (+a)
CHAN_LEVEL_PROTECT
	Autoris  utiliser les commandes PROTECT/DEPROTECT
CHAN_LEVEL_KICK
	Autoris  utiliser la commande d'expulsion KICK
CHAN_LEVEL_STATUS
	Autoris  utiliser la commande STATUS
CHAN_LEVEL_TOPIC
	Autoris  utiliser la commande d'invitation INVITE

# Automatic responses
CHAN_IS_REGISTERED
	Ce canal a t enregistr avec %s.
CHAN_MAY_NOT_BE_USED
	Ce canal ne peut tre utilis.
CHAN_NOT_ALLOWED_TO_JOIN
	Vous n'tes pas autoris  vous trouver sur ce canal.

# Multi-purpose responses
CHAN_MUST_IDENTIFY_NICK
	S.V.P. identifiez vous d'abord avec %s, par la commande:
	/msg %s IDENTIFY mot de passe
CHAN_BOUNCY_MODES
	Dsol, la commande %s est temporairement hors d'usage.

# REGISTER responses
CHAN_REGISTER_SYNTAX
	REGISTER canal mot de passe description
CHAN_REGISTER_DISABLED
	Dsol, l'enregistrement de canal est temporairement dsactive.
CHAN_REGISTER_SHORT_CHANNEL
	Le canal # ne peut pas tre enregistr.
CHAN_REGISTER_NOT_LOCAL
	Les canaux locaux ne peuvent tre enregistrs.
CHAN_REGISTER_INVALID_NAME
	Vous pouvez enregistrer seulement les canaux dont les noms commenant par #.
CHAN_MUST_REGISTER_NICK
	Vous devez enregistrer votre surnom d'abord.  Tapez /msg %s HELP pour plus d'information sur l'enregistrement de surnoms.
CHAN_MAY_NOT_BE_REGISTERED
	Le canal %s ne peut pas tre enregistr.
CHAN_ALREADY_REGISTERED
	Le canal %s est dj enregistr!
CHAN_MUST_BE_CHANOP
	Vous devez tre oprateur sur le canal afin de l'enregistrer.
CHAN_REACHED_CHANNEL_LIMIT
	Dsol, vous avez dj atteint votre limite de %d canaux.
CHAN_EXCEEDED_CHANNEL_LIMIT
	Dsol, vous avez dpass votre limite de %d canaux.
CHAN_REGISTRATION_FAILED
	Dsol, chec d'enregistrement.
CHAN_REGISTERED
	Le canal %s enregistr sous votre surnom: %s
CHAN_PASSWORD_IS
	Votre mot de passe de canal est %s -- retenez-le pour utilisation ultrieur.

# IDENTIFY responses
CHAN_IDENTIFY_SYNTAX
	IDENTIFY canal mot de passe
CHAN_IDENTIFY_FAILED
	Dsol, chec d'identification.
CHAN_IDENTIFY_SUCCEEDED
	Mot de passe accept -- vous avez maintenant accs  %s au niveau de propritaire.

# DROP responses
CHAN_DROP_SYNTAX
	DROP canal
CHAN_DROP_DISABLED
	Dsol, le dsenregistrement de canal est temporairement dsactiv.
CHAN_DROPPED
	Le canal %s est dsenregistr.

# SET responses
CHAN_SET_SYNTAX
	SET canal option paramtres
CHAN_SET_DISABLED
	Dsol, la slection d'option de canal est temporairement dsactive.
CHAN_SET_UNKNOWN_OPTION
	Option slectionne inconnue %s.

# SET FOUNDER responses
CHAN_SET_FOUNDER_TOO_MANY_CHANS
	%s a trop de canaux enregistrs.
CHAN_FOUNDER_CHANGED
	Le propritaire de %s a t chang pour %s.

# SET SUCCESSOR responses
CHAN_SUCCESSOR_CHANGED
	Le successeur de %s a t chang pour %s.
CHAN_SUCCESSOR_IS_FOUNDER
	Vous ne pouvez pas assigner le propritaire du canal  titre de successeur.

# SET PASSWORD responses
CHAN_SET_PASSWORD_FAILED
	Dsol, le mot de passe ne peut tre slectionn.
CHAN_PASSWORD_CHANGED
	Mot de passe de %s chang.
CHAN_PASSWORD_CHANGED_TO
	Le mot de passe de %s a t chang pour %s.

# SET DESC responses
CHAN_DESC_CHANGED
	Mot de passe de %s chang pour %s.

# SET URL responses
CHAN_URL_CHANGED
	L'URL pour %s chang pour %s.

# SET EMAIL responses
CHAN_EMAIL_CHANGED
	L'adresse courriel pour %s est change pour %s.

# SET ENTRYMSG responses
CHAN_ENTRY_MSG_CHANGED
	Le message d'acceuil pour %s est chang.

# SET MLOCK responses
CHAN_SET_MLOCK_NEED_PLUS_MINUS
	La liste des modes doit commencer par un + (plus) ou un - (moins).
CHAN_SET_MLOCK_NEED_PARAM
	Paramtre +%c requis pour le mode vrouill (MLOCK).
CHAN_SET_MLOCK_NEED_POSITIVE
	Le paramtre pour le mode de vrouillage MLOCK +%c doit tre un nombre positif.
CHAN_SET_MLOCK_MODE_REG_BAD
	Le mode +%c est toujours prsent sur un canal enregistr, et ne peut pas tre utilis avec MLOCK.
CHAN_SET_MLOCK_LINK_BAD
	Le paramtre +%c pour MLOCK n'est pas un nom de canal valide.
CHAN_SET_MLOCK_LINK_SAME
	Le paramtre +%c pour MLOCK doit tre un canal diffrent.
CHAN_SET_MLOCK_REQUIRES
	Le mode MLOCK +%c requiert que MLOCK +%c soit slectionn comme il faut.
CHAN_SET_MLOCK_BAD_PARAM
	Paramtre invalide pour MLOCK +%c.
CHAN_SET_MLOCK_UNKNOWN_CHAR
	Caractre de mode inconnu %c ignor.
CHAN_SET_MLOCK_CANNOT_LOCK
	Le mode %c ne peut pas tre vrouill.
CHAN_MLOCK_CHANGED
	Le mode vrouill sur le canal %s est chang pour %s.
CHAN_MLOCK_REMOVED
	Mode vrouill sur le canal %s retir.

# SET HIDE responses
CHAN_SET_HIDE_SYNTAX
	SET canal HIDE {EMAIL | TOPIC | MLOCK} {ON | OFF}
CHAN_SET_HIDE_EMAIL_ON
	L'adresse courriel du canal %s sera maintenant masque lors de l'affichage %s INFO.
CHAN_SET_HIDE_EMAIL_OFF
	L'adresse courriel du canal %s sera maintenant prsente lors de l'affichage %s INFO.
CHAN_SET_HIDE_TOPIC_ON
	Le sujet du canal %s sera maintenant masque lors de l'affichage %s INFO.
CHAN_SET_HIDE_TOPIC_OFF
	Le sujet du canal %s sera maintenant prsent lors de l'affichage %s INFO.
CHAN_SET_HIDE_MLOCK_ON
	Le mode vrouill du canal %s sera maintenant masqu lors de l'affichage %s INFO.
CHAN_SET_HIDE_MLOCK_OFF
	Le mode vrouill du canal %s sera maintenant prsent lors de l'affichage %s INFO.

# SET KEEPTOPIC responses
CHAN_SET_KEEPTOPIC_SYNTAX
	SET canal KEEPTOPIC {ON | OFF}
CHAN_SET_KEEPTOPIC_ON
	L'option de retenue de sujet est maintenant ON.
CHAN_SET_KEEPTOPIC_OFF
	L'option de retenue de sujet est maintenant ON.

# SET TOPICLOCK responses
CHAN_SET_TOPICLOCK_SYNTAX
	SET canal TOPICLOCK {ON | OFF}
CHAN_SET_TOPICLOCK_ON
	L'option de rtention de sujet est maintenant ON.
CHAN_SET_TOPICLOCK_OFF
	Option de rtention de sujet maintenant  OFF.

# SET PRIVATE responses
CHAN_SET_PRIVATE_SYNTAX
	SET canal PRIVATE {ON | OFF}
CHAN_SET_PRIVATE_ON
	Option prive maintenant ON.
CHAN_SET_PRIVATE_OFF
	Option prive maintenant OFF.

# SET SECUREOPS responses
CHAN_SET_SECUREOPS_SYNTAX
	SET canal SECUREOPS {ON | OFF}
CHAN_SET_SECUREOPS_ON
	L'option d'oprateurs scurise est maintenant ON.
CHAN_SET_SECUREOPS_OFF
	L'option d'oprateurs scurise est maintenant OFF.

# SET LEAVEOPS responses
CHAN_SET_LEAVEOPS_SYNTAX
	SET canal LEAVEOPS {ON | OFF}
CHAN_SET_LEAVEOPS_ON
	L'option de dpart des oprateurs est maintenant ON.
CHAN_SET_LEAVEOPS_OFF
	L'option de dpart des oprateurs est maintenant OFF.

# SET RESTRICTED responses
CHAN_SET_RESTRICTED_SYNTAX
	SET canal RESTRICTED {ON | OFF}
CHAN_SET_RESTRICTED_ON
	L'option de restriction d'accs est maintenant ON.
CHAN_SET_RESTRICTED_OFF
	L'option de restriction d'accs est maintenant OFF.

# SET SECURE responses
CHAN_SET_SECURE_SYNTAX
	SET canal SECURE {ON | OFF}
CHAN_SET_SECURE_ON
	L'option de scurit est maintenant ON.
CHAN_SET_SECURE_OFF
	L'option de scurit est maintenant OFF.

# SET OPNOTICE responses
CHAN_SET_OPNOTICE_SYNTAX
	SET canal OPNOTICE {ON | OFF}
CHAN_SET_OPNOTICE_ON
	L'option Notice-Oprateur est maintenant ON.
CHAN_SET_OPNOTICE_OFF
	L'option Notice-Oprateur est maintenant OFF.

# SET ENFORCE responses
CHAN_SET_ENFORCE_SYNTAX
	SET canal ENFORCE {ON | OFF}
CHAN_SET_ENFORCE_ON
	L'option de rgulation (ENFORCE) est maintenant ON.
CHAN_SET_ENFORCE_OFF
	L'option de rgulation (ENFORCE) est maintenant OFF.

# SET NOEXPIRE responses
CHAN_SET_NOEXPIRE_SYNTAX
	SET canal NOEXPIRE {ON | OFF}
CHAN_SET_NOEXPIRE_ON
	Le canal %s n'expirera pas.
CHAN_SET_NOEXPIRE_OFF
	Le canal %s va expirer.

# UNSET responses
CHAN_UNSET_SYNTAX
	UNSET canal {SUCCESSOR | URL | EMAIL | ENTRYMSG}
CHAN_SUCCESSOR_UNSET
	Le successeur pour %s n'est pas dtermin.
CHAN_URL_UNSET
	L'URL pour %s n'est pas dtermin.
CHAN_EMAIL_UNSET
	L'adresse courriel pour %s n'est pas dtermine.
CHAN_ENTRY_MSG_UNSET
	Le message d'acceuil pour %s n'est pas dtermin.

# ACCESS messages
CHAN_ACCESS_SYNTAX
	ACCESS canal {ADD | DEL | LIST | COUNT} [surnom [niveau] | liste d'entre]
CHAN_ACCESS_DISABLED
	Dsol, la modification de liste d'accs est temporairement dsactive.
CHAN_ACCESS_LEVEL_NONZERO
	Le niveau de l'accs doit tre diffrent de zro.
CHAN_ACCESS_LEVEL_RANGE
	Le niveau de l'accs doit tre compris entre %d et %d inclusivement.
CHAN_ACCESS_NICKS_ONLY
	La liste d'accs du canal ne peut contenir exclisivement que des surnoms enregistrs.
CHAN_ACCESS_REACHED_LIMIT
	Dsol, vous pouvez avoir seulement %d entres d'accs sur un canal.
CHAN_ACCESS_LEVEL_UNCHANGED
	Le niveau d'accs pour %s sur %s non-modifi de %d.
CHAN_ACCESS_LEVEL_CHANGED
	Le niveau d'accs pour %s sur %s chang  %d.
CHAN_ACCESS_ADDED
	%s ajout  la liste d'accs de %s  un niveau de %d.
CHAN_ACCESS_NO_SUCH_ENTRY
	Aucune entre (#%d) sur la liste d'accs de %s.
CHAN_ACCESS_NOT_FOUND
	%s n'a pas t trouv dans la liste d'accs de %s.
CHAN_ACCESS_NO_MATCH
	Aucune entre correspondante dans la liste d'accs de %s.
CHAN_ACCESS_DELETED
	%s suprim de la liste d'accs de %s.
CHAN_ACCESS_DELETED_ONE
	Une entre suprime de la liste d'accs de %s.
CHAN_ACCESS_DELETED_SEVERAL
	%d entres suprimes de la liste d'accs de %s.
CHAN_ACCESS_LIST_EMPTY
	La liste d'accs de %s est vide.
CHAN_ACCESS_LIST_HEADER
	Liste d'accs pour %s:
	  Num   Niv  Surnom
CHAN_ACCESS_LIST_FORMAT
	 %4d  %4d  %s
CHAN_ACCESS_COUNT
	La liste d'accs de %s a %d entres.
	
# XOP (AOP/SOP/VOP) responses
CHAN_SOP_SYNTAX
	SOP canal {ADD | DEL | LIST | COUNT} [surnom | entre-liste]
CHAN_AOP_SYNTAX
	AOP canal {ADD | DEL | LIST | COUNT} [surnom | entre-liste]
CHAN_HOP_SYNTAX
	HOP canal {ADD | DEL | LIST | COUNT} [surnom | entre-liste]
CHAN_VOP_SYNTAX
	VOP canal {ADD | DEL | LIST | COUNT} [surnom | entre-liste]
CHAN_XOP_ADDED
	%s ajout  la liste de %s %s.
CHAN_XOP_LEVEL_CHANGED
	%s dplac vers la liste %s %s.
CHAN_XOP_LEVEL_UNCHANGED
	%s est dj sur la liste %s %s.
CHAN_XOP_NICKS_ONLY
	Les listes SOP, AOP, et VOP doivent contenir exclusivement des surnoms enregistrs.
CHAN_XOP_NICKS_ONLY_HOP
	Les listes SOP, AOP, HOP, et VOP doivent contenir exclusivement des surnoms enregistrs.
CHAN_XOP_REACHED_LIMIT
	Dsol, le nombre d'entres sur vos listes SOP, AOP et VOP
	ne peuvent pas totaliser plus de %d entres.  Limite dpasse.
CHAN_XOP_REACHED_LIMIT_HOP
	Dsol, le nombre d'entres sur vos listes SOP, AOP, HOP et VOP
	ne peuvent pas totaliser plus de %d entres.  Limite dpasse.
CHAN_XOP_NOT_FOUND
	%s non dcouvert sur la liste %s %s.
CHAN_XOP_NO_SUCH_ENTRY
	Il n'y a plus d'entres (#%d) sur la liste %s %s.
CHAN_XOP_NO_MATCH
	Aucune entre correspondante sur la liste %s %s.
CHAN_XOP_DELETED
	%s suprime de la liste %s %s.
CHAN_XOP_DELETED_ONE
	Une entre suprime de la liste %s %s.
CHAN_XOP_DELETED_SEVERAL
	%d entres suprimes de la liste %s %s.
CHAN_XOP_LIST_EMPTY
	La liste %s %s est vide.
CHAN_XOP_LIST_HEADER
	Liste %s pour %s:
	  Num   Surnom
CHAN_XOP_LIST_FORMAT
	 %4d   %s
CHAN_XOP_COUNT
	La liste %s %s a %d entres.
	
# AKICK responses
CHAN_AKICK_SYNTAX
	AKICK canal {ADD | DEL | LIST | VIEW | ENFORCE | COUNT} [masque | liste]
CHAN_AKICK_DISABLED
	Dsol, la modification de liste d'autokick est temporairement impossible.
CHAN_AKICK_ALREADY_EXISTS
	%s existe dj sur la liste d'autokick de %s.
CHAN_AKICK_REACHED_LIMIT
	Dsol, vous pouvez avoir seulement %d entres sur la liste de masques autokick du canal.
CHAN_AKICK_ADDED
	%s ajout  la liste d'autokick de %s.
CHAN_AKICK_NO_SUCH_ENTRY
	Plus d'entres (#%d) sur la liste autokick de %s.
CHAN_AKICK_NOT_FOUND
	%s introuv dans la liste d'autokick de %s.
CHAN_AKICK_NO_MATCH
	Aucune entre correspondante dans la liste d'autokick de %s.
CHAN_AKICK_DELETED
	%s suprim de la liste autokick de %s.
CHAN_AKICK_DELETED_ONE
	Une entre suprime de la liste d'autokick de %s.
CHAN_AKICK_DELETED_SEVERAL
	%d entres suprimes de la liste d'autokick de %s.
CHAN_AKICK_LIST_EMPTY
	La liste d'autokick de %s est vide.
CHAN_AKICK_LIST_HEADER
	Liste d'autokick pour %s:
# index, mask, set-by, set-time, last-used, reason
CHAN_AKICK_VIEW_FORMAT
	  %3d %s (par %s sur %s; dernire utilisation %s)
	    %s
# index, mask, set-by, set-time, reason
CHAN_AKICK_VIEW_UNUSED_FORMAT
	  %3d %s (par %s sur %s; jamais utilis)
	    %s
CHAN_AKICK_ENFORCE_DONE
	AKICK ENFORCE pour %s complt; %d usagers ont t affects.
CHAN_AKICK_COUNT
	%s a %d entres sur sa liste d'AKICK.

# LEVELS responses
CHAN_LEVELS_SYNTAX
	LEVELS canal {SET | DIS[ABLE] | LIST | RESET} [item [niveau]]
CHAN_LEVELS_RANGE
	Le niveau doit tre entre %d et %d inclusivement.
CHAN_LEVELS_CHANGED
	Le niveau pour %s sur le canal %s chang  %d.
CHAN_LEVELS_UNKNOWN
	Ajustement %s inconnu.  Tapez /msg %s HELP LEVELS DESC pour une liste des ajustements valides.
CHAN_LEVELS_DISABLED
	%s dsactiv sur le canal %s.
CHAN_LEVELS_LIST_HEADER
	Ajustement des niveaux d'accs pour le canal %s:
CHAN_LEVELS_LIST_DISABLED
	    %-*s  (disactiv)
CHAN_LEVELS_LIST_FOUNDER
	    %-*s  (propritaire seulement)
CHAN_LEVELS_LIST_NORMAL
	    %-*s  %4d
CHAN_LEVELS_RESET
	Niveau d'accs pour %s rtablit  la valeur par dfaut.

# INFO responses
CHAN_INFO_SYNTAX
	INFO canal [ALL]
CHAN_INFO_HEADER
	Information pour le canal %s:
CHAN_INFO_FOUNDER
	        Propritaire: %s
CHAN_INFO_SUCCESSOR
	          Successeur: %s
CHAN_INFO_DESCRIPTION
	         Description: %s
CHAN_INFO_ENTRYMSG
	    Message d'entre: %s
CHAN_INFO_TIME_REGGED
	          Enregistr: %s
CHAN_INFO_LAST_USED
	Dernire utilisation: %s
CHAN_INFO_LAST_TOPIC
	       Dernier sujet: %s
CHAN_INFO_TOPIC_SET_BY
	 Sujet dtermin par: %s
CHAN_INFO_URL
	                 URL: %s
CHAN_INFO_EMAIL
	    Adresse courriel: %s
CHAN_INFO_OPTIONS
	             Options: %s
CHAN_INFO_OPT_PRIVATE
	Priv
CHAN_INFO_OPT_KEEPTOPIC
	Rtention de sujet
CHAN_INFO_OPT_TOPICLOCK
	Sujet bloqu
CHAN_INFO_OPT_SECUREOPS
	Oprateurs avec accs seulement
CHAN_INFO_OPT_LEAVEOPS
	Dpart des oprateurs
CHAN_INFO_OPT_RESTRICTED
	Accs restreint
CHAN_INFO_OPT_SECURE
	Scurit
CHAN_INFO_OPT_OPNOTICE
	Notice d'oprateur
CHAN_INFO_OPT_ENFORCE
	Rgulation (ENFORCE)
CHAN_INFO_OPT_NONE
	Aucun
CHAN_INFO_MODE_LOCK
	      Mode(s) barr(s): %s
CHAN_INFO_NO_EXPIRE
	Ce canal n'aura pas d'expiration.
CHAN_INFO_SUSPEND_DETAILS
	Suspendu par %s le %s (%s).
CHAN_INFO_SUSPEND_REASON
	Raison: %s
CHAN_INFO_SHOW_ALL
	Pour plus d'information, tapez: /msg %s INFO %s ALL

# LIST responses
CHAN_LIST_SYNTAX
	LIST modle
CHAN_LIST_OPER_SYNTAX
	LIST modle [FORBIDDEN] [NOEXPIRE] [SUSPENDED]
CHAN_LIST_HEADER
	Liste des entres correspondantes au modle %s:
CHAN_LIST_END
	Fin de la liste; %d/%d correspondances prsentes.

# INVITE responses
CHAN_INVITE_SYNTAX
	INVITE canal
CHAN_INVITE_OK
	Invitation de %s sur le canal %s.

# OP/DEOP/VOICE/DEVOICE responses
CHAN_OPVOICE_SYNTAX
	%s canal [surnom]
CHAN_OP_SUCCEEDED
	%s a obtenu le status d'oprateur sur le canal %s.
CHAN_OP_ALREADY
	%s est actuellement oprateur sur le canal %s.
CHAN_OP_FAILED
	Incapable d'accorder le status d'opratuer  %s sur le canal %s.
CHAN_DEOP_SUCCEEDED
	Status d'oprateur de %s retir sur le canal %s.
CHAN_DEOP_ALREADY
	%s n'a dj plus de status d'oprateur sur le canal %s.
CHAN_DEOP_FAILED
	Incapable de retirer le status d'oprateur de %s sur le canal %s.
CHAN_VOICE_SUCCEEDED
	%s a obtenu les privilges vocaux (mode +v) sur le canal %s.
CHAN_VOICE_ALREADY
	%s a dj les privilges vocaux (mode +v) sur le canal %s.
CHAN_VOICE_FAILED
	Incapable d'accorder le status vocal  %s sur le canal %s.
CHAN_DEVOICE_SUCCEEDED
	%s n'a plus les privilges vocaux (mode +v) sur le canal %s.
CHAN_DEVOICE_ALREADY
	%s a dj les privilges vocaux (mode +v) sur le canal %s.
CHAN_DEVOICE_FAILED
	Incapable de retirer le status vocal de %s sur le canal %s.
CHAN_HALFOP_SUCCEEDED
	%s a obtenu les privilges de demi-oprateur sur le canal %s.
CHAN_HALFOP_ALREADY
	%s dtient dj les privilges de demi-oprateur sur le canal %s.
CHAN_HALFOP_FAILED
	Incapable d'accorder les privilges de demi-oprateur  %s sur le canal %s.
CHAN_DEHALFOP_SUCCEEDED
	Status de demi-oprateur de %s retir sur le canal %s.
CHAN_DEHALFOP_ALREADY
	%s n'a dj plus de status de demi-oprateur sur le canal %s.
CHAN_DEHALFOP_FAILED
	Incapable de retirer les privilges de demi-oprateur de %s sur le canal %s.
CHAN_PROTECT_SUCCEEDED
	%s protg sur le canal %s.
CHAN_PROTECT_ALREADY
	%s est actuellement protg sur le canal %s.
CHAN_PROTECT_FAILED
	Incapable de protger %s sur le canal %s.
CHAN_DEPROTECT_SUCCEEDED
	Retrait de protection de %s sur le canal %s.
CHAN_DEPROTECT_ALREADY
	%s est actuellement sans protection sur le canal %s.
CHAN_DEPROTECT_FAILED
	Incapable de retirer la protection de %s sur le canal %s.

# UNBAN responses
CHAN_UNBAN_SYNTAX
	UNBAN canal
CHAN_UNBANNED
	Vous avez t dbanni de %s.

# KICK responses
CHAN_KICK_SYNTAX
	KICK canal surnom [raison]
CHAN_KICK_PROTECTED
	%s ne peut pas tre expuls du canal %s.
CHAN_KICKED
	%s expuls du canal %s.

# TOPIC responses
CHAN_TOPIC_SYNTAX
	TOPIC canal sujet

# CLEAR responses
CHAN_CLEAR_SYNTAX
	CLEAR canal quoi
CHAN_CLEARED_BANS
	Toutes les proscriptions (bans) inscrites pour le canal %s ont t retires.
CHAN_CLEARED_EXCEPTIONS
	Toutes les exceptions sur le canal %s ont t retires.
CHAN_CLEARED_MODES
	Tous les modes sur le canal %s ont t remis  leur valeur par dfaut.
CHAN_CLEARED_OPS
	Le mode +o a t effac pour le canal %s.
CHAN_CLEARED_HALFOPS
	Le mode +h a t effac pour le canal %s.
CHAN_CLEARED_VOICES
	Le mode +v a t effac pour le canal %s.
CHAN_CLEARED_USERS
	Tous les usagers ont t expuls du canal %s.

# GETPASS responses
CHAN_GETPASS_SYNTAX
	GETPASS canal
CHAN_GETPASS_UNAVAILABLE
	La commande GETPASS n'est pas disponible car l'encryption est en utilisation.
CHAN_GETPASS_PASSWORD_IS
	Le mot de passe pour le canal %s est %s.

# FORBID responses
CHAN_FORBID_SYNTAX
	FORBID canal
CHAN_FORBID_SHORT_CHANNEL
	Le canal # ne peut pas tre interdit.
CHAN_FORBID_SUCCEEDED
	Le canal %s est maintenant interdit.
CHAN_FORBID_FAILED
	Ne peut pas interdire le canal %s!

# SUSPEND responses
CHAN_SUSPEND_SYNTAX
	SUSPEND [+expiration] canal raison
CHAN_SUSPEND_SUCCEEDED
	Le canal %s a t suspendu.
CHAN_SUSPEND_ALREADY_SUSPENDED
	Le canal %s a t suspendu.

# UNSUSPEND responses
CHAN_UNSUSPEND_SYNTAX
	UNSUSPEND canal
CHAN_UNSUSPEND_SUCCEEDED
	Le canal %s n'est plus suspendu.
CHAN_UNSUSPEND_NOT_SUSPENDED
	Le canal %s n'est pas suspendu.

################ sendpass module messages/responses

# Mail text
CHAN_SENDPASS_MAIL_SUBJECT
	Mot de passe pour %s
CHAN_SENDPASS_MAIL_BODY
	Le mot de passe pour le canal %s est: %s
	
	Ce courriel a t expdi par %s en rponse  la requte SENDPASS de
	%s@%s.
	
# SENDPASS responses
CHAN_SENDPASS_SYNTAX
	SENDPASS canal
CHAN_SENDPASS_FAILED
	Dsol, l'envois de mot de passe a choue.
CHAN_SENDPASS_FOUNDER_ONLY
	Seul le propritaire du canal peut utiliser la commande SENDPASS.
CHAN_SENDPASS_NO_EMAIL
	Vous n'avez pas d'adresse courriel tablie pour votre surnom.
# parameter is "NNN days/hours/minutes"
CHAN_SENDPASS_TOO_SOON
	S.V.P. attendez %s avant d'utiliser la commande SENDPASS de nouveau.
CHAN_SENDPASS_SENT
	Le mot de passe pour le canal %s a t expdi  %s.

###########################################################################
#
# MemoServ messages
#
###########################################################################

# Automatic messages
MEMO_HAVE_NEW_MEMO
	Vous avez 1 nouveau message.
MEMO_HAVE_NEW_MEMOS
	Vous avez %d nouveaux messages.
MEMO_TYPE_READ_LAST
	Tapez /msg %s READ LAST pour le lire.
MEMO_TYPE_READ_NUM
	Tapez /msg %s READ %d pour les lire.
MEMO_TYPE_LIST_NEW
	Tapez /msg %s LIST NEW pour les lister.
MEMO_AT_LIMIT
	Attention: Vous avez atteint votre nombre maximum de messages (%d).  Vous ne pourrez pas en recevoir de nouveau tant que vous n'en aurez pas effac $
MEMO_OVER_LIMIT
	Attention: Vous excdez votre nombre maximum de messages (%d).  Vous ne pourrez pas en recevoir de nouveau tant que vous n'en aurez pas effac $
MEMO_NEW_MEMO_ARRIVED
	Vous avez un nouveau message de %s.
	Tapez /msg %s READ %d pour le lire.

# Multi-use responses
MEMO_HAVE_NO_MEMOS
	Vous n'avez aucun messages.
MEMO_X_HAS_NO_MEMOS
	%s n'a aucun messages.
MEMO_DOES_NOT_EXIST
	Le message %d n'existe pas!
MEMO_LIST_NOT_FOUND
	Aucun message correspondant trouv.

# SEND responses
MEMO_SEND_SYNTAX
	SEND {surnom | canal} texte-du-message
MEMO_SEND_DISABLED
	Dsol, l'envois de message est temporairement impossible.
MEMO_SEND_PLEASE_WAIT
	S.V.P. attendez %s avant d'utiliser la commande SEND de nouveau.
MEMO_X_GETS_NO_MEMOS
	%s ne peut pas recevoir de messages.
MEMO_X_HAS_TOO_MANY_MEMOS
	%s a prsentement trop de messages et ne peut en recevoir plus.
MEMO_SENT
	Message expdi  %s.

# LIST responses
MEMO_LIST_SYNTAX
	LIST [canal] [num | liste | NEW]
MEMO_HAVE_NO_NEW_MEMOS
	Vous n'avez aucun nouveaux messages.
MEMO_X_HAS_NO_NEW_MEMOS
	%s n'a aucun nouveaux messages.
MEMO_LIST_MEMOS
	Messages pour %s.  Pour en faire la lecture, tapez: /msg %s READ num
MEMO_LIST_NEW_MEMOS
	Nouveau message pour %s.  Pour en faire la lecture, tapez: /msg %s READ num
MEMO_LIST_CHAN_MEMOS
	Messages pour %s.  Pour en faire la lecture, tapez: /msg %s READ %s num
MEMO_LIST_CHAN_NEW_MEMOS
	Nouveaux messages pour %s.  Pour en faire la lecture, tapez: /msg %s READ %s num
MEMO_LIST_HEADER
	Num  Expditeur         Date/Heure
MEMO_LIST_FORMAT
	%c%c%3d  %-16s  %s

# READ responses
MEMO_READ_SYNTAX
	READ [canal] {num | liste | LAST | NEW}
MEMO_HEADER
	Message %d de %s (%s).  Pour le suprimer, tapez: /msg %s DEL %d
MEMO_CHAN_HEADER
	Message %d de %s (%s).  Pour le suprimer, tapez: /msg %s DEL %s %d

# SAVE responses
MEMO_SAVE_SYNTAX
	SAVE [canal] {num | liste}
MEMO_SAVED_ONE
	Message %d marqu "sans expiration".
MEMO_SAVED_SEVERAL
	%d messages marqus "sans expiration".

# DEL responses
MEMO_DEL_SYNTAX
	DEL [canal] {num | liste | ALL}
MEMO_DELETED_NONE
	Aucun message n'a t effac.
MEMO_DELETED_ONE
	%d messages ont t effacs.
MEMO_DELETED_SEVERAL
	%d messages ont t effacs.
MEMO_DELETED_ALL
	Tous vos messages ont t effacs.

# SET responses
MEMO_SET_SYNTAX
	SET option paramtres
MEMO_SET_DISABLED
	Dsol, la slection d'options de messagerie est temporairement impossible.
MEMO_SET_UNKNOWN_OPTION
	Option SET inconnue %s.

# SET NOTIFY responses
MEMO_SET_NOTIFY_SYNTAX
	SET NOTIFY {ON | LOGON | NEW | OFF}
MEMO_SET_NOTIFY_ON
	%s vous avertira de vos nouveaux messages lors de votre connection ainsi que lorsqu'ils vous seront expdis.
MEMO_SET_NOTIFY_LOGON
	%s vous avertira maintenant de vos messages lors de votre connection sur ou retrait de /AWAY.
MEMO_SET_NOTIFY_NEW
	%s vous avisera de vos nouveaux messages losrqu'ils vous seront expdis.
MEMO_SET_NOTIFY_OFF
	%s ne vous avisera pas  propos de l'tat de votre messagerie.

# SET LIMIT responses
MEMO_SET_LIMIT_SYNTAX
	SET LIMIT [canal] limite
MEMO_SET_LIMIT_OPER_SYNTAX
	SET LIMIT [surnom | canal] {limite | NONE | DEFAULT} [HARD]
MEMO_SET_YOUR_LIMIT_FORBIDDEN
	Vous n'tes pas autoris  modifier votre limite de message.
MEMO_SET_LIMIT_FORBIDDEN
	La limite de message pour %s ne peut pas tre change.
MEMO_SET_YOUR_LIMIT_TOO_HIGH
	Vous ne pouvez pas slectionner une limite de message supprieure  %d.
MEMO_SET_LIMIT_TOO_HIGH
	Vous ne pouvez pas slectionner de limite de message pour %s suprieure  %d.
MEMO_SET_LIMIT_OVERFLOW
	Limite de message trop leve; limit  %d  la place.
MEMO_SET_YOUR_LIMIT
	Votre limite de message a t dtermine  %d.
MEMO_SET_YOUR_LIMIT_ZERO
	Vous ne pourrez plus recevoir de messages.
MEMO_SET_YOUR_LIMIT_DEFAULT
	Votre limite de message a t dtermine  sa valeur par dfaut (%d).
MEMO_UNSET_YOUR_LIMIT
	Votre limite de message a t dsactive.
MEMO_SET_LIMIT
	Limite de message pour %s dtermine  %d.
MEMO_SET_LIMIT_ZERO
	Limite de message pour %s dtermine  0.
MEMO_SET_LIMIT_DEFAULT
	Limite de message pour %s dtermine  dfaut (%d).
MEMO_UNSET_LIMIT
	Limite de message dsactive for %s.

# INFO responses
MEMO_INFO_NO_MEMOS
	Vous n'avez prsentement aucun message.
MEMO_INFO_MEMO
	Vous avez prsentement 1 message.
MEMO_INFO_MEMO_UNREAD
	Vous avez prsentement 1 message(s), et il(s) n'est/ont toujours pas t lu(s).
MEMO_INFO_MEMOS
	Vous avez prsentement %d messages.
MEMO_INFO_MEMOS_ONE_UNREAD
	Vous avez prsentement %d messages, dont 1 non-lu.
MEMO_INFO_MEMOS_SOME_UNREAD
	Vous avez prsentement %d messages, dont %d n'ont t lus.
MEMO_INFO_MEMOS_ALL_UNREAD
	Vous avez prsentement %d messages; aucun d'entre eux n'ont t lus.
MEMO_INFO_LIMIT
	Votre limite de message est de %d.
MEMO_INFO_HARD_LIMIT
	Votre limite de message est de %d, et ne peut pas tre change.
MEMO_INFO_LIMIT_ZERO
	Votre limite de message est de 0; vous ne recevrez pas aucun nouveau message.
MEMO_INFO_HARD_LIMIT_ZERO
	Votre limite de message est de 0; vous ne recevrez pas aucun nouveau message.  Vous ne pouvez pas changer cette limite.
MEMO_INFO_NO_LIMIT
	Vous n'avez aucune limite relative au nombre de message que vous pouvez conserver.
MEMO_INFO_NOTIFY_OFF
	Vous ne serez plus avertis des nouveaux messages.
MEMO_INFO_NOTIFY_ON
	Vous serez inform de vos nouveaux messages lors de votre connection et lorsqu'ils entreront.
MEMO_INFO_NOTIFY_RECEIVE
	Vous serez informs de vos nouveaux messages lors de leur arrive.
MEMO_INFO_NOTIFY_SIGNON
	Vous serez avis de vos nouveaux messages lors de votre connection sur l'IRC.
MEMO_INFO_X_NO_MEMOS
	%s n'a actuellement aucun messages.
MEMO_INFO_X_MEMO
	%s a actuellement 1 message.
MEMO_INFO_X_MEMO_UNREAD
	%s actuellement a 1 message, et il n'est pas lu.
MEMO_INFO_X_MEMOS
	%s actuellement a %d messages.
MEMO_INFO_X_MEMOS_ONE_UNREAD
	%s actuellement a %d messages, dont 1 non-lu.
MEMO_INFO_X_MEMOS_SOME_UNREAD
	%s actuellement a %d messages, dont %d sont non-lus.
MEMO_INFO_X_MEMOS_ALL_UNREAD
	%s actuellement a %d messages; aucun d'entreux n'est lu.
MEMO_INFO_X_LIMIT
	La limite de message de %s est de %d.
MEMO_INFO_X_HARD_LIMIT
	La limite de message de %s est de %d, et ne peut pas tre change.
MEMO_INFO_X_NO_LIMIT
	%s n'a pas de limite de message.
MEMO_INFO_X_NOTIFY_OFF
	%s n'est pas avis de ses nouveaux messages.
MEMO_INFO_X_NOTIFY_ON
	%s est avis de ses messages  la connection et lors de leur arrive.
MEMO_INFO_X_NOTIFY_RECEIVE
	%s est avis lors de l'arrive de nouveaux messages.
MEMO_INFO_X_NOTIFY_SIGNON
	%s est avis lors de sa connection de ses nouveaux messages.

################ forward module messages/responses

# Mail format
MEMO_FORWARD_MAIL_SUBJECT
	Messages pour %s
MEMO_FORWARD_MAIL_BODY
	Message de %s (%s)
	%s

# FORWARD responses
MEMO_FORWARD_SYNTAX
	FORWARD {num | liste | ALL}
MEMO_FORWARD_NEED_EMAIL
	Vous devez avoir fourni pralablement une adresse de courriel avant que vos messages puissent vous y tre re-transmis.
MEMO_FORWARD_PLEASE_WAIT
	S.V.P. attendez %s avant d'utiliser la commande FORWARD de nouveau.
MEMO_FORWARD_FAILED
	Dsol, la re-transmission de messagerie a chou.
MEMO_FORWARDED_NONE
	Aucun message n'a t re-transmit.
MEMO_FORWARDED_ONE
	Le message %d a t re-transmit.
MEMO_FORWARDED_SEVERAL
	%d messages ont t re-transmis.
MEMO_FORWARDED_ALL
	Tous vos messages ont t retransmis.
MEMO_FORWARDED_ALSO_TEMPFAIL
	Avis: Certains messages n'ont t re-transmis car le systme tait surcharg.
MEMO_FORWARDED_ALSO_PERMFAIL
	Avis: Certains messages n'ont t re-transmis en raison d'une esseur de systme.

# SET FORWARD responses
MEMO_SET_FORWARD_SYNTAX
	SET FORWARD {ON | COPY | OFF}
MEMO_SET_FORWARD_ON
	Vos messages seront re-transmis  votre adresse courriel : %s
MEMO_SET_FORWARD_COPY
	Vos messages seront maintenant re-transmis sur votre adresse courriel: %s
	Vos messages seront galement sauvs par les Services.
MEMO_SET_FORWARD_OFF
	Vos messages ne seront pas re-transmis  votre adresse courriel.

################ ignore module messages/responses

# IGNORE responses
MEMO_IGNORE_SYNTAX
	IGNORE {ADD | DEL | LIST} [surnom | masque]
MEMO_IGNORE_ADD_SYNTAX
	IGNORE ADD surnom | masque
MEMO_IGNORE_DEL_SYNTAX
	IGNORE DEL surnom | masque
MEMO_IGNORE_LIST_FULL
	Votre liste d'indsirables est pleine.
MEMO_IGNORE_ALREADY_PRESENT
	%s dj inscrit  votre liste d'indsirables.
MEMO_IGNORE_ADDED
	%s ajout  votre liste d'indsirables.
MEMO_IGNORE_NOT_FOUND
	%s n'a pas t apperu dans votre liste d'indsirables.
MEMO_IGNORE_DELETED
	%s effac de votre liste d'indsirables.
MEMO_IGNORE_LIST_EMPTY
	Votre liste d'indsirables est vide.
MEMO_IGNORE_LIST
	Liste d'indsirables:
MEMO_IGNORE_LIST_X_EMPTY
	La liste d'indsirables de %s est vide.
MEMO_IGNORE_LIST_X
	Liste d'indsirables pour %s:

###########################################################################
#
# OperServ messages
#
###########################################################################

# General messages
OPER_BOUNCY_MODES
	Les services sont incapables de changer les modes.  Vos servers sont-ils correctement configurs?
OPER_BOUNCY_MODES_U_LINE
	Les services ne peuvent changer les modes.  Les U:lines de vos servers sont-elles correctement configures?

# GLOBAL responses
OPER_GLOBAL_SYNTAX
	GLOBAL message

# STATS responses
OPER_STATS_UNKNOWN_OPTION
	Option STATS inconnue %s.
OPER_STATS_RESET_USER_COUNT
	Le maximum de comptes usagers a t mis  zro.

OPER_STATS_CURRENT_USERS
	Nombre actuel d'usagers: %d (%d ops)
OPER_STATS_MAX_USERS
	Maximum d'usagers: %d (%s)
# Parameters: days, STR_DAYS or STR_DAY, hours, minutes, seconds
OPER_STATS_UPTIME_DHMS
	Services en-ligne depuis %d%s, %02d:%02d
# If >= 1 hour, hours and minutes; if < 1 hour, minutes and seconds
OPER_STATS_UPTIME_HM_MS
	Services en-ligne depuis %s

OPER_STATS_KBYTES_READ
	Donnes reues:      %10u kB
OPER_STATS_KBYTES_WRITTEN
	Donnes expdies:   %10u kB
OPER_STATS_NETBUF_SOCK
	Base tampon de serveur:   %5u kB
OPER_STATS_NETBUF_SOCK_PERCENT
	Base tampon de serveur:   %5u kB (%d%%)
OPER_STATS_NETBUF_TOTAL
	Base tampon total:        %5u kB
OPER_STATS_NETBUF_TOTAL_PERCENT
	Base tampon total:        %5u kB (%d%%)

OPER_STATS_ALL_USER_MEM
	Usagers   : %6d registre, %5d kB
OPER_STATS_ALL_CHANNEL_MEM
	Canaux    : %6d registre, %5d kB
OPER_STATS_ALL_SERVER_MEM
	Servers   : %6d registre, %5d kB
OPER_STATS_ALL_NICKGROUPINFO_MEM
	Groupes de surnoms: %6d registre, %5d kB
OPER_STATS_ALL_NICKINFO_MEM
	Surnoms   : %6d registre, %5d kB
OPER_STATS_ALL_CHANSERV_MEM
	ChanServ  : %6d registre, %5d kB
OPER_STATS_ALL_STATSERV_MEM
	StatServ  : %6d registre, %5d kB
OPER_STATS_ALL_NEWS_MEM
	Nevelles  : %6d registre, %5d kB
OPER_STATS_ALL_AKILL_MEM
	Autokills : %6d registre, %5d kB
OPER_STATS_ALL_EXCEPTION_MEM
	Exceptions: %6d registre, %5d kB
OPER_STATS_ALL_SGLINE_MEM
	SGlines   : %6d registre, %5d kB
OPER_STATS_ALL_SQLINE_MEM
	SQlines   : %6d registre, %5d kB
OPER_STATS_ALL_SZLINE_MEM
	SZlines   : %6d registre, %5d kB
OPER_STATS_ALL_SESSION_MEM
	Sessions  : %6d registre, %5d kB

# MODE responses
OPER_MODE_SYNTAX
	MODE canal modes

# CLEARMODES responses
OPER_CLEARMODES_SYNTAX
	CLEARMODES canal [ALL]
OPER_CLEARMODES_DONE
	Modes binaires et bans effacs du canal %s.
OPER_CLEARMODES_EXCEPT_DONE
	Modes binaires, bans et exceptions effacs du canal %s.
OPER_CLEARMODES_ALL_DONE
	Tous les modes effacs du canal %s.

# CLEARCHAN responses
OPER_CLEARCHAN_SYNTAX
	CLEARCHAN canal
OPER_CLEARCHAN_DONE
	Tous les usagers expulss du canal %s.

# KICK responses
OPER_KICK_SYNTAX
	KICK canal usager raison

# ADMIN responses
OPER_ADMIN_SYNTAX
	ADMIN {ADD | DEL | LIST} [surnom]
OPER_ADMIN_ADD_SYNTAX
	ADMIN ADD surnom
OPER_ADMIN_DEL_SYNTAX
	ADMIN DEL surnom
OPER_ADMIN_NO_NICKSERV
	NickServ est prsentement hors-service; la commande ADMIN n'est pas disponible.
OPER_ADMIN_EXISTS
	%s existe dj sur la liste des Administrateurs des Services.
OPER_ADMIN_ADDED
	%s ajout  la liste des Administrateurs des Services.
OPER_ADMIN_TOO_MANY
	Trop d'entres (%d) sur la liste des Admin. des Services; ne peut en ajouter plus.
OPER_ADMIN_REMOVED
	%s retir de la liste des Admin. des Services.
OPER_ADMIN_NOT_FOUND
	%s n'apparait pas dans la liste des Admin. des Services.
OPER_ADMIN_LIST_HEADER
	Liste des Administrateurs des Services:

# OPER responses
OPER_OPER_SYNTAX
	OPER {ADD | DEL | LIST} [surnom]
OPER_OPER_ADD_SYNTAX
	OPER ADD surnom
OPER_OPER_DEL_SYNTAX
	OPER DEL surnom
OPER_OPER_NO_NICKSERV
	NickServ est prsentement hors-ligne; la commande OPER n'est pas disponible.
OPER_OPER_EXISTS
	%s existe dj dans la liste des Oprateurs des Services.
OPER_OPER_ADDED
	%s ajout  la liste des Oprateurs des Services.
OPER_OPER_TOO_MANY
	Trop d'entres (%d) sur la liste des Oprateurs des Services; ne peut en ajouter d'autre.
OPER_OPER_REMOVED
	%s retir de la liste des Oprateurs des Services.
OPER_OPER_NOT_FOUND
	%s n'apparait pas dans la liste des Oprateurs des Services.
OPER_OPER_LIST_HEADER
	Liste des Oprateurs des Services:

# AKILL responses
OPER_AKILL_SYNTAX
	AKILL {ADD | DEL | LIST | VIEW | COUNT} [[+expiration] masque [raison]]
OPER_AKILL_ADD_SYNTAX
	AKILL ADD [+expiration] masque raison
OPER_AKILL_DEL_SYNTAX
	AKILL DEL masque
OPER_TOO_MANY_AKILLS
	La liste des AKILL est pleine!
OPER_AKILL_EXISTS
	%s existe dj dans la liste des autokills.
OPER_AKILL_NO_NICK
	Avis: Les masques d'autokill ne peuvent pas contenir de surnoms; assurez-vous que vous n'avez pas inclus une portion surnom dans le masque.
OPER_AKILL_MASK_TOO_GENERAL
	Le masque d'autokill est trop gnral.
OPER_AKILL_EXPIRY_LIMITED
	Vous ne pouvez slectionner un moment d'expiration jusqu' %s.
OPER_AKILL_ADDED
	%s ajout  la liste d'autokill.
OPER_AKILL_REMOVED
	%s retir de la liste d'autokill.
OPER_AKILL_NOT_FOUND
	%s n'apparait pas  la liste d'autokill.
OPER_AKILL_LIST_HEADER
	Liste actuelle d'autokill:
# mask, reason
OPER_AKILL_LIST_FORMAT
	%-32s  %s
# mask, set-by, set-time, last-used, expires, reason
OPER_AKILL_VIEW_FORMAT
	%s (par %s sur %s, dernier usage %s; %s)
	    %s
# mask, set-by, set-time, expires, reason
OPER_AKILL_VIEW_UNUSED_FORMAT
	%s (par %s sur %s, jamais utilis; %s)
	    %s
OPER_AKILL_COUNT
	Il y a %d masques d'usager sur la liste d'autokill.

# EXCLUDE responses
OPER_EXCLUDE_SYNTAX
	EXCLUDE {ADD | DEL | LIST | VIEW | COUNT} [[+expiration] masque [raison]]
OPER_EXCLUDE_ADD_SYNTAX
	EXCLUDE ADD [+expiration] masque raison
OPER_EXCLUDE_DEL_SYNTAX
	EXCLUDE DEL masque
OPER_TOO_MANY_EXCLUDES
	La liste EXCLUDE est pleine!
OPER_EXCLUDE_EXISTS
	%s existe dj sur la liste d'exclusion d'autokill.
OPER_EXCLUDE_ADDED
	%s ajout  la liste d'exclusion d'autokill.
OPER_EXCLUDE_REMOVED
	%s enlev de la liste d'exclusion d'autokill.
OPER_EXCLUDE_NOT_FOUND
	%s n'apparait pas  la liste d'exclusion d'autokill.
OPER_EXCLUDE_LIST_HEADER
	Liste actuelle d'exclusion d'autokill:
# mask, reason
OPER_EXCLUDE_LIST_FORMAT
	%-32s  %s
# mask, set-by, set-time, last-used, expires, reason
OPER_EXCLUDE_VIEW_FORMAT
	%s (par %s sur %s, dernire utilisation %s; %s)
	    %s
# mask, set-by, set-time, expires, reason
OPER_EXCLUDE_VIEW_UNUSED_FORMAT
	%s (par %s sur %s, jamais utilis; %s)
	    %s
OPER_EXCLUDE_COUNT
	Il y a %d masques d'hte sur la liste d'exclusion d'autokill.

# SxLINE responses
OPER_SLINE_SYNTAX
	%s {ADD | DEL | LIST | VIEW | COUNT} [[+expiration] masque [raison]]
OPER_SLINE_ADD_SYNTAX
	%s ADD [+expiration] masque raison
OPER_SLINE_DEL_SYNTAX
	%s DEL masque
OPER_TOO_MANY_SLINES
	La liste %s est pleine!
OPER_SLINE_EXISTS
	%s dj sur la liste %s.
OPER_SLINE_ADDED
	%s ajout  la liste %s.
OPER_SLINE_REMOVED
	%s retir de la liste %s.
OPER_SLINE_NOT_FOUND
	%s n'apparait pas sur la liste %s.
OPER_SLINE_LIST_HEADER
	Liste %s actuelle:
# mask, reason
OPER_SLINE_LIST_FORMAT
	%-32s  %s
# mask, set-by, set-time, last-used, expires, reason
OPER_SLINE_VIEW_FORMAT
	%s (par %s sur %s, dernire utilisation %s; %s)
	    %s
# mask, set-by, set-time, expires, reason
OPER_SLINE_VIEW_UNUSED_FORMAT
	%s (par %s sur %s, jamais utilis; %s)
	    %s
OPER_SLINE_COUNT
	Il y a %d entres sur la liste %s.
OPER_SZLINE_NOT_AVAIL
	SZLINE n'est pas disponible avec ce server IRC.

# SU responses
OPER_SU_SYNTAX
	SU mot-de-passe
OPER_SU_NO_PASSWORD
	La commande SU n'est pas disponible car aucun mot-de-passe super-usager n'a t dtermin.
OPER_SU_SUCCEEDED
	Vous avez maintenant les privilges de Super-Usager.
OPER_SU_FAILED
	Incapable de vrifier le mot-de-passe.

# SET responses
OPER_SET_SYNTAX
	SET option setting
OPER_SET_IGNORE_ON
	Le code ignore sera utilis.
OPER_SET_IGNORE_OFF
	Le code ignore ne sera pas utilis.
OPER_SET_IGNORE_ERROR
	L'ajustement de IGNORE doit tre ON ou OFF.
OPER_SET_READONLY_ON
	Les services sont maintenant en mode lecture-seulement.
OPER_SET_READONLY_OFF
	Les services sont maintenant en mode lecture-criture.
OPER_SET_READONLY_ERROR
	L'ajustement pour READONLY doit tre ON ou OFF.
OPER_SET_DEBUG_ON
	Les services sont maintenant en mode DEBUG.
OPER_SET_DEBUG_OFF
	Les services sont maintenant en mode NON-DEBUG.
OPER_SET_DEBUG_LEVEL
	Les services sont maintenant en mode DEBUG (niveau %d).
OPER_SET_DEBUG_ERROR
	L'ajustement de DEBUG doit tre ON, OFF, ou un nombre positif.
OPER_SET_SUPASS_FAILED
	Incapable de dterminer un mot-de-passe de Super-Usager des Services.
OPER_SET_SUPASS_OK
	Le mot de passe du Super-Usager des Services a t chang.
OPER_SET_SUPASS_NONE
	Le mot de passe du Super-Usager des Services a t dsactiv.
OPER_SET_UNKNOWN_OPTION
	Option %s inconnue.

# JUPE responses
OPER_JUPE_SYNTAX
	JUPE nom-du-server [raison]
OPER_JUPE_INVALID_NAME
	Nom de server non-valide (les noms de server doivent contenir une priode).
OPER_JUPE_ALREADY_JUPED
	Le server %s est dj simul.

# RAW responses
OPER_RAW_SYNTAX
	RAW texte

# UPDATE responses
OPER_UPDATE_SYNTAX
	UPDATE [FORCE]
OPER_UPDATING
	Mise  jour de la banque de donnes.

# REHASH responses
OPER_REHASHING
	Re-lecture des ajustements de configuration.
OPER_REHASHED
	Tous les ajustements de configuration ont t mis--jour avec succs.
OPER_REHASH_ERROR
	Une erreur est survenue lors de la re-lecture des ajustements de configuration.  S.V.P. vrifier le fichier de sauvegarde des Services pour les dtails.

# LISTIGNORE responses
OPER_IGNORE_LIST
	Liste IGNORE des Services:
OPER_IGNORE_LIST_EMPTY
	La liste IGNORE est vide.

# KILLCLONES responses
OPER_KILLCLONES_SYNTAX
	KILLCLONES surnom
OPER_KILLCLONES_UNKNOWN_NICK
	Ne peut pas trouver l'usager %s.
OPER_KILLCLONES_KILLED
	%s a utilis KILLCLONES pour %s tuant ainsi %d clones.
OPER_KILLCLONES_KILLED_AKILL
	%s a utilis KILLCLONES pour %s tuant ainsi %d clones.  Un AKILL temporaire a t ajout pout %s.


###########################################################################
#
# Session limiting and exception messages
#
###########################################################################

# EXCEPTION responses
OPER_EXCEPTION_SYNTAX
	EXCEPTION {ADD | DEL | MOVE | LIST | VIEW} [params]
OPER_EXCEPTION_ADD_SYNTAX
	EXCEPTION ADD [+expiration] masque limite raison
OPER_EXCEPTION_DEL_SYNTAX
	EXCEPTION DEL {masque | liste}
OPER_EXCEPTION_MOVE_SYNTAX
	EXCEPTION MOVE num nouveau-num
OPER_EXCEPTION_ALREADY_PRESENT
	Le masque %s est dj inscrit  la liste d'exception.
OPER_EXCEPTION_TOO_MANY
	La liste d'exception se Limitation de Session est pleint!
OPER_EXCEPTION_ADDED
	La Limitations de Session pour %s est fixe  %d.
OPER_EXCEPTION_MOVED
	L'exception pour %s (#%d) a t dplace au nombre %d.
OPER_EXCEPTION_NO_SUCH_ENTRY
	Il n'y a plus d'entre (#%d) dans la liste d'exception de limitation de session.
OPER_EXCEPTION_NOT_FOUND
	%s n'apparait pas  la liste d'exception de limitation de session.
OPER_EXCEPTION_NO_MATCH
	Aucune entre correspondante dans la liste d'exception de limitation de session.
OPER_EXCEPTION_EMPTY
	La liste d'exception de limitation de session est vide.
OPER_EXCEPTION_DELETED
	%s effac de la liste d'exception de limitation de session.
OPER_EXCEPTION_DELETED_ONE
	Une entre efface de la liste d'exception de limitation de session.
OPER_EXCEPTION_DELETED_SEVERAL
	%d entres effaces de la liste d'exception de limitation de session.
OPER_EXCEPTION_LIST_HEADER
	Liste actuelle d'exception de limitation de session:
# number, limit, host
OPER_EXCEPTION_LIST_COLHEAD
	Num  Limite  Hte
OPER_EXCEPTION_LIST_FORMAT
	%3d  %4d   %s
# number, mask, set-by, set-time, expires, limit, reason
OPER_EXCEPTION_VIEW_FORMAT
	%3d.  %s  (par %s sur %s; %s)
	    Limite: %-4d  - %s
OPER_EXCEPTION_INVALID_LIMIT
	Limitation de session invalide; la limite doit tre d'au moins zro et jamais supprieure  %d.
OPER_EXCEPTION_INVALID_HOSTMASK
	Masque d'hte invalide.  Seuls les vritables masques d'hte sont valides comme  titre d'exception et correspondent pas contre les surnoms et noms d'usagers.

# SESSION responses
OPER_SESSION_SYNTAX
	SESSION {LIST limite | VIEW hte}
OPER_SESSION_LIST_SYNTAX
	SESSION LIST limite
OPER_SESSION_VIEW_SYNTAX
	SESSION VIEW hte
OPER_SESSION_INVALID_THRESHOLD
	Valeur plancher invalide; la valeur plancher doit tre un entier plus grand que 1.
OPER_SESSION_NOT_FOUND
	%s n'apparait pas dans la liste de la session.
OPER_SESSION_LIST_HEADER
	Htes avec au moins %d sessions:
OPER_SESSION_LIST_COLHEAD
	Sessions  Hte
# limit, host
OPER_SESSION_LIST_FORMAT
	%6d    %s
# host, sessions, limit
OPER_SESSION_VIEW_FORMAT
	L'hte %s a prsentement %d sessions avec une limite de %d.


###########################################################################
#
# News system messages
#
###########################################################################

NEWS_LOGON_TEXT
	[Nouvelles au branchement - %s] %s
NEWS_OPER_TEXT
	[Nouvelles des Oprateurs - %s] %s

NEWS_LOGON_SYNTAX
	LOGONNEWS {ADD | DEL | LIST} [texte | num]
NEWS_LOGON_LIST_HEADER
	Articles de nouvelles au branchement:
NEWS_LOGON_LIST_ENTRY
	%5d (%s par %s)
	    %s
NEWS_LOGON_LIST_NONE
	Il n'y a pas de nouvelles au branchement.
NEWS_LOGON_ADD_SYNTAX
	LOGONNEWS ADD texte
NEWS_LOGON_ADD_FULL
	La liste des nouvelles est pleine!
NEWS_LOGON_ADDED
	Addition d'un nouvel item aux nouvelles (#%d).
NEWS_LOGON_DEL_SYNTAX
	LOGONNEWS DEL {num | ALL}
NEWS_LOGON_DEL_NOT_FOUND
	L'item des nouvelles au branchement #%d n'apparait pas!
NEWS_LOGON_DELETED
	L'item des nouvelles au branchement #%d est effac.
NEWS_LOGON_DEL_NONE
	Aucun item de nouvelles au branchement  effacer!
NEWS_LOGON_DELETED_ALL
	Tous les itemps des nouvelles au branchement ont t effacs.

NEWS_OPER_SYNTAX
	OPERNEWS {ADD | DEL | LIST} [texte | num]
NEWS_OPER_LIST_HEADER
	Item des nouvelles des Oprateurs:
NEWS_OPER_LIST_ENTRY
	%5d (%s par %s)
	    %s
NEWS_OPER_LIST_NONE
	Il n'y a pas de nouvelles pour les oprateurs.
NEWS_OPER_ADD_SYNTAX
	OPERNEWS ADD texte
NEWS_OPER_ADD_FULL
	La liste des nouvelles est pleine!
NEWS_OPER_ADDED
	Ajout de l'item (#%d) aux nouvelles au branchement.
NEWS_OPER_DEL_SYNTAX
	OPERNEWS DEL {num | ALL}
NEWS_OPER_DEL_NOT_FOUND
	L'item des nouvelles des oprateurs #%d n'apparait pas!
NEWS_OPER_DELETED
	L'item des nouvelles des oprateurs #%d est effac.
NEWS_OPER_DEL_NONE
	Aucune item de nouvelle d'oprateur  effacer!
NEWS_OPER_DELETED_ALL
	Tous les items de nouvelles d'oprateur sont effacs.

NEWS_HELP_LOGON
	Syntaxe: LOGONNEWS ADD texte
	         LOGONNEWS DEL {num | ALL}
	         LOGONNEWS LIST
	
	Permet l'dition ou la prsentation de la liste des messages
	de nouvelles au branchement.  Lorsqu'un usager se connecte
	au rseau, ces messages lui seront expdis.  (Toutefois,
	pas plus de trois messages seront expdis afin d'viter
	d'innonder l'usager.  Si il y a plus de trois messages de
	nouvelles, seuls les trois plus rcents seront expdis.)
	
	La commande LOGONNEWS LIST peut tre utilise par n'importe
	quel Oprateur d'IRC afin d'obtenir le sommaire actuel des
	messages de nouvelles.  ADD et DEL peuvent galelent tre
	utiliss par les Oprateurs des Services.

NEWS_HELP_OPER
	Syntaxe: OPERNEWS ADD texte
	         OPERNEWS DEL {num | ALL}
	         OPERNEWS LIST
	
	Permet l'dition ou la prsentation de la liste des nouvelles
	des Oprateurs. Lorsqu'un usager obtient le status
	d'Oprateur IRC (avec la commande /OPER), Ces messages leurs
	seront expdis.  (Toutefois, pas plus de trois messages
	seront expdis afin d'viter d'innonder l'usager.  S'il y a
	plus de trois messages de nouvelles, seuls les trois plus
	rcents seront expdis.)
	
	La commande OPERNEWS LIST peut tre utilise par n'importe
	quel Oprateur d'IRC pour avoir la liste actuelle des
	messages de nouvelle des Oprateurs.  ADD et DEL peuvent
	seulement tre utilis par les Oprateurs des Services.


###########################################################################
#
# StatServ messages
#
############################################################################

# General SERVERS responses
STAT_SERVERS_REMOVE_SERV_FIRST
	Le serveur %s est en-ligne. Retirez le du rseau et essayez de nouveau.
STAT_SERVERS_SERVER_EXISTS
	Le serveur %s existe dj.

# SERVERS command syntax
STAT_SERVERS_SYNTAX
	SERVERS option paramtres

# STATS responses
STAT_SERVERS_STATS_TOTAL
	Serveurs au total: %2d
STAT_SERVERS_STATS_ON_OFFLINE
	       En-ligne: %2d (%d%%)  Hors-ligne: %2d (%d%%)
STAT_SERVERS_LASTQUIT_WAS
	    Dernire Sortie: %-30s  %s

# LIST responses
STAT_SERVERS_LIST_HEADER
	Nom du serveur                 Usagers    Oprateurs
STAT_SERVERS_LIST_FORMAT
	%-30s %3d (%2d%%)  %3d (%2d%%)
STAT_SERVERS_LIST_RESULTS
	Fin de la liste -- %d/%d servers en-ligne prsents.

# VIEW responses
STAT_SERVERS_VIEW_HEADER_ONLINE
	%-30s  (en-ligne)
STAT_SERVERS_VIEW_HEADER_OFFLINE
	%-30s  (hors-ligne)
STAT_SERVERS_VIEW_LASTJOIN
	    Dernire entre: %s
STAT_SERVERS_VIEW_LASTQUIT
	    Dernire sortie: %s
STAT_SERVERS_VIEW_QUITMSG
	  Message de sortie: %s
STAT_SERVERS_VIEW_USERS_OPERS
	        Usagers: %3d (%2d%%)  Oprateurs: %3d (%2d%%)
STAT_SERVERS_VIEW_RESULTS
	Fin de la liste -- %d/%d serveurs prsents.

# DELETE responses
STAT_SERVERS_DELETE_SYNTAX
	SERVERS DELETE serveur
STAT_SERVERS_DELETE_DONE
	Statistiques pour le serveur %s a t suprim.

# COPY responses
STAT_SERVERS_COPY_SYNTAX
	SERVERS COPY serveur nouveau-nom
STAT_SERVERS_COPY_DONE
	Statistiques pour le serveur %s copies pour %s.

# RENAME responses
STAT_SERVERS_RENAME_SYNTAX
	SERVERS RENAME serveur nouveau-nom
STAT_SERVERS_RENAME_DONE
	Statistiques pour le serveur %s renomes pour %s.

# USERS responses
STAT_USERS_SYNTAX
	STATISTIQUES D'USAGERS
STAT_USERS_TOTUSERS
	                 Total d'usagers: %d
STAT_USERS_TOTOPERS
	              Total d'oprateurs: %d
STAT_USERS_SERVUSERS
	   Moyenne d'usagers par serveur: %d
STAT_USERS_SERVOPERS
	Moyenne d'oprateurs par serveur: %d.%d


###########################################################################
#
# NickServ help messages
#
###########################################################################

NICK_HELP
	%S vous permet d'"enregistrer" un surnom et de
	prvenir son utilisation par quelqu'un d'autre.  %S est
	contrl par diffrentes commandes lesquelles permettent
	l'enregistrement et le maintien des surnoms.  Pour une liste
	des commandes, tapez /msg %S HELP COMMANDS; pour
	utiliser une commande, tapez /msg %S commande, et pour
	plus d'information sur une commande spcifique, tapez
	/msg %S HELP commande.
NICK_HELP_EXPIRES
	
	Si un surnom enregistr n'est pas utilis pendant %s,
	l'enregistrement va expirer et le surnom sera disponible
	pour l'usage par n'importe qui.
NICK_HELP_WARNING
	
	REMARQUE: Ce service se veut un moyen d'assurer aux usagers
	IRC que leur identit n'est pas compromise. Ce n'est PAS
	pour faciliter le "vol" de surnom ou d'autres actions
	malicieuses.  En cas d'abus de %S il en rsultera, au
	minimum, la perte du surnom usurp.

NICK_HELP_COMMANDS
	Les commandes suivantes peuvent tre utilises avec
	%S:
	
	    REGISTER   Enregistrement d'un surnom
NICK_HELP_COMMANDS_AUTH
	    AUTH       Confirmation de l'enregistrement du surnom
	    SENDAUTH   Vous expdie le code de confirmation du surnom
NICK_HELP_COMMANDS_IDENTIFY
	    IDENTIFY   Vous identifie par votre mot de passe
NICK_HELP_COMMANDS_SENDPASS
	    SENDPASS   Vous expdie votre mot de passe sur votre courriel
NICK_HELP_COMMANDS_DROP
	    DROP       Annule l'enregistrement d'un surnom
NICK_HELP_COMMANDS_LINK
	    LINK       Lie un autre surnom  votre propre surnom
	    UNLINK     Retire le lien avec un surnom li
	    LISTLINKS  Prsente la liste de tous les surnoms que vous avez lis
NICK_HELP_COMMANDS_OLDLINK
	    LINK       Fais de votre surnom un alias pour un autre
	    UNLINK     Retire un lien de votre surnom
NICK_HELP_COMMANDS_ACCESS
	    ACCESS     Modifie la liste des adresses autorises
NICK_HELP_COMMANDS_AJOIN
	    AJOIN      Modifie votre liste de canal auto-rejoint
NICK_HELP_COMMANDS_SET
	    SET        Dtermine les options, incluant la protection
	               Kill
	    UNSET      Efface l'information d'un surnom
	    RECOVER    Dbranche un autre usager qui utilise votre
	               surnom
	    RELEASE    Libre votre surnom aprs la commande RECOVER
	    GHOST      Dbranche une session "fantme"
	    INFO       Prsente l'information sur un surnom
NICK_HELP_COMMANDS_LIST
	    LIST       Prsente tous les surnoms correspondants  un
	               masque donn
	    LISTEMAIL  Prsente les surnoms par adresses courriel
NICK_HELP_COMMANDS_LISTCHANS
	    LISTCHANS  Prsente tous les canaux qui vous
	               appartiennent
	    STATUS     Vrifis qu'un surnom donn est identifi

NICK_HELP_REGISTER
	Syntaxe: %s
	
	Enregistre votre surnom dans la banque de donnes de
	%S.  Aprs cet enregistrement, vous pouvez utiliser
	les commandes SET et ACCESS pour configurer les ajustements
	de votre surnom selon ce que vous dsirez.  Assurez-vous de
	vous souvenir de votre mot de passe dtermin 
	l'enregistrement; vous en aurez besoin pour apporter des
	changements  votre surnom aprs.  (Notez que les formes
	suivantes!  FIDO, Fido, et fido sont tous des
	mots-de-passe diffrents!)
NICK_HELP_REGISTER_EMAIL
	
	Vous devez inclure une adresse courriel lorsque vous
	enregistrez votre surnom; vous pourez la changer en
	utilisant la commande SET EMAIL.
NICK_HELP_REGISTER_EMAIL_REQ
	
	Vous devez inclure une adresse courriel lorsque
	vous enregistrez votre surnom.  Vous pouvez viter
	l'affichage de cette adresse auprs des autres usagers en
	utilisant la commande SET HIDE (tapez /msg %S HELP SET
	HIDE pour plus d'information).
NICK_HELP_REGISTER_EMAIL_AUTH
	
	Vous devez inclure une adresse courriel valide lorsque vous
	enregistrez votre surnom;  %S expdira un message avec
	un code d'autorisation  cette adresse, lequel devra tre
	utilis avec la commande AUTH pour complter votre
	enregistrement.  Vous pouvez viter que cette adresse
	courriel soit prsente aux autres usagers en utilisant la
	commande SET HIDE (tapez /msg %S HELP SET HIDE pour
	plus d'information).
NICK_HELP_REGISTER_END
	
	Ligne directrice relative au choix du mot de passe:
	
	Un mot de passe ne doit pas tre facile  dcouvrir.  Par exemple,
	utiliser votre vritable nom comme mot de passe est une mauvaise ide.
	Utiliser votre surnom comme mot de passe n'est pas plus une bonne ide,
	et en fait, %S ne le permettra pas.  Aussi, les courts mots-de-passe
	sont plus vulnrables en recherche essais-erreur, donc vous devez
	choisir un mot de passe d'au moins 5 caractres de long.

NICK_HELP_AUTH
	Syntaxe: AUTH code
	
	Autorise l'enregistrement ou le changement de courriel pour
	un surnom.  Pour s'assurer que votre adresse courriel est
	correcte, %S expdira un message comprenant un code
	d'autorisation  l'adresse courriel donne lors de
	l'enregistrement de votre surnom ou lors du changement de
	votre adresse courriel avec la commande SET EMAIL.  Cette
	commande permet de confirmer que vous avez reu le message
	et vous permet de continuer d'utiliser votre surnom
	normalement.  Remplacez code dans la commande par le code
	d'autorisation de neuf chiffres donn dans le message
	courriel.

NICK_HELP_SENDAUTH
	Syntaxe: SENDAUTH
	
	Vous expdie une copie du code d'autorisation de votre
	surnom aprs l'enregistrement (REGISTER) ou un changement de
	courriel (SET EMAIL).  Si vous effacez accidentellement, ou
	perdez le message incluant le code d'autorisation d'une
	autre manire, vous pouvez utiliser cette commande afin
	qu'une nouvelle copie de ce message vous soit expdie.
	
	Afin de prvenir les abus, cette commande ne peut tre
	utilise qu'une fois toutes les 24 heures.

NICK_HELP_SENDPASS
	Syntaxe: SENDPASS surnom
	
	Expdie un message courriel contenant le mot de passe du
	surnom donn  l'adresse courriel enregistre pour le
	surnom.  Cette adresse doit tre d'abord confirme en
	utilisant la commande AUTH.

NICK_HELP_IDENTIFY
	Syntaxe: IDENTIFY mot-de-passe
	
	Dit  %S que vous tes rellement le propritaire de
	ce surnom.  Plusieurs commandes requierrent que vous soyez
	authentifis avant de pouvoir les utiliser.  Le mot de passe
	doit tre le mme que celui donn avec la commande REGISTER.

NICK_HELP_DROP
	Syntaxe: DROP mot-de-passe
	
	Dsenregistre votre surnom de la banque de donne de
	%S. Un surnom dsenregistr est disponible pour
	quiconque pour le r-enregistrer.
NICK_HELP_DROP_LINK
	
	Remarquez que lorsque vous dsenregistrez un surnom, tous
	les surnoms lis  ce dernier seront galement
	dsenregistrs.  Pour retirer un seul surnom li, utilisez
	d'abord la commande UNLINK.
NICK_HELP_DROP_END
	
	Pour prvenir l'utilisation accidentelle de cette commande,
	vous devez entrer votre mot-de-passe afin de dsenregistrer
	le surnom.

NICK_HELP_OLD_LINK
	Syntaxe: LINK surnom mot-de-passe
	
	Lie votre surnom  un autre, effectivement cre pour le
	surnom que vous utilisez actuellement un alias pour le
	surnom donn. Lorsque vous donnez cette commande, la liste
	d'accs pour le surnom que vous utilisez est efface et
	remplace par celle du surnom auquel vous vous liez; tous
	les messages pour votre surnom actuel sont ajouts  la
	liste des messages de votre surnom cible (ceci peut
	provoquer le dpassement de votre limite de messagerie,
	auquel cas vous aurez  en liminer quelques uns avant de
	pouvoir en recevoir d'autre pour chacun des surnoms).
	
	Une fois le lien tablit, votre surnom sera converti de
	manire invisible comme tant inclus dans le surnom cible
	partout dans les Services, except pour la commande UNLINK
	de %S.  Par exemple, vous pouvez utiliser n'importe
	quel des surnoms pour lire le mme ensemble de messages (et
	les messages expdis  n'importe quel des surnoms iront
	dans la mme liste).  Si un des surnoms est sur la liste
	d'accs d'un canal, aprs le lien, chacun des surnoms auront
	les mmes privilges d'accs.  Toutefois, les surnoms
	expireront de manire indpendante; si vous n'en utilisez
	qu'un seul de l'ensemble des surnoms lis, tous les autres
	expireront.
	
	Afin d'utiliser cette commande, vous devez vous identifier
	pour votre surnom actuel (utiliser la commande IDENTIFY), et
	vous devez fournir le mot-de-passe pour le surnom auquel
	vous voulez vous lier.

NICK_HELP_LINK
	Syntaxe: LINK surnom
	
	Lie un nouveau surnom au surnom que vous utilisez
	actuellement, cre un nouvel "alias" pour votre surnom.  Le
	nouveau surnom sera l'quivalent de votre surnom actuel en
	terme de privilges d'accs et de messagerie; par exemple,
	vous pouvez lire les messages expdis  un de vos surnoms
	lis  partir de n'importe quel autre, et si un de vos
	surnoms dispose de privilges auto-op sur un canal, vous
	serez auto-op, peu importe le surnom que vous utilisez.
	
	Pour annuler un lien, utilisez la commande UNLINK.
	
	Afin d'utiliser cette commande, vous devez vous identifier
	pour votre surnom actuel (utiliser la commande IDENTIFY), et
	le surnom  tre li ne doit pas tre encore enregistr.

NICK_HELP_OLD_UNLINK
	Syntaxe: UNLINK [surnom mot de passe]
	
	Retire le lien entre votre surnom et un autre.  Lorsque le
	lien est enlev, les options et liste d'accs du surnom
	pralablement li est copie  votre surnom actuel et
	peuvent ensuite tre indpendamment modifie.  Les messages
	ne sont pas copis; tous les messages demeureront au compte
	du surnom qui tait avant li.
	
	En donnant un surnom et un mot de passe comme paramtre,
	vous pouvez d-lier un autre surnom que celui que vous
	utilisez.

NICK_HELP_UNLINK
	Syntaxe: UNLINK surnom
	
	Enlve tous les liens (alias) sur votre surnom. crs avec
	la commande LINK.  Vous ne pouvez pas d-lier le surnom que
	vous utilisez actuellement; changez pourun autre surnom li
	avant d'utiliser cette commande.
	
	Si vous d-liez le "surnom principal" vous devez utiliser la
	commande SET MAINNICK, votre surnom actuel sera
	automatiquement slectionn comme surnom principal.

NICK_HELP_LISTLINKS
	Syntaxe: LISTLINKS
	
	Prsente tous les surnoms qui sont lis avec le vtre.  Le
	surnom principal du groupe des surnoms lis sera indiqu par
	un "*"  gauche du surnom.

NICK_HELP_ACCESS
	Syntaxe: ACCESS ADD masque
	         ACCESS DEL masque
	         ACCESS LIST
	
	Modifie ou prsente la liste d'accs pour votre surnom.  Il
	s'agit de la liste des adresses usager@hte qui seront
	automatiquement reconnues par %S comme tant
	autorises  utiliser le surnom.  Si vous vous connectez 
	l'IRC avec une adresse apparaissant  cette liste, vous ne
	serez pas affect par l'ajustement SET KILL, et si l'option
	SECURE est dsactive, vous serez en mesure de recevoir les
	privilges auto-op ainsi que les autres privilges des
	canaux sans avoir  utiliser la commande IDENTIFY.  Si vous
	voulez utiliser le surnom  partir d'une adresse diffrente,
	vous devez expdier une commande IDENTIFY pour que
	%S vous reconnaisse.
	
	Le masque donn avec les commandes ADD et DEL peut
	contenir des frimes (* ou ?).
	
	Exemples:
	
	    ACCESS ADD achurch@*.dragonfire.net
	        Permet  l'usager achurch d'accder de n'importe
	        quelle machine du domaine dragonfire.net.
	
	    ACCESS DEL achurch@*.dragonfire.net
	        Renverse la commande prcdante.
	
	    ACCESS LIST
	        Prsente la liste d'accs actuelle.

NICK_HELP_SET
	Syntaxe: SET option paramtres
	
	Dtermine une varit d'options de surnom.  L'option peut
	tre une des suivantes:
	
	    PASSWORD   Dtermine votre mot de passe
	    LANGUAGE   Dtermine la langue qu'utiliseront les
	               Services lorsqu'ils vous expdiront un
	               message
	    URL        Associe un URL  votre surnom
	    EMAIL      Associe une adresse courriel  votre surnom
	    INFO       Dtermine le texte  tre prsent avec la
	               commande INFO
	    KILL       Mets la protection "kill"  on ou off
	    SECURE     Mets la scurit de surnom  on ou off
	    PRIVATE    vite que votre surnom apparaisse dans un
	                   /msg %S LIST
	    HIDE       Voile certain dtails de l'information
	               relative  votre surnom
	    TIMEZONE   Dtermine le fuseau horaire pour vous donner
	               l'heure juste
NICK_HELP_SET_OPTION_MAINNICK
	    MAINNICK   Dtermine le surnom prsent dans la liste
	               d'accs de canal
NICK_HELP_SET_END
	
	Afin d'utiliser cette commande, vous devez d'abord vous
	identifier avec votre mot de passe (/msg %S HELP
	IDENTIFY pour plus d'information).
	
	Tapez /msg %S HELP SET option pour plus d'information
	sur une option spcifique.

NICK_HELP_SET_PASSWORD
	Syntaxe: SET PASSWORD nouveau-mot-de-passe
	
	Change le mot-de-passe utilis pour vous identifier comme
	propritaire du surnom.

NICK_HELP_SET_LANGUAGE
	Syntaxe: SET LANGUAGE numro
	
	Change la langue que les Services utilisent lorsqu'ils vous
	expdient un message (par exemple, en rponse  une commande
	que vous avez donn).  Le numro doit tre choisi dans la
	liste des langues suportes suivante:

NICK_HELP_SET_URL
	Syntaxe: SET URL url
	
	Associe l'URL donn avec votre surnom. Cet URL sera prsent
	chaque fois que quelqu'un fera une demande d'information sur
	votre surnom avec la commande INFO.

NICK_HELP_SET_EMAIL
	Syntaxe: SET EMAIL adresse
	
	Associe l'adresse courriel donne avec votre surnom.  Cette
	adresse sera prsente chaque fois que quelqu'un fera une
	demande d'information sur votre surnom avec la commance INFO.

NICK_HELP_SET_INFO
	Syntaxe: SET INFO texte
	
	Associe le texte donn avec votre surnom; a sera prsent chaque
	fois qu'un usager demandera de l'information sur votre surnom avec
	la commande INFO.

NICK_HELP_SET_KILL
	Syntaxe: SET KILL {ON | QUICK | IMMED | OFF}
	
	Mets  on ou off la protection "kill" pour votre surnom.
	Avec la protection  "ON", si un autre usager essais de
	prendre votre surnom, les services lui donneront une minute
	pour changer pour un autre surnom, aprs quoi, il sera forc
	par %S de quitter l'IRC.
	
	Si vous slectionnez QUICK, l'usager disposera seulement de
	20 secondes pour changer son surnom au lieu des 60
	habituelles.  Si vous slectionnez IMMED, l'usager sera
	immdiatement dbranch sans tre pralablement averti et
	sans aucune chance de changer son surnom; s.v.p. ne pas
	utiliser cette option si ce n'est pas ncessaire.  Aussi,
	votre administrateur de rseau peut avoir dsactiv cette
	option.

NICK_HELP_SET_SECURE
	Syntaxe: SET SECURE {ON | OFF}
	
	Mets les dispositifs de protection de %S  on ou off
	pour votre surnom.  Avec SECURE slectionn, vous devez
	entrer votre mot de passe avant d'tre reconnu comme le
	propritaire du surnom, sans gard si l'adresse apparait
	dans la liste d'accs.  Toutefois, si vous tes sur la liste
	d'accs, %S ne vous dconnectera pas, et ce peu
	importe l'ajustement de l'option KILL.

NICK_HELP_SET_PRIVATE
	Syntaxe: SET PRIVATE {ON | OFF}
	
	Mets l'option prive de %S  ON ou OFF pour votre
	surnom. Avec PRIVATE slectionn, votre surnom m'apparatra
	pas dans la liste de surnoms gnre avec la commande LIST
	de %S. (Toutefois, quiconque connat votre surnom peut
	continuer d'obtenir de l'information sur vous avec la
	commande INFO.)

NICK_HELP_SET_HIDE
	Syntaxe: SET HIDE {EMAIL | USERMASK | QUIT} {ON | OFF}
	
	Vous permet de prvenir que certaines pices d'information
	soient exposes lorsque quelqu'un fait une requte %S
	INFO sur votre surnom.  Vous pouvez masquer votre adresse
	courriel (EMAIL), le dernier masque user@host appreu
	(USERMASK), et le dernier message de sortie (QUIT).  Le
	second paramtre spcifie quelle information doit tre
	prsente (OFF) ou masque (ON).

NICK_HELP_SET_TIMEZONE
	Syntaxe: SET TIMEZONE {diffrence de TUC | fuseau-horaire | DEFAULT}
	
	Dtermine le fuseau horaire pour l'affichage de temps (ainsi
	que les derniers moments utilis pour un canal ou un surnom),
	au lieu d'utiliser le fuseau horaire sur lequel les Services
	oprent; la slection de DEFAULT permet de retourner au
	fuseau horaire des Services.  Le fuseau horaire peut tre
	spcifi d'une ou 2 manires:
	
	   - Tel une diffrence de TUC, la diffrence de temps entre
	     votre heure locale et le TUC (Temps Universel
	     Coordonn, galement connu sous l'appellation heure de
	     Greenwich).  La diffrence est donne par un "+" ou un
	     "-" pour indiquer aprs (Est) ou avant (Ouest) le TUC,
	     suivi par un nombre entier d'heures ou fractionnaire
	     dans la forme "hh:mm".
	
	   - Tel un nom de zone horaire, comme "GMT" ou "EDT".  Ce
	     ne sont pas tous les noms de fuseaux horaires qui sont
	     supports par les Services, et certains fuseaux
	     horaires de pays ont le mme nom, donc si vous obtenez
	     un message d'erreur ou que le temps affich par les
	     Services est erronn, utilisez la diffrence de TUC 
	     la place.
	
	Notez que les Services ne s'ajusteront pas automatiquement
	pour l'heure avance; vous aurez  l'ajuster manuellement.
	
	Exemples:
	
	    SET TIMEZONE -5
	        Dtermine le fuseau horaire  5 heures avant le TUC.
	
	    SET TIMEZONE +3:30
	        Dtermine le fuseau horaire  3 heures, 30 minutes
	        aprs le TUC.
	
	    SET TIMEZONE JST
	        Dtermine le fuseau horaire  l'heure normale du
	        Japon (TUC+9:00).

NICK_HELP_SET_MAINNICK
	Syntaxe: SET MAINNICK surnom
	
	Lorsque vous avez plusieurs surnoms lis ensembles, vous
	permet de slectionner lequel apparatra dans la liste
	d'accs du canal.  Si plus tard, vous d-liez ce surnom,
	aprs un autre sera slectionn automatiquement.

NICK_HELP_UNSET
	Syntaxe: UNSET {URL | EMAIL | INFO}
	
	Vous permet d'effacer l'URL (URL), l'adresse courriel
	(EMAIL), ou le texte d'information (INFO) associ  votre
	surnom.

NICK_HELP_UNSET_REQ_EMAIL
	Syntaxe: UNSET {URL | INFO}
	
	Vous permet d'effacer l'URL (URL) ou le texte d'information
	(INFO) associ  votre surnom.

#NICK_HELP_RECOVER
#	Syntaxe: RECOVER surnom [mot-de-passe]
#	
#	Vous permet de reprendre votre surnom si quelqu'un d'autre
#	l'a prit; ceci a le mme effet que la protection "kill"
#	automatique de %S sur un surnom protg.
#	
#	Lorsque vous donnez cette commande, %S emmnera un
#	faux usager en-ligne avec le mme surnom que l'usager duquel
#	vous dsirez reprendre le surnom, forant ainsi le server
#	IRC  dbrancher l'autre usager.  Ce faux usager restera en
#	ligne pendant une minute pour s'assurer que l'autre usager
#	ne se reconnectera pas automatiquement; aprs une minute,
#	vous pourrez reprendre votre surnom.  Vous pouvez aussi
#	utiliser la commande RELEASE (/msg %S HELP RELEASE)
#	pour reprendre le surnom plus rapidement.
#	
#	Dans le but d'utiliser la commande RECOVER pour un surnom,
#	vous devez fournir le bon mot de passe pour le surnom, ou
#	vous devez dj tre identifi sur un surnom li au surnom
#	donn.

#NICK_HELP_RELEASE
#	Syntaxe: RELEASE surnom [mot-de-passe]
#	
#	Ordonne  %S de retirer toute suspension sur votre
#	surnom provoque par une protection "kill" automatique ou
#	par l'utilisation de la commande RECOVER.  Par dfaut,
#	toutes ces suspensions durent une minute; cette commande
#	permet d'courcir ce dlais.
#	
#	Afin d'utiliser la commande RELEASE pour un surnom, vous
#	devez fournir le bon mot de passe pour ce surnom, ou vous
#	devez tre dj identifi  un surnom qui est li au surnom
#	donn.

NICK_HELP_GHOST
	Syntaxe: GHOST surnom [mot-de-passe]
	
	Mets fin  une session "fantme" d'IRC utilisant votre
	surnom.  Une session "fantme" en est une qui n'est pas
	actuellement connecte, mais pour laquelle le server IRC
	croit qu'elle est toujours en-ligne pour une raison ou une
	autre.  Tipiquement, ceci survient si votre ordinateur
	s'arrte ou si votre connection modem  Internet tombe
	pendant que vous tes sur IRC.
	
	Afin d'utiliser la commande GHOST pour un surnom, vous devez
	fournir le bon mot-de-passe pour le surnom, ou vous devez
	dj tre identifi  un surnom qui est li au surnom donn.

NICK_HELP_INFO
	Syntaxe: INFO surnom [ALL]
	
	Prsente l'information relative  un surnom donn, telle que
	le propritaire du surnom, sa dernire adresse et son
	dernier moment de branchement ainsi que les options de son
	surnom.  Si vous tes identifi pour le surnom sur lequel
	vous demandez de l'information, vous recevrez TOUTE
	l'information sans gard relativement  ce que vous avez
	demand d'tre masqu ou pas.
NICK_HELP_INFO_AUTH
	
	Si l'adresse courriel du surnom n'a pas encore t confirme
	avec la commande AUTH, cette adresse ne sera pas prsent 
	personne except le propritaire du surnom et les
	Administrateurs des services, sans gard  l'ajustement SET
	HIDE EMAIL du surnom.

NICK_HELP_LISTCHANS
	Syntaxe: LISTCHANS
	
	Prsente le nom et le nombre total de tous les canaux que
	vous avez enregistr sous votre surnom.

NICK_HELP_LIST
	Syntaxe: LIST modle
	
	Prsente tous les surnoms enregistr correspondant avec le
	modle donn eux-mmes  la dernire adresse apperue (dans
	le format usager@hte). Les surnoms dont l'option PRIVATE
	est slectionne ne seront pas affichs.
	
	Exemples:
	
	    LIST joeuser@foo.com
	        Prsente tous les surnoms enregistrs qui ont t
	        utiliss pour la dernire fois pas joeuser@foo.com.
	
	    LIST *Bot*
	        Prsente tous les surnoms enregistrs contenant Bot
	        dans leurs noms (cas le plus frquent).
	
	    LIST *@*.bar.org
	        Prsente tous les surnoms enregistrs utiliss dans
	        le domaine bar.org.

NICK_HELP_LIST_OPERSONLY
	
	Seuls les Oprateurs d'IRC peuvent utiliser cette fonction.

NICK_HELP_LISTEMAIL
	Syntaxe: LISTEMAIL modle
	
	Prsente les surnoms enregistrs comme la commande LIST,
	mais correspondant  l'adresse courriel au lieu de l'adresse
	usager@hte. Voir la commande d'aide de LIST (/msg %S
	HELP LIST) pour plus d'information.

NICK_HELP_STATUS
	Syntaxe: STATUS surnom...
	
	Rponds si l'usager utilisant le surnom donn est reconnu
	comme propritaire du surnom.  La rponse a la forme
	suivante:
	
	    surnom status-code
	
	o surnom est le surnom donn avec la commande, et
	status-code is one of the following:
	
	    0 - aucun usager en ligne ou surnom pas enregistr
	    1 - usager non-reconnu comme propritaire du surnom
	    2 - usager reconnu comme propritaire via la liste
	        d'accs seulement
	    3 - usager reconnu comme propritaire du surnom, via
	        identification par mot-de-passe
	
	Jusqu' seize surnoms peuvent tre envoys avec chaque
	commande; les autres seront ignores.  Aucun message
	d'erreur n'est gnr si aucun surnom est donn.

#NICK_HELP_AJOIN
#	Syntaxe: AJOIN ADD canal
#	         AJOIN DEL canal
#	         AJOIN LIST
#	
#	Modifie ou prsente la liste de canaux auto-joints pour
#	votre surnom.  Il s'agit de la liste des canaux que vous
#	dsirez joindre automatiquement, ds que vous vous
#	identifiez  %S.  Remarquez que vous pouvez seulement
#	mettre des noms de canaux commenant par "#" dans la liste
#	auto-joindre (les canaux locaux ne peuvent pas tre
#	ajouts).

NICK_OPER_HELP_COMMANDS
	
	Les commandes suivantes sont rserves aux Administrateurs
	des services:
	
	    DROPNICK   Effacer un surnom
NICK_OPER_HELP_COMMANDS_GETPASS
	    GETPASS    Donne le mot de passe pour un surnom
	                   (seulement si l'encryption n'est pas
	                    active)
NICK_OPER_HELP_COMMANDS_FORBID
	    FORBID     Empche un surnom d'tre utilis/enregistr
	    SUSPEND    Empche de s'identifier pour un surnom
	    UNSUSPEND  Annule une suspension de surnom
NICK_OPER_HELP_COMMANDS_LISTLINKS
	    LISTLINKS  Prsente les surnoms lis  un surnom donn
NICK_OPER_HELP_COMMANDS_SETAUTH
	    SETAUTH    Dtermine un nouveau code d'authorisation
	               pour un surnom
	    GETAUTH    Prsente le code d'autorisation pour un
	               surnom
	    CLEARAUTH  Efface le code d'autorisation pour un surnom
NICK_OPER_HELP_COMMANDS_END
	
	Les administrateurs des services peuvent galement utiliser
	les commandes suivantes sur n'importe quel surnom, sans
	s'identifier pour lui:
	
	    SET, ACCESS LIST, INFO ALL
	
	Vois "help" pour chacune de ces commandes afin d'avoir des
	dtails spcifiques.

NICK_OPER_HELP_DROPNICK
	Syntaxe: DROPNICK surnom
	
	Efface le surnom donn de la banque de donne de %S,
	ainsi que tous les surnoms qui y sont lis.
	
	Limit  l'usage des Administrateurs des Services.

NICK_OPER_HELP_SET
	
	Les Administrateurs des Services peuvent galement
	dterminer l'option NOEXPIRE, pour permettre de prvenir
	qu'un surnom n'expire.  En plus, les Administrateurs des
	Services peuvent des options pour tous les surnoms sans
	entrer de mot-de-passe, en utilisant le format SET surnom
	option paramtres.

NICK_OPER_HELP_SET_NOEXPIRE
	Syntaxe: SET [surnom] NOEXPIRE {ON | OFF}
	
	Dtermine si oui ou non le surnom donn va expirer.  Utilis
	avec ON prvient l'expiration du surnom.  Si aucun surnom
	n'est donn, fixe l'option de non-expiration pour votre
	surnom.
	
	Limit  l'usage des Administrateurs des Services.

NICK_OPER_HELP_UNSET
	
	Les Administrateurs des Services peuvent utiliser la
	commande UNSET sur n'importe quel surnom en incluant le
	surnom avant le nom de l'option, tel qu'avec la commande
	SET.

NICK_OPER_HELP_OLD_UNLINK
	
	Les Administrateurs des Services peuvent d-lier n'importe
	quel surnom sans entrer de mot-de-passe.

NICK_OPER_HELP_UNLINK
	Syntaxe: UNLINK surnom [FORCE]
	
	Enlve un lien (alias) de votre surnom cr par la commande
	LINK. Vous ne pouvez pas enlever le lien sur le surnom que
	vous utilisez actuellement; changez pour un autre surnom li
	avant d'utiliser cette commande.
	
	Si vous d-liez le "surnom principal" vous devez utiliser la
	commande SET MAINNICK, votre surnom actuel sera
	automatiquement slectionn comme surnom principal.
	
	Les Administrateurs des Services peuvent ajouter l'option
	FORCE, laquelle permet de retirer un lien sur un surnom
	autre que le-leur.

NICK_OPER_HELP_OLD_LISTLINKS
	Syntaxe: LISTLINKS surnom [ALL]
	
	Donne le sommaire des surnoms lis au surnom donn.
	
	Limit  l'usage des Administrateurs des Services.

NICK_OPER_HELP_LISTLINKS
	Syntaxe: LISTLINKS [surnom]
	
	Prsente tous les surnoms qui sont lis avec le vtre.  Le
	surnom principal du groupe des surnoms lis sera indiqu par
	un "*"  gauche du surnom.  Les Administrateurs des Services
	peuvent obtenir cette liste pour n'importe quel surnom en
	spcifiant le surnom dans la commande.

NICK_OPER_HELP_ACCESS
	
	Les Administrateurs des Services peuvent donner un paramtre
	de surnom avec la commande LIST pour obtenir l'affichage de
	la liste d'accs de n'importe quel surnom.

NICK_OPER_HELP_INFO
	
	Les Administrateurs des Services peuvent utiliser le
	paramtre ALL avec tous les surnoms.

NICK_OPER_HELP_LISTCHANS
	
	Les Administrateurs des Services peuvent avoir la liste des
	canaux pour n'importe quel surnom en spcifiant le surnom
	dans la commande (par exemple, /msg %S LISTCHANS
	AutreSurnom).

NICK_OPER_HELP_LIST
	Syntaxe: LIST modle [FORBIDDEN] [NOEXPIRE] [SUSPENDED]
	
	Donne la liste de tous les surnoms enregistrs pour
	n'importe quel surnom ou la dernire adresse sur lequel il a
	t apperu (dans le format usager@hte) correspondant au
	modle donn.  Les surnoms ayant l'option PRIVATE seront
	seulement prsents aux Administrateurs des Services.  Pour
	les Administrateurs des Services, les surnoms ayant l'option
	NOEXPIRE dtermine auront un !  ct du surnom, et les
	surnoms suspendus seront accompagns d'un *.
	
	Si les options FORBIDDEN, SUSPENDED ou NOEXPIRE sont
	spcifies, seuls les surnoms lesquels, respectivement, sont
	interdits, suspendus, ou qui ont l'option NOEXPIRE en force
	seront prsents.  Les options peuvent tre utilises dans
	n'importe quel ordre et n'importe quelle combinaison. Ces
	options sont limites  l'usage des Administrateurs des
	Services.
	
	Exemples:
	
	    LIST usagerjoe@foo.com
	        Prsente tous les surnoms enregistrs qui ont t
	        utiliss pour la dernire fois par usagerjoe@fu.com.
	
	    LIST *Bot*
	        Prsente tous les surnoms enregistrs avec Bot dans
	        leur noms (cas frquent).
	
	    LIST * NOEXPIRE
	        Prsente tous les surnoms qui ont t dtermins
	        comme n'expirant pas.

NICK_OPER_HELP_LIST_AUTH
	Syntaxe: LIST modle [FORBIDDEN] [NOEXPIRE] [SUSPENDED] [NOAUTH]
	
	Donne la liste de tous les surnoms enregistrs qui
	correspondent au modle donn, autant avec le surnom
	lui-mme ou avec la dernire adresse apperue (dans le
	format usager@hte).  Les surnoms ayant l'option PRIVATE
	slectionne seront prsents exclusivement aux
	Administrateurs des Services.  Pour ces derniers, les
	surnoms ayant l'option NOEXPIRE dtermine auront  ct un
	!, ceux qui sont suspendus serons prcds d'un *, et ceux
	qui n'ont pas encore t autoriss (avec la commande AUTH)
	seront prcds d'un ?.
	
	Si les options FORBIDDEN, SUSPENDED, NOEXPIRE, ou NOAUTH
	sont donnes, seuls les surnoms qui, respectivement, sont
	interdits, suspendus, ont l'option NOEXPIRE dtermine, ou
	qui n'ont pas encore t autoriss seront affichs.  Les
	options peuvent tre utilises dans n'importe quel ordre ou
	n'importe quelle combinaison.  Ces options sont limites 
	l'usage des Administrateurs des Services.
	
	Exemples:
	
	    LIST usagerjoe@foo.com
	        Prsente tous les surnoms enregistrs qui ont t
	        utiliss pour la dernire fois par usagerjoe@foo.com.
	
	    LIST *Bot*
	        Prsente tous les surnoms enregistrs avec Bot dans
	        leur noms (cas frquent).
	
	    LIST * NOEXPIRE
	        Prsente tous les surnoms qui ont t dtermins
	        comme n'expirant pas.

NICK_OPER_HELP_LISTEMAIL
	Syntaxe: LISTEMAIL modle [FORBIDDEN] [NOEXPIRE] [SUSPENDED]
	
	Donne la liste des surnoms enregistrs comme la commande
	LIST, mais correspondant  une adresse courriel au lieu de
	l'adresse usager@hte. Voir help pour la commande LIST (/msg
	%S HELP LIST) pour plus d'information.

NICK_OPER_HELP_LISTEMAIL_AUTH
	Syntaxe: LISTEMAIL modle [FORBIDDEN] [NOEXPIRE] [SUSPENDED] [NOAUTH]
	
	Donne le sommaire des surnoms enregistrs comme la commande
	LIST, mais correspondant  l'adresse courriel au lieu de
	l'adresse usager@hte. Voir help pour la commande LIST (/msg
	%S HELP LIST) pour plus d'information.


NICK_OPER_HELP_GETPASS
	Syntaxe: GETPASS surnom
	
	Donne le mot-de-passe pour le surnom donn.  Remarquez que
	chaque fois que cette commande est utilise, un message
	incluant le nom de la personne qui a donn la commande et le
	surnom pour lequel elle a t utilis est enregistr et
	expdi sous forme de WALLOPS/GLOBOPS.
	
	Si l'encryption est en fonction, cette commande pourrait ne
	pas tre disponible, tout dpendant du type d'encryption
	utilise.
	
	Limit  l'usage des Administrateurs des Services.

NICK_OPER_HELP_FORBID
	Syntaxe: FORBID surnom
	
	Interdit qu'un surnom soit enregistr ou utilis par
	quiconque. Peut tre annul en utilisant la commande DROP
	sur le surnom.
	
	Limit  l'usage des Administrateurs des Services.

#NICK_OPER_HELP_SUSPEND
#	Syntaxe: SUSPEND [+expiration] surnom raison
#	
#	Empche un surnom, ainsi que tous les surnoms comprenant
#	ledit surnom  l'intrieur, d'tre utiliss ou qu'on ne s'y
#	identifie.  Un surnom peut tre d-suspendu avec la commande
#	UNSUSPEND.
#	
#	Contrairement  un surnom interdit, un surnom suspendu ne
#	perd pas son information et finira par expirer!
#	
#	Limit  l'usage des Administrateurs des Services.

NICK_OPER_HELP_UNSUSPEND
	Syntaxe: UNSUSPEND surnom
	
	Permet aux gens d'utiliser et de s'identifier pour un surnom
	qui avant tait suspendu.
	
	Limit  l'usage des Administrateurs des Services.

NICK_OPER_HELP_AJOIN
	
	Les Administrateurs des Services peuvent obtenir la liste
	d'autojoin pour tous les surnoms avec le format LIST surnom.

NICK_OPER_HELP_SETAUTH
	Syntaxe: SETAUTH surnom
	
	Dtermine un nouveau code d'autorisation pour le surnom
	donn.  Le propritaire du surnom aura  utiliser la
	commande AUTH pour le surnom avant d'tre autoris 
	s'identifier pour celui-ci de nouveau.  Si le surnom est
	prsentement utilis, une notice sera expdie  l'usager du
	surnom et il n'aura plus les privilges que lui procurent ce
	surnom lorsqu'il est convenablement identifi.
	
	Limit  l'usage des Administrateurs des Services.

NICK_OPER_HELP_GETAUTH
	Syntaxe: GETAUTH surnom
	
	Donne le code d'autorisation associ avec le surnom, s'il en
	existe un.
	
	Limit  l'usage des Administrateurs des Services.

NICK_OPER_HELP_CLEARAUTH
	Syntaxe: CLEARAUTH surnom
	
	Efface tout code d'autorisation associ  un surnom,
	permettant ainsi au surnom d'tre normalement utilis.
	
	Limit  l'usage des Administrateurs des Services.


###########################################################################
#
# ChanServ help messages
#
###########################################################################

# Used in OP/VOICE/etc for required access levels for commands
CHAN_HELP_REQSOP_LEVXOP
	niveau 100 (SOP)
CHAN_HELP_REQSOP_LEV
	niveau 100
CHAN_HELP_REQSOP_XOP
	SOP
CHAN_HELP_REQAOP_LEVXOP
	niveau 50 (AOP)
CHAN_HELP_REQAOP_LEV
	niveau 50
CHAN_HELP_REQAOP_XOP
	AOP
CHAN_HELP_REQHOP_LEVXOP
	niveau 40 (HOP)
CHAN_HELP_REQHOP_LEV
	niveau 40
CHAN_HELP_REQHOP_XOP
	HOP
CHAN_HELP_REQVOP_LEVXOP
	niveau 30 (VOP)
CHAN_HELP_REQVOP_LEV
	niveau 30
CHAN_HELP_REQVOP_XOP
	VOP

# Real help messages start here
CHAN_HELP
	%S vous permet d'enregistrer et de contrler divers aspects
	d'un canal.  %S peut autant prvenir les usagers malicieux de
	"prendre possession" du canal en limitant QUI est autoris 
	bnficier des privilges d'oprateur.  Tapez /msg %S
	HELP COMMANDS pour une liste des commandes de %S; pour
	utiliser une commande, tapez /msg %S commande, ou
	pour plus d'information sur une commande, tapez /msg
	%S HELP commande.

CHAN_HELP_EXPIRES
	
	Prire de noter que tout canal qui n'est pas utilis pendant %s
	(i.e. sur lequel aucun usager inscrit  la liste d'accs n'entre
	pour cette priode de temps) sera automatiquement ferm.

CHAN_HELP_COMMANDS
	Les commandes suivantes peuvent tre utilises avec %S:
	
	    REGISTER   Enregistrer un canal
	    IDENTIFY   Vous identifier avec votre mot-de-passe
CHAN_HELP_COMMANDS_SENDPASS
	    SENDPASS   Vous expdier un mot de passe de canal
CHAN_HELP_COMMANDS_DROP
	    DROP       Dsenregistrement d'un canal
	    SET        Slectionne les options et informations d'un
	               canal
	    UNSET      Efface les informations d'un canal
	    INFO       Prsente les options et informations d'un
	               canal
CHAN_HELP_COMMANDS_LIST
	    LIST       Sommaire des canaux enregistrs
CHAN_HELP_COMMANDS_AKICK
	    AKICK      Maintien de la liste d'Auto-Expulsion
CHAN_HELP_COMMANDS_LEVELS
	    ACCESS     Maintien de la liste de priorit d'un canal
	    LEVELS     Ajustement prcis des niveaux d'accs sur le
	               canal
CHAN_HELP_COMMANDS_XOP
	    SOP        Maintien de la liste des SuperOps
	    AOP        Maintien de la liste des AutoOps
	    VOP        Maintien de la liste des AutoVoices
CHAN_HELP_COMMANDS_HOP
	    HOP        Maintien de la liste des AutoDemiOps
CHAN_HELP_COMMANDS_OPVOICE
	    OP         Accorder ponctuellement le status d'oprateur
	                un usager (+o)
	    DEOP       Retirer le status d'oprateur  un usager
	               (-o)
	    VOICE      Accorder un privilge vocal  un usager (+v)
	    DEVOICE    Retirer le privilge vocal  un usager (-v)
CHAN_HELP_COMMANDS_HALFOP
	    HALFOP     Accorder un status demi-Oprateur  un usager
	               (+h)
	    DEHALFOP   Retirer le status demi-Oprateur  un usager
	               (-h)
CHAN_HELP_COMMANDS_PROTECT
	    PROTECT    Accorder  un usager un status de protg
	               (+a)
	    DEPROTECT  Retirer  un usager un status de protg (-a)
CHAN_HELP_COMMANDS_INVITE
	    INVITE     Inviter un usager sur un canal
	    UNBAN      D-bannir un usager d'un canal
	    KICK       Expulser un usager d'un canal
	    TOPIC      Changer le sujet d'un canal
	    CLEAR      Effacer les modes d'un canal ou expulsion de
	               masse de tous les usagers
	    STATUS     Retourne  un usager le niveau d'accs sur un
	               canal

CHAN_HELP_REGISTER
	Syntaxe: REGISTER canal mot-de-passe description
	
	Enregistre un canal dans la base de donnes de %S.
	Afin d'utiliser cette commande, vous devez d'abord tre
	oprateur sur le canal que vous souhaitez enregistrer.  Le
	mot de passe est utilis avec la commande IDENTIFY pour
	vous permettre d'apporter des changements aux ajustements du
	canal lors des usages futurs.  Le dernier paramtre, lequel
	doit tre inclus, est une description gnrale de la raison
	d'tre du canal.
	
	Lorsque vous enregistrez un canal, vous tes inscrit  titre
	de "propritaire" (founder) du canal.  Le propritaire du
	canal est habilit  changer tous les ajustements du canal;
	%S accordera automatiquement au propritaire
	du canal les privilges d'Oprateur lorsque ce dernier
	entrera sur le canal. Voir la commande ACCESS (/msg
	%S HELP ACCESS) pour de l'information sur comment
	accorder un sous-ensemble de ces privilges  d'autres
	usagers du canal.
	
	AVIS: Afin d'enregistrer un canal, vous devez d'abord
	enregistrer et vous identifier pour votre surnom.  Si vous
	ne l'avez fait, /msg %s HELP pour de l'information sur
	comment procder.

CHAN_HELP_REGISTER_ADMINONLY
	
	Limit aux Administrateurs des Services.

CHAN_HELP_SENDPASS
	Syntaxe: SENDPASS canal
	
	Vous expdie un message courriel contenant le mot-de-passe
	pour le canal donn.  Vous devez tre le propritaire du
	canal pour utiliser cette commande, et vous devez d'abord
	vous identifier pour votre surnom avec la commande %s
	IDENTIFY.

CHAN_HELP_IDENTIFY
	Syntaxe: IDENTIFY canal mot-de-passe
	
	Vous authentifie auprs de %S  titre de propritaire du
	canal donn.  Plusieurs commandes requierrent que vous
	utilisiez cette commande avant de les utiliser.  Le mot de
	passe doit tre le mme que vous avez donn avec la commande
	REGISTER.

CHAN_HELP_DROP
	Syntaxe: DROP canal
	
	Dsenregistre le canal nomm.  Ne peut tre utilise que par
	le propritaire du canal, lequel doit utiliser d'abord la
	commande IDENTIFY.

CHAN_HELP_SET
	Syntaxe: SET canal option paramtres
	
	Permet au propritaire du canal de dterminer diffrentes
	options de canal et d'autres informations.  Le propritaire
	doit utiliser la commande IDENTIFY avant d'utiliser la
	commande SET.
	
	Options disponibles:
	
	    FOUNDER     Dterminer le propritaire du canal
	    SUCCESSOR   Dterminer le successeur du canal
	    PASSWORD    Dterminuer le mot-de-passe du propritaire
	    DESC        Dterminer la description du canal
	    URL         Associer un URL au canal
	    EMAIL       Associer une adresse courriel au canal
	    ENTRYMSG    Dterminer un message  tre expdi aux
	                usagers lorsqu'ils entrent sur le canal
	    KEEPTOPIC   Retenir le sujet du canal lorsque ce dernier
	                n'est pas utilis
	    TOPICLOCK   Le sujet ne peut tre chang qu'avec TOPIC
	    MLOCK       Barrer les modes du canal  ON ou OFF
	    PRIVATE     Voiler le canal de la commande LIST
	    RESTRICTED  Restreindre l'accs au canal
	    SECURE      Activer les dispositifs de protection de %S
	    SECUREOPS   Assurer un contrle stricte des Oprateurs
	                de canal
	    LEAVEOPS    Ne pas retirer les privilges d'oprateur 
	                l'entre sur le canal
	    OPNOTICE    Expdier une notification lorsque les
	                commandes OP/VOICE sont utilises
	    ENFORCE     Rgulation des status auto-op et auto-voice
	
	Tapez /msg %S HELP SET option pour plus d'information
	sur une option particulire.

CHAN_HELP_SET_FOUNDER
	Syntaxe: SET canal FOUNDER surnom
	
	Change le propritaire d'un canal.  Le nouveau surnom doit
	en tre un enregistr.

CHAN_HELP_SET_SUCCESSOR
	Syntaxe: SET canal SUCCESSOR surnom
	
	Change le successeur d'un canal.  Si le surnom du
	propritaire expire ou s'il est dsenregistr alors que le
	canal continue d'tre enregistr, le successeur deviendra le
	nouveau propritaire du canal.  Toutefois, si le successeur
	a trop de canaux enregistrs (%d), le canal sera
	dsenregistr  la place, tout comme si aucun successeur
	n'avait t dtermin.  Le surnom doit tre enregistr.

CHAN_HELP_SET_PASSWORD
	Syntaxe: SET canal PASSWORD mot-de-passe
	
	Dtermine le mot-de-passe utilis pour identifier le
	propritaire du canal.

CHAN_HELP_SET_DESC
	Syntaxe: SET canal DESC description
	
	Dtermine la description du canal, laquelle est prsent
	avec les commandes LIST et INFO.

CHAN_HELP_SET_URL
	Syntaxe: SET canal URL url
	
	Associe l'URL donn avec le canal.  Cet URL sera prsent
	chaque fois que quelqu'un requiert de l'information sur le
	canal avec la commande INFO.

CHAN_HELP_SET_EMAIL
	Syntaxe: SET canal EMAIL adresse
	
	Associe l'adresse courriel donne avec le canal.  Cette
	adresse sera prsente chaque fois que quelqu'un requiert de
	l'information sur le canal avec la commande INFO.

CHAN_HELP_SET_ENTRYMSG
	Syntaxe: SET canal ENTRYMSG message
	
	Dtermine le message qui sera envoy via /NOTICE aux usagers
	lorsqu'ils entreront sur le canal.

CHAN_HELP_SET_KEEPTOPIC
	Syntaxe: SET canal KEEPTOPIC {ON | OFF}
	
	Active ou dsactive l'option de rtention de sujet pour un
	canal. Lorsque la rtention de sujet est slectionn, le
	sujet du canal sera retenue par %S mme aprs que le
	dernier usager ait quitt le canal, et sera remis la
	prochaine fois que quelqu'un embarqueras sur le canal.

CHAN_HELP_SET_TOPICLOCK
	Syntaxe: SET canal TOPICLOCK {ON | OFF}
	
	Active et dsactive l'option de barrure de sujet pour un
	canal. Lorsque la barrure de sujet est slectionn,
	%S n'autorisera pas le changement de sujet, except
	par la commande TOPIC.

CHAN_HELP_SET_MLOCK
	Syntaxe: SET canal MLOCK modes
	
	Dtermine les paramtres mode-barrs pour un canal. %S
	permet de dfinir certains modes de canal  tre toujours ON
	(ou OFF).  Tous les modes binaires (n, s, t, k, l, ainsi
	qu'ON) peuvent tre barrs; chaque mode peut tre barr ON,
	barr OFF, ou ne pas tre barrs.  Le paramtre modes est
	construit exactement de la mme manire que la commande
	/MODE; pour ce, les modes prcds d'un "+" sont barrs
	"ON", et les modes prcds d'un "-" sont barrs OFF.
	
	Attention:  Si vous dterminez une clef de mode-barr, tel
	que dans le second exemple ci-dessous, vous devrez galement
	slectionner l'option RESTRICTED pour le canal (voir HELP
	SET RESTRICTED), sans quoi quiconque entrera sur le canal
	alors qu'il est vide pourra voir la clef!
	
	Exemples:
	
	    SET #channel MLOCK +nt-ikl
	        Force les modes n et t  ON, et les modes i, k, et l
	         OFF. Tous les autres modes sont libres d'tre mis
	         ON ou OFF.
	
	    SET #channel MLOCK +knst-ilmp ma-clef
	        Force les modes k, n, s, et t  ON, et les modes i,
	        l, m, et p  OFF.  Force galement la clef du canal
	         tre "ma-clef".
	
	    SET #channel MLOCK +
	        Enlve le mode de barrage; tous les modes de canal
	        sont libres d'tre  ON ou  OFF.

CHAN_HELP_SET_HIDE
	Syntaxe: SET canal HIDE {EMAIL | TOPIC | MLOCK} {ON | OFF}
	
	Vous permet de prvenir que certaines pices d'information
	soient prsentes lorsque quelqu'un fait un %S INFO
	sur le canal donn. Vous pouvez voiler l'adresse courriel du
	canal (EMAIL), le dernier sujet (TOPIC), et le mode de
	barrage (MLOCK).  Le second paramtre spcifie quelle
	information peut tre prsente (OFF) ou masque (ON).
	
	Remarquez que le sujet sera toujours cach si le canal est
	en mode-barr +p ou +s.

CHAN_HELP_SET_PRIVATE
	Syntaxe: SET canal PRIVATE {ON | OFF}
	
	Active ou dsactive l'option private pour un canal.
	Lorsque private est slectionne, un /msg %S LIST
	n'inclura pas le canal dans toutes les listes.

CHAN_HELP_SET_RESTRICTED
	Syntaxe: SET canal RESTRICTED {ON | OFF}
	
	Active ou dsactive l'option d'accs restreint pour un
	canal.  Lorsque restricted access est slectionn, les
	usagers qui n'apparaissent pas sur la liste d'accs ou qui
	normalement ne disposeraient pas des privilges d'oprateur
	seront expulss et bannis du canal.

#CHAN_HELP_SET_SECURE
#	Syntaxe: SET canal SECURE {ON | OFF}
#	
#	Active ou dsactive les dispositifs de scurit de %S
#	pour un canal.  Lorsque SECURE est slectionn, seuls les
#	usagers qui ont enregistrs leurs surnoms avec %s et qui se
#	sont identifis avec leur mot-de-passe pourront recevoir les
#	privilges sur le canal tel que contrl par la liste
#	d'accs.

#CHAN_HELP_SET_SECUREOPS
#	Syntaxe: SET canal SECUREOPS {ON | OFF}
#	
#	Active ou dsactive l'option secure ops pour un canal.
#	Lorsque secure ops est slectionn, les usagers qui
#	n'apparaissent pas sur la liste d'oprateurs ne pourront pas
#	recevoir ce privilge.

#CHAN_HELP_SET_LEAVEOPS
#	Syntaxe: SET canal LEAVEOPS {ON | OFF}
#	
#	Active ou dsactive l'option leave ops pour un canal.
#	Lorsque leave ops est slectionn, %S laissera le
#	status d'oprateur (+o)  la premire personne qui entrera
#	sur le canal, mme si cet usager ne serait normalement pas
#	auto-op.  L'option SECUREOPS et le niveau d'accs AUTODEOP
#	seront renforces. Remarque:  Ceci permet  un usager de
#	"voler" les privilges d'oprateur pendant une rupture de
#	rseau (netsplit).

CHAN_HELP_SET_OPNOTICE
	Syntaxe: SET canal OPNOTICE {ON | OFF}
	
	Active ou dsactive l'option de notice d'oprateur pour un
	canal.  Lorsque op-notice est slectionn, %S expdit
	une notification au canal lors de chaque commande OP ou DEOP
	utilise pour un usager dans le canal.

CHAN_HELP_SET_ENFORCE
	Syntaxe: SET canal ENFORCE {ON | OFF}
	
	Active ou dsactive l'option de rgulation enforce pour un
	canal.  Lorsque enforce est slectionn, %S renforcera
	les niveaux AutoOps et AutoVoice pour tous les usagers.  Par
	exemple, si un usager avec les privilges d'AutoOp est
	dopp, %S le r-opera automatiquement, et %S
	n'autorisera pas non-plus que la commande DEOP soit utilise
	sur cet usager.

CHAN_HELP_UNSET
	Syntaxe: UNSET canal {SUCCESSOR | URL | EMAIL | ENTRYMSG}
	
	Efface la slection donne pour un canal.

CHAN_HELP_SOP
	Syntaxe: SOP canal ADD surnom
	         SOP canal DEL surnom
	         SOP canal LIST [masque | liste]
	         SOP canal COUNT
	
CHAN_HELP_SOP_MID1
	Maintiens la liste des SuperOps (SOP) pour un canal.  Les
	usagers avec un status SOP obtiennent automatiquement les
	privilges d'oprateur de canal (mode +o) lorsqu'ils entrent
	sur le canal.
CHAN_HELP_SOP_MID1_CHANPROT
	
	Maintiens la liste des SuperOps (SOP) pour un canal.  Les
	usagers avec un status SOP sont automatiquement Ops (mode
	+o) et protgs (mode +a) lorsqu'ils joignent le canal.
CHAN_HELP_SOP_MID2
	
	Un SOP peut modifier les listes des AOP et VOP.  Seul un
	propritaire de canal peut modifier la liste des SOP.
CHAN_HELP_SOP_MID2_HALFOP
	
	Un SOP peut modifier les listes des AOP, HOP, et VOP.  Seul
	un propritaire de canal peut modifier la liste des SOP.
CHAN_HELP_SOP_END
	
	La commande SOP LIST prsente la liste des SOP.  Si un
	masque frim est donn, seuls les entres correspondants
	audit masque seront prsentes. Si une liste d'entres
	numriques est donne, seules ces entres seront exposes;
	par exemple:
	
	   SOP #canal LIST 2-5,7-9
	      Prsentations des entres  la Liste SOP numrotes 2
	       5 et 7  9.
	
	La commande SOP COUNT retourne le nombre d'entres prsentes
	dans la liste des SOP.

CHAN_HELP_AOP
	Syntaxe: AOP canal ADD surnom
	         AOP canal DEL surnom
	         AOP canal LIST [masque | liste]
	         AOP canal COUNT
	
	Maintiens la liste des AutoOps (AOP) pour un canal.  Les
	usagers avec un status AOP sont automatiquement ops (mode
	+o) lorsqu'ils joignent le canal.
CHAN_HELP_AOP_MID
	
	Un AOP peut modifier la liste des VOP; les SOPs peuvent
	modifier la liste des AOP.
CHAN_HELP_AOP_MID_HALFOP
	
	Un AOP peut modifier la les listes des HOP et VOP; les SOPs
	peuvent modifier la liste des AOP.
CHAN_HELP_AOP_END
	
	La commande AOP LIST prsente la liste des AOP.  Si un
	masque frim est donn, seuls les entres correspondantes
	audit masque seront prsentes. Si une liste d'entres
	numriques est donne, seules les entres correspondantes
	seront affiches; par exemple:
	
	   AOP #canal LIST 2-5,7-9
	      Prsente les entres de la liste des AOP numrotes 2
	       5 et 7  9.
	
	La commande AOP COUNT retourne le nombre d'entres prsentes
	dans la liste des AOP.

CHAN_HELP_HOP
	Syntaxe: HOP canal ADD surnom
	         HOP canal DEL surnom
	         HOP canal LIST [masque | liste]
	         HOP canal COUNT
	
	Maintiens la liste des HalfOp (HOP) pour un canal.  Les
	usagers disposant d'un status HOP sont automatiquement
	demi-ops (mode +h) lorsqu'ils joignent le canal.
	
	Un HOP peut modifier la liste des VOP; les SOPs et AOPs
	peuvent modifier la liste des HOP.
	
	La commande HOP LIST prsente la liste des HOP.  Si un
	masque frim est donn, seules les entres correspondantes
	audit masque seront prsentes. Si une liste d'entres
	numriques est donne, seules ces entres seront prsentes;
	par exemple:
	
	   HOP #canal LIST 2-5,7-9
	      Prsente les entres de la liste des HOP numrotes de
	      2  5 et de 7  9.
	
	La commande HOP COUNT donne le nombre d'entres prsentes
	sur la liste des HOP.

CHAN_HELP_VOP
	Syntaxe: VOP canal ADD surnom
	         VOP canal DEL surnom
	         VOP canal LIST [masque | liste]
	         VOP canal COUNT
	
	Maintiens la liste des VoiceOp (VOP) pour un canal.  Les
	usagers ayant un status VOP obtiendront automatiquement les
	privilges vocaux (mode +v) lorsqu'ils joindront le canal.
	
	La commande VOP LIST affiche la liste des VOP.  Si un masque
	frim est donn, seules les entres correspondantes audit
	masque seront prsentes.  Si une liste d'entres numriques
	est donne, seules ces entres seront prsentes; par
	exemple:
	
	   VOP #canal LIST 2-5,7-9
	      Prsente les entres de la liste des VOP numrotes de
	      2  5 et de 7  9.
	
	La commande VOP COUNT donne le nombre d'entres prsentes
	sur la liste des HOP.

CHAN_HELP_ACCESS
	Syntaxe: ACCESS canal ADD surnom niveau
	         ACCESS canal DEL {surnom | entre-num | liste}
	         ACCESS canal LIST [masque | liste]
	         ACCESS canal COUNT
	
	Maintiens la liste d'accs pour un canal.  La liste d'accs
	spcifie quels usagers sont autoriss ont le status
	d'oprateur de canal ou ont accs aux commandes de %S
	sur le canal.  Diffrents niveaux d'accs permettent d'avoir
	des sous groupes de privilges; /msg %S HELP ACCESS
	LEVELS pour plus d'information spcifique. Un surnom
	n'apparaissant pas  la liste a un niveau d'usager de 0.
	
	La commande ACCESS ADD ajoute le surnom donn  la liste
	d'accs avec le niveau d'usager spcifi; si le surnom est
	dj prsent dans la liste, son niveau d'accs sera chang
	au niveau spcifi dans la commande.  Le niveau spcifi
	doit tre infrieur  celui de l'usager qui donne la
	commande, et si le surnom apparait dj sur la liste, le
	niveau actuel de l'accs de ce surnom doit tre infrieur 
	celui de l'usager qui entre la commande.
	
	La commande ACCESS DEL retire le surnom donn de la liste
	d'accs.  Si une liste d'entres numriques est donne,
	celles-ce seront effaces. (voir l'exemple pour LIST
	ci-aprs.)
	
	La commande ACCESS LIST prsente la liste des accs. Si un
	masque frim est donn, seules les entres y correspondant
	seront prsentes.  Si une liste d'entres numriques est
	donne, seules ces entres seront prsentes; par exemple:
	
	   ACCESS #canal LIST 2-5,7-9
	      Prsente les entres de la liste numrotes de 2  5
	      et de 7  9.
	
	
	La commande ACCESS COUNT donne le nombre d'entres prsentes
	sur la liste d'accs.
CHAN_HELP_ACCESS_XOP
	
	Notez que la liste d'accs peut galement tre manipule
	avec les commandes SOP, AOP, et VOP, lesquels correspondent
	aux niveaux de %d, %d, et %d respectivement.
CHAN_HELP_ACCESS_XOP_HALFOP
	
	Notez que la liste d'accs peut aussi tre manipule avec
	les commandes SOP, AOP, et HOP, et VOP, lesquelles
	correspondent aux niveaux de %d, %d, %d, et %d
	respectivement.

CHAN_HELP_ACCESS_LEVELS
	Niveaux d'accs des usagers
	
	Par dfaut, les niveaux d'accs suivants sont dfinis:
	
	   Propritaire   Plein accs aux fonctions de %S;
	                    automatique
	                      status d'oprateur ds l'entre sur le canal.  Notez que
	                      seulement une personne peut avoir le status de propritaire
	                      (a ne peut pas tre donn en utilisant la commande
	                      ACCESS).
	            %4d   Accs  la commande AKICK; oprateur automatique.
	            %4d   Oprateur automatique.
CHAN_HELP_ACCESS_LEVELS_HALFOP
	            %4d   Demi-oprateur automatique.
CHAN_HELP_ACCESS_LEVELS_END
	            %4d   Status vocal automatique.
	              0   Sans privilges spcifiques; peut tre op par les autres
	                      oprateurs (sauf si SECUREOPS est slectionn).
	             -1   Ne peut pas tre oprateur.
	           -100   Ne peut pas joindre le canal.
	
	Ces niveaux ( l'exception des deux derniers) peuvent tre
	changs, ou de nouveaux ajoutsm en utilisant la commande
	LEVELS; tapez /msg %S HELP LEVELS pour les dtails.

CHAN_HELP_LEVELS
	Syntaxe: LEVELS canal SET type niveau
	         LEVELS canal {DIS | DISABLE} type
	         LEVELS canal LIST
	         LEVELS canal RESET
	
	La commande LEVELS permet un contrle plus rafin que la
	signification des niveaux numriques d'accs utiliss dans
	la commande ACCESS.  Avec cette commande, vous pouvez
	dfinir le niveau d'accs requis pour la plupart des
	fonctions de %S.  (Les commandes SET FOUNDER et SET
	PASSWORD, ainsi que cette commande, sont toujours
	restreintes  l'usage du propritaire du canal.)
CHAN_HELP_LEVELS_XOP
	
	Attention:  Cette commande est pour les usagers avancs
	seulement!  Changer le niveau d'ajustement avec cette
	commande peut empcher les commandes SOP, AOP, et VOP de
	fonctionner correctement.
CHAN_HELP_LEVELS_XOP_HOP
	
	Attention:  Cette commande est pour les usagers avancs
	seulement!  Changer le niveau d'ajustement avec cette
	commande peut empcher les commandes SOP, AOP, HOP et VOP de
	fonctionner correctement.
CHAN_HELP_LEVELS_END
	
	LEVELS SET permet de changer le niveau d'accs pour une
	fonction ou un groupe de fonctions.  LEVELS DISABLE (ou le
	racourci DIS) dsactive une composante ou rend impossible
	d'accder  une fonction par quiconque autre que le
	propritaire du canal.  LEVELS LIST prsente le niveau
	actuel requis pour chaque fonction ou groupe de fonctions.
	LEVELS RESET remet  leur position d'origine les niveaux
	d'un canal nouvellement-cr (voir HELP ACCESS LEVELS).
	
	Pour une liste des accessoires et fonctions pour lesquels
	des niveaux peuvent tre dtermins, voir HELP LEVELS DESC.

CHAN_HELP_LEVELS_DESC
	Les noms d'accessoires/fonctions suivants sont compris:

CHAN_HELP_AKICK
	Syntaxe: AKICK canal ADD masque [raison]
	         AKICK canal DEL masque
	         AKICK canal LIST [masque | liste]
	         AKICK canal VIEW [masque | liste]
	         AKICK canal ENFORCE
	         AKICK canal COUNT
	
	Maintien la liste d'auto-expulsion pour un canal.  Si un
	usager inscrit  la liste d'auto-expulsion (autokick) tente
	de joindre le canal, %S bannira cet usager du canal,
	ensuite expulsera l'usager.
	
	La commande AKICK ADD ajoute l'usager@hte ou
	surnom!usager@hte masque  la liste d'autokick.  Si une
	raison est donne avec la commande, cette raison sera
	utilise lorsque l'usager sera expuls afin de justifier
	cette action; si aucune raison n'est donne, la raison par
	dfaut suivante "Vous avez t banni de ce canal" sera
	utilise.
	
	La commande AKICK DEL retire le masque donn de la liste
	d'autoexpulsion (autokick).  a ne retire toutefois pas,
	tous les bans placs par un auto-expulsion; ces derniers
	doivent tre retirs manuellement.
	
	La commande AKICK LIST prsente la liste d'auto-expulsion,
	ou optionnellement seulement les entres "autokick"
	correspondant au masque donn avec la commande. AKICK VIEW
	est similaire, mais prsente plus de dtails.
	
	La commande AKICK ENFORCE force %S  rgulariser
	l'entre en vigueur de l'actuelle liste d'auto-expulsion en
	retirant les usagers qui correspondent avec un masque
	d'auto-expulsion donn.
	
	La commande AKICK COUNT retourne le nombre total d'entres
	inscrites actuellement sur la liste d'auto-expulsion du
	canal.
	
	Par dfaut, limit aux usagers ayant accs avec %s qui
	sont prsent actuellement sur le canal.

CHAN_HELP_INFO
	Syntaxe: INFO canal [ALL]
	
	Prsente l'information disponible  propos du nom de canal
	enregistr donn, incluant qui est le propritaire, le
	moment de l'enregistrement, sa dernire utilisation, la
	description, les modes barrs, s'il y en a.  Si vous tes
	identifis comme tant le propritaire dudit canal, vous
	recevrez TOUTE l'information, si ALL est spcifi, le
	message d'entre et le successeur seront galelement
	prsents.

CHAN_HELP_LIST
	Syntaxe: LIST modle
	
	Prsente tous canaux enregistrs correspondant au modle
	donn. (Les canaux avec l'option PRIVATE slectionne ne
	seront pas prsents.)
CHAN_HELP_LIST_OPERSONLY
	
	Seuls les Oprateurs d'IRC peuvent utiliser cette commande.

CHAN_HELP_OP
	Syntaxe: OP canal [surnom]
	
	Accorde le status d'oprateur au surnom slectionn sur un
	canal.  Si aucun surnom n'est donn, vous accordera le
	status d'oprateur.  Par dfaut, limit aux usagers ayant
	accs auprs de %s qui sont prsent sur le canal.

CHAN_HELP_DEOP
	Syntaxe: DEOP canal [surnom]
	
	Retire le status d'oprateur au surnom slectionn sur le
	canal don.  Si aucun surnom n'est donn, vous retire ce
	status.  Par dfaut, limit aux usagers ayant accs auprs
	de %s prsent sur le canal.

CHAN_HELP_VOICE
	Syntaxe: VOICE canal [surnom]
	
	Accorde les privilges vocaux au surnom slectionn sur le
	canal.  Si aucun surnom n'est donn, vous accorde ce status
	(+v).  Par dfaut, limit aux usagers ayant accs auprs de
	%s prsent sur le canal.

CHAN_HELP_DEVOICE
	Syntaxe: DEVOICE canal [surnom]
	
	Retire le privilge vocal au surnom donn sur le canal.  Si
	aucun surnom n'est donn, vous retire le privilge.  Par
	dfaut, limit aux usagers ayant accs auprs de %s
	prsent sur le canal.

CHAN_HELP_HALFOP
	Syntaxe: HALFOP canal [surnom]
	
	Accorde un accs demi-oprateur au surnom donn sur le
	canal.  Si aucun surnom n'est donn, vous accorde cet accs
	demi-oprateur.  Par dfaut, limit aux usagers ayant accs
	auprs de %s prsent sur le canal.

CHAN_HELP_DEHALFOP
	Syntaxe: DEHALFOP canal [surnom]
	
	Retire l'accs demi-oprateur du surnom slectionn sur le
	canal.  Si aucun surnom n'est donn, vous retire l'accs
	demi-oprateur.  Par dfaut, limit aux usagers ayant accs
	auprs de %s prsent sur le canal.
	
CHAN_HELP_PROTECT
	Syntaxe: PROTECT canal [surnom]
	
	Accorde une protection de canal (mode+a) au surnom
	slectionn sur le canal. Si aucun surnom n'est donn, vous
	accorde cette protection de canal.  Par dfaut, limit aux
	usagers ayant accs auprs de %s prsent sur le canal.

CHAN_HELP_DEPROTECT
	Syntaxe: DEPROTECT canal [surnom]
	
	Retire une protection de canal (mode+a) au surnom
	slectionn sur le canal.  Si aucun surnom n'est donn, vous
	retire cette protection de canal.  Par dfaut, limit aux
	usagers ayant accs auprs de %s prsent sur le canal.

CHAN_HELP_INVITE
	Syntaxe: INVITE canal
	
	Dit  %S de vous inviter sur le canal donn.  Par
	dfaut, limit aux usagers ayant accs auprs de %s prsent
	sur le canal.
	
	Remarque: Si vous recevez un message vous avisant que le
	canal n'est pas utilis, cela signifie que le canal est
	vide, et vous pouvez le joindre librement, sans utiliser
	cette commande.

CHAN_HELP_UNBAN
	Syntaxe: UNBAN canal
	
	Demande  %S de retirer tous les bans vous empchant
	d'entrer sur le canal donn.  Par dfaut, limit aux usagers
	ayant accs auprs de %s inscrits sur le canal.

CHAN_HELP_KICK
	Syntaxe: KICK canal surnom [raison]
	
	Demande  %S d'explulser le surnom donn du canal
	donn.  Le message compris avec l'expulsion prsentera qui a
	donn la commande KICK, ainsi que la raison donne avec la
	commande, s'il y en a une.  Par dfaut, limit aux usagers
	ayant accs avec %s inscrits sur le canal.

CHAN_HELP_KICK_PROTECTED
	
	Remarquez qu'un usager protg (+a) ne peut pas tre expuls
	du canal avec cette commande, mme par le propritaire du
	canal.

CHAN_HELP_TOPIC
	Syntaxe: TOPIC canal le sujet dsir
	
	Demande  %S de remplacer le sujet du canal pour celui
	spcifi.  Cette commande est plus utilise conjointement
	avec SET TOPICLOCK. Par dfaut, limit aux usagers ayant
	accs  %s inscrits pour le canal.

CHAN_HELP_CLEAR
	Syntaxe: CLEAR canal quoi
	
	Demande  %S d'effacer certains ajustements sur un
	canal.  Quoi peut tre un des lments suivants:
	
	    MODES       Efface tous les modes sur le canal 
	                    l'exception de ceux slectionn dans le
	                    mode-barr du canal.
	    BANS        Efface tous les bans du canal.
CHAN_HELP_CLEAR_EXCEPTIONS
	    EXCEPTIONS  Efface toutes les exceptions du canal.
CHAN_HELP_CLEAR_MID
	    OPS         Retire le status d'oprateur-canal
	                    (mode +o) de tous les usagers.
CHAN_HELP_CLEAR_HALFOPS
	    HALFOPS     Retire le status demi-oprateur (mode +h) 
	                    tous les usagers.
CHAN_HELP_CLEAR_END
	    VOICES      Retire le status "vocal" (mode +v)  tous
	                    les usagers.
	    USERS       Retire (expulse) tous les usagers du canal.
	
	Par dfaut, limit aux usagers ayant accs auprs de
	%s et qui sont prsent sur le canal.

CHAN_HELP_STATUS
	Syntaxe: STATUS canal surnom
	
	Retourne l'actuel niveau d'accs pour un surnom donn sur le
	canal donn.  La rponse prend la forme suivante:
	
	    STATUS canal surnom niveau-d'accs
	
	Si une erreur survient, la rponse prendra la forme
	suivante:
	
	    STATUS canal surnom ERROR message-d'erreur
	
	Par dfaut, limit aux usagers ayant accs auprs de
	%s et qui sont prsent sur le canal.

CHAN_OPER_HELP_COMMANDS
	
	Les commandes suivantes sont rserves aux Administrateurs
	des services:
	
CHAN_OPER_HELP_COMMANDS_GETPASS
	    GETPASS    Obtenir le mot-de-passe du propritaire d'un
	                   canal (seulement si l'encryption n'est
	                   pas en cours)
CHAN_OPER_HELP_COMMANDS_FORBID
	    FORBID     Empche un canal d'tre enregistr/utilis
	    SUSPEND    Empche un canal enregistr d'tre utilis
	    UNSUSPEND  Annule une suspension de canal
CHAN_OPER_HELP_COMMANDS_END
	
	Les Administrateurs des Services peuvent galement annuler
	l'enregistrement de n'importe quel canal sans avoir 
	s'identifier par mot-de-passe, et peuvent voir les listes
	d'accs, d'AKICK, ainsi que la liste des ajustements ou
	utiliser la commande STATUS pour n'importe quel canal.

CHAN_OPER_HELP_DROP
	Syntaxe: DROP canal
	
	Dsenregistre le canal nomm.  Seuls les Administrateurs des
	Services peuvent dsenregistrer un canal pour lequel ils ne
	sont pas identifis.

CHAN_OPER_HELP_SET
	
	Les Administrateurs des Services peuvent galement
	slectionner l'option NOEXPIRE, laquelle permet de prvenir
	l'expiration d'un canal.  En plus, les Administrateurs des
	Services peuvent slectionner les options pour n'importe
	quel canal sans avoir  s'identifier par mot-de-passe pour
	le canal.

CHAN_OPER_HELP_SET_NOEXPIRE
	Syntaxe: SET canal NOEXPIRE {ON | OFF}
	
	Dtermine si le canal donn doit expirer.  Dterminer cet
	ajustement  ON prvient l'expiration du canal.
	
	Limit  l'usage des Administrateurs des Services.

CHAN_OPER_HELP_UNSET
	
	Comme avec la commande SET, les Administrateurs des Services
	peuvent effacer les ajustements pour n'importe quel canal
	sans s'identifier pour le canal.

CHAN_OPER_HELP_INFO
	
	Les Administrateurs des Services peuvent utiliser le
	paramtre ALL avec tous les canaux.

CHAN_OPER_HELP_LIST
	Syntaxe: LIST modle [FORBIDDEN] [NOEXPIRE] [SUSPENDED]
	
	Donne le sommaire de tous les canaux correspondant au modle
	donn.  Les canaux ayant l'option PRIVATE dtermine
	apparaitront seulement aux Administrateurs des Services.
	Les canaux ayant l'option NOEXPIRE slectionne seront
	prcds d'un ! avant leur nom pour les Administrateurs
	des Services.
	
	Si les options FORBIDDEN, SUSPENDED ou NOEXPIRE sont
	donnes, seuls les canaux qui, respectivement, sont
	interdits, suspendus ou qui ont l'option NOEXPIRE en vigueur
	seront prsents.  Les options peuvent tre utilises dans
	n'importe quel ordre et dans n'importe quelle combinaison.
	Ces options sont limites  l'usage des Administrateurs des
	Services.

CHAN_OPER_HELP_GETPASS
	Syntaxe: GETPASS canal
	
	Donne le mot-de-passe pour un canal donn.  Remarquez que
	chaque fois que cette commande est utilise, un message
	incluant le nom de la personne qui a fait la commande et le
	canal pour lequel elle a t utilise sera sauv et expdi
	sous forme de WALLOPS/GLOBOPS.
	
	Si l'encryption est en utilisation, cette commande risque de
	ne pas tre disponible, dpendamment du type d'encryption
	utilis.
	
	Limit  l'usage des Administrateurs des Services.

CHAN_OPER_HELP_FORBID
	Syntaxe: FORBID canal
	
	Interdit  quiconque d'enregistrer ou utiliser le canal
	donn.  Peut tre annul en dsenregistrant (commande DROP)
	le canal.
	
	Limit  l'usage des Administrateurs des Services.

#CHAN_OPER_HELP_SUSPEND
#	Syntaxe: SUSPEND [+expiration] canal raison
#	
#	Interdit l'utilisation et l'identification  un canal par
#	quiconque.  Un canal suspendu peut tre d-suspendu avec la
#	commande UNSUSPEND.
#	
#	Contrairement  un canal interdit, un canal suspendu ne perd
#	pas ses information et fini par expirer!
#	
#	Limit  l'usage des Administrateurs des Services.

CHAN_OPER_HELP_UNSUSPEND
	Syntaxe: UNSUSPEND canal
	
	Permet aux usager d'utiliser et de s'identifier pour un
	canal qui avant tait suspendu.
	
	Limit  l'usage des Administrateurs des Services.


###########################################################################
#
# MemoServ help messages
#
###########################################################################

MEMO_HELP
	%S est un utilitaire permettant aux usagers IRC
	d'expdier de courts messages aux autres usagers IRC ou au
	canaux (*), mme s'ils ne sont pas en-ligne au moment de
	l'expdition.  Les surnoms tant de l'expditeur que de la
	cible ou le canal doivent tre enregistrs afin que le
	message puisse tre expdi et dlivr.  Tapez /msg %S
	HELP COMMANDS pour la liste des commandes de %S; pour
	utiliser une commande, tapez /msg %S commande, ou pour
	plus d'information sur une commande, tapez /msg %S
	HELP commande.
MEMO_HELP_EXPIRES
	
	Remarque:  Les messages expireront (seront automatiquement
	effacs) %s aprs avoir t expdis, s'ils ne sont
	pas spcifis n'expirant-pas avec la commande SAVE.
MEMO_HELP_END_LEVELS
	
	(*) Par dfaut, chaque usager avec un accs minimum de
	    %s sur un canal peut lire les messages adresss au
	    canal.  Ceci peut tre chang avec la commande %s
	    LEVELS.
	
MEMO_HELP_COMMANDS
	Les commandes suivantes peuvent tre utilises avec %S:
	
	    SEND      Expdier un message  un usager ou un canal
	    LIST      Sommaire de vos messages
	    READ      Lire un ou plusieurs messages
MEMO_HELP_COMMANDS_FORWARD
	    FORWARD   Faire suivre vos messages  votre adresse
	                  courriel
MEMO_HELP_COMMANDS_SAVE
	    SAVE      Spcifier un message comme n'expirant-pas
MEMO_HELP_COMMANDS_DEL
	    DEL       Effacer un ou plusieurs message(s)
	    SET       Dterminer une option relative aux messages
	    INFO      Prsenter l'information relative aux messages
MEMO_HELP_COMMANDS_IGNORE
	    IGNORE    Ignorer les messages provenant de certains
	                  usagers

MEMO_HELP_SEND
	Syntaxe: SEND {surnom | canal} texte du message
	
	Expdie au surnom ou canal nomm un message contenant le
	texte du message.  Lorsque vous expdiez  un surnom,
	l'usager recevra une notification qu'il/elle a reu un
	nouveau message.  La cible (surnom/canal) doit tre
	enregistre.

MEMO_HELP_LIST
	Syntaxe: LIST [canal] [num | liste | NEW]
	
	Sommaire de tous les messages que vous avez actuellement.
	Avec NEW, prsente seulement vos messages nouveaux
	(non-lus).  Les messages non-lus sont marqus avec un "*" 
	gauche du numro de message.  Vous pouvez galement
	spcifier une liste de numro, tel que dans l'exemple
	suivant:
	
	   LIST 2-5,7-9
	      Prsente les messages numrots 2  5 et 7  9.

MEMO_HELP_LIST_EXPIRE
	Syntaxe: LIST [canal] [num | liste | NEW]
	
	Sommaire de tous les messages que vous avez actuellement.
	Avec NEW, prsente seulement les nouveaux messages
	(non-lus).  Les messages non-lus sont marqus d'un "*" 
	gauche de leur numro; les messages n'expirant-pas sont
	marqus avec un "+".  Vous pouvez galement spcifier une
	liste de numros comme dans l'exemple suivant:
	
	   LIST 2-5,7-9
	      Prsente les messages numrots 2  5 et 7  9.

MEMO_HELP_READ
	Syntaxe: READ [canal] {num | liste | LAST | NEW}
	
	Vous envois le texte du ou des message(s) spcifi(s).  Si
	vous spcifiez LAST, vous envois le texte du message le plus
	rcent.  Si vous spcifiez NEW, vous envois tous vos
	nouveaux messages.  Autrement, vous envois le message
	correspondant au numro num.  Vous pouvez galement donner
	une liste de numros, tel que dans la commande LIST.

MEMO_HELP_SAVE
	Syntaxe: SAVE [canal] {num | liste}
	
	Marque le(s) numro(s) de message comme n'expirant pas.
	Vous pouvez donner autant un simple numro de message, ou
	comme dans la commande LIST, une liste de numros de
	messages.

#MEMO_HELP_DEL
#	Syntaxe: DEL [canal] {num | liste | ALL}
#	
#	Efface le(s) message(s) spcifi(S).  Vous pouvez galement
#	fournir plusieurs numros de messages ou un gamme de numros
#	au lieu d'un simple numro, tel que dans le second exemple
#	ci-bas.
#	
#	Si vous donnez ALL, efface tous vos messages.
#	
#	Exemples:
#	
#	   DEL 1
#	      Efface votre premier message.
#	
#	   DEL 2-5,7-9
#	      Efface les messages numrots 2  5 et 7  9.

MEMO_HELP_SET
	Syntaxe: SET option paramtres
	
	Dtermine divers options de message.  L'option peut tre
	une des suivantes:
	
	    NOTIFY      Change le moment o vous serez notifis de
	                    la rception de vos nouveaux messages
	                    (seulement pour les surnoms)
	    LIMIT       Dtermine le nombre maximum de message que
	                    vous pouvez recevoir
MEMO_HELP_SET_OPTION_FORWARD
	    FORWARD     Dtermine que tous vos messages vous seront
	                    automatiquement expdis (sur votre
	                    adresse courriel)
MEMO_HELP_SET_END
	
	Tapez /msg %S HELP SET option pour plus d'information
	sur une option spcifique.

MEMO_HELP_SET_NOTIFY
	Syntaxe: SET NOTIFY {ON | LOGON | NEW | OFF}
	
	Modifie le moment o vous serez notifi de la rception de
	nouveaux messages:
	
	    ON      Vous serez notifis de vos messages lorsque vous
	               vous connecterez, quand vous enlverez
	               l'option /AWAY, de mme que lorsqu'ils vous
	               seront expdis.
	    LOGON   Vous serez exclusivement notifis de vos
	               messages lorsque vous vous connecterez ou
	               lorsque vous enlverez l'option /AWAY.
	    NEW     Vous serez exclusivement notifis de vos
	               messages lorsqu'il vous seront expdis.
	    OFF     Vous ne recevrez aucune notification de vos
	               messages.
	
	ON est quivalent  LOGON et NEW combins.
	
	Notez que si votre surnom a l'option "secure" en fonction,
	vous serez notifis de vos messages (pour LOGON ou ON)
	seulement aprs vous tre identifi auprs de %s.

MEMO_HELP_SET_LIMIT
	Syntaxe: SET LIMIT [canal] limite
	
	Dtermine le nombre maximum de messages que vous (ou le
	canal donn) tes autoris  recevoir.  Si vous dterminez
	cette limite  0, personne ne sera en mesure de vous
	expdier un message.  Toutefois, vous ne pouvez pas
	dterminer une limite suprieure  %d.

MEMO_HELP_INFO
	Syntaxe: INFO [canal]
	
	Prsente l'information relative au nombre de message que
	vous avez, combien d'entre-eux sont non-lus, combien de
	message vous pouvez recevoir au total et le moment o vous
	tes avertis de vos nouveaux messages.  Avec un paramtre,
	prsente la mme information pour un canal donn.

MEMO_OPER_HELP_COMMANDS
	
	Les Administrateurs des Services peuvent utiliser les
	commandes SET et INFO avec des surnoms autres que les-leurs.

MEMO_OPER_HELP_SET_LIMIT
	Syntaxe: SET LIMIT [surnom | canal] {limite | NONE | DEFAULT} [HARD]
	
	Dtermine le nombre maximum de messages qu'un surnom (ou
	canal) est autoris  recevoir.  Dterminer une limite de 0
	fait en sorte que le surnom ne peut pas en recevoir aucun;
	slectionner NONE permet au surnom d'en recevoir et d'en
	conserver autant qu'il le dsire; et dterminer DEFAULT
	remet  la valeur par dfaut (%d) la limite de message.  Si
	vous ne spcifiez aucun surnom ou canal, votre propre limite
	sera dtermine.
	
	Ajouter HARD empche un usager de changer la limite.  Ne pas
	ajouter HARD a l'effet oppos, permettant ainsi  l'usager
	de changer la limite (mme si une limite avait
	antrieurement t dtermine avec HARD).
	
	Cette utilisation de la commande SET LIMIT est limite aux
	Administrateurs des Services.  Les autres usagers peuvent
	seulement entrer une limite pour eux-mme ou pour un canal
	sur lequel ils ont les privilges ncessaires, ils ne
	peuvent pas enlever leur limite ou remettre leur limite  sa
	valeur par dfaut ou encore dterminer une limite au dessus
	de %d, et ils ne peuvent pas fixer de limite ferme.

MEMO_OPER_HELP_INFO
	Syntaxe: INFO [surnom | canal]
	
	Sans paramtre, prsente l'information relative au nombre de
	messages que vous avez, combien d'entre-eux sont non-lus,
	combien de message vous pouvez recevoir au total et quand
	vous tes notifis de la rception de la rception de vos
	nouveaux messages.
	
	Avec un paramtre "canal", prsente la mme information pour
	le canal donn.
	
	Avec un paramtre "surnom", prsente la mme information
	relativement au surnom donn.  Cette application est limite
	aux Administrateurs des Services.


MEMO_HELP_FORWARD
	Syntaxe: FORWARD {num | liste | ALL}
	
	Fait suivre un ou plusieurs de vos messages  votre adresse
	courriel.  Vous devez avoir donn une adresse courriel
	valide pour votre surnom afin de pouvoir utiliser cette
	commande.  Les messages adresss  un canal ne peuvent tre
	expdis par cette commande.

MEMO_HELP_SET_FORWARD
	Syntaxe: SET FORWARD {ON | COPY | OFF}
	
	Commande  %S de faire automatiquement suivre sur
	votre adresse courriel les messages qui vous sont expdis.
	Lorque vous spcifiez ON, les messages expdis  votre
	surnom seront plutt envoys  l'adresse courriel
	enregistre avec votre surnom.  COPY est similaire, mais en
	plus demande  %S de sauvegarder une copie du message
	pour lecture en-ligne.  Lorsque vous spcifiez OFF, vos
	messages ne seront plus sauvs en-ligne comme  l'habitude.
	Mme si vous dterminez ON, vous pouvez continuer de
	recevoir des messages en-ligne si les Services ne sont pas
	capables de vous les transmettre sur votre adresse courriel.
	
	Remarquez que lorsque l'option est spcifie  COPY et que
	vous avez atteint le nombre maximum de message qu'il vous
	est permi de recevoir, vous ne pourrez pas recevoir de
	nouveaux messages (galement par courriel) tant que vous
	n'aurez pas effac quelques vieux messages en utilisant la
	commande DEL.

MEMO_HELP_IGNORE
	Syntaxe: IGNORE {ADD | DEL | LIST} [surnom | masque]
	
	Contrle la liste des usagers "ignors"; les usagers dont le
	surnom ou le masque usager@hte correspond  une entre sur
	cette liste ne seront pas autoriss  vous expdier de
	messages.  ADD ajoute le surnom ou le masque usager@hte 
	votre liste d'usagers ignors, et DEL retire le surnom ou le
	masque usager@hte donn de la liste; LIST vous prsente
	votre liste actuelle d'usagers ignors.
	
	Remarquez que le surnom ou le masque donn avec la commande
	ADD doit contenir "*" ou "?" comme frime, et ce n'est pas un
	cas particulier; par exemple, "*Evil*" correspond 
	"EvilNick", "AN_EVIL_USER" et "devil".


###########################################################################
#
# OperServ help messages
#
###########################################################################

OPER_HELP
	%S permet aux Oprateurs d'IRC de contrler plusieurs
	aspects du rseau.  Tapez /msg %S HELP COMMANDS pour
	une liste de ces commandes.
	
	Remarque: Toutes les commandes expdies  %S sont
	sauvegardes!

OPER_HELP_COMMANDS
	Commandes de %S:
	    GLOBAL      Expdier un message  tous les usagers
	    STATS       Prsente le status des Services et du rseau
	    SERVERMAP   Prsente la carte des servers sur le rseau
	    OPER LIST   Prsente la liste de tous les Oprateurs des
	                    Services
	    ADMIN LIST  Prsente la liste de tous les
	                    Administrateurs des Services
OPER_HELP_COMMANDS_SERVOPER
	
	Commandes disponibles pour les Oprateurs et Administrateurs
	des Services seulement:
	    MODE        Changer un mode de canal
	    KICK        Expulser un usager d'un canal
	    CLEARMODES  Retirer certains modes d'un canal
	    CLEARCHAN   Retirer tous les usagers d'un canal
	                    (expulsion de masse)
	    KILLCLONES  Dbrancher tous les usagers utilisant un
	                    certain hte
OPER_HELP_COMMANDS_AKILL
	    AKILL       Manipuler la liste AKILL
OPER_HELP_COMMANDS_EXCLUDE
	    EXCLUDE     Manipuler la liste d'exclusion d'autokill
OPER_HELP_COMMANDS_SLINE
	    SGLINE      Manipuler la liste SGLINE
	    SQLINE      Manipuler la liste SQLINE
	    SZLINE      Manipuler la liste SZLINE
OPER_HELP_COMMANDS_SESSION
	    SESSION     Voir la liste des session htesses
	    EXCEPTION   Modifier la liste d'exception de limitation
	                    de session
OPER_HELP_COMMANDS_NEWS
	    LOGONNEWS   Definir un messages  tre prsent aux
	                    usagers au branchement
	    OPERNEWS    Definir un messages  tre prsent aux
	                    usagers qui deviennent Oprateur IRC
OPER_HELP_COMMANDS_SERVADMIN
	
	Commandes disponibles pour les Administrateurs des Services
	seulement:
	    OPER        Modifer la liste des Oprateurs des Services
	    JUPE        Ajoute un serveur fictif  la liste des
	                    serveurs
	    SET         Dterminer diverses options globales des
	                    Services
	    UPDATE      Force les banques de donnes des Services 
	                    tre mis--jour sur le disque
	                    immdiatement
	    SHUTDOWN    Sauvegarde des banques de donnes et arrt
	                    des Services
	    QUIT        Mettre fin aux services sans sauvegarder les
	                    banques de donnes
	    RESTART     Sauvegarde des banques de donnes et
	                    redmarrage des Services
	    REHASH      Re-lecture de fichiers de configuration
	    SU          Obtenir les privilges de Super-usager des
	                    Services
OPER_HELP_COMMANDS_SERVROOT
	
	Commandes disponibles exclusivement pour les Super-usagers
	des Services:
	    ADMIN       Modifier la liste des Administrateurs des
	                    Services
OPER_HELP_COMMANDS_RAW
	    RAW         Donner un point sensible au serveur IRC

OPER_HELP_GLOBAL
	Syntaxe: GLOBAL message
	
	Permet aux Oprateurs d'IRC d'expdier un message  tous les
	usagers du rseau. Le message sera expdi sous le surnom
	%s.

OPER_HELP_STATS
	Syntaxe: STATS [RESET | NETWORK | ALL]
	
	Sans aucune option, prsente le nombre actuel d'usagers et
	d'IRCops en-ligne (excluant les Services), le nombre le
	plus lev d'usagers en-ligne depuis que les Services ont
	t dmarrs, et le temps coul depuis le dmarrage des
	Services.
	
	Avec l'option RESET, rtablit le compteur de maximum
	d'usager au nombre d'usagers actuellement en-ligne.
	
	Avec l'option NETWORK, prsente le nombre de donnes
	expdies et reues  partir du serveur relais, ainsi que la
	quantit de mmoire utilise par les tampons
	rception/expdition du rseau.  Le ratio d'utilisation
	actuelle des tampons de mmoire est galement prsent sous
	forme de pourcentage, si une limite est configure.
	
	L'option ALL est rserve aux Administrateurs des Services,
	et prsente l'information sur l'utilisation de la mmoire
	des Services.  Utiliser cette option peut geler les Services
	pour une courte priode de temps sur un vaste rseau, donc
	ne l'utilisez pas trop!
	
	UPTIME peut tre utilis comme synonyme pour STATS.

OPER_HELP_SERVERMAP
	Syntaxe: SERVERMAP
	
	Prsente un plan des serveurs connects au rseau, avec le
	point de vue des Services.  Les "Faux" serveurs--Les
	Services eux-mme et tous les serveurs simuls avec la
	commande JUPE--ont un "(*)" affich aprs leur nom de
	serveur.

OPER_HELP_OPER
	Syntaxe: OPER ADD surnom
	         OPER DEL surnom
	         OPER LIST
	
	Permet aux Administrateurs des Services d'ajouter ou retirer
	des surnoms dans ou de la liste des Oprateurs des Services.
	Un usager dont le surnom est dans la liste des Oprateurs
	des Services et qui est identifi auprs de %s pourra
	avoir accs aux commandes des Oprateurs des Services.
	
	Tous les Oprateurs d'IRC peuvent utiliser la forme de
	commande OPER LIST.  Toutes les autres formes sont limites
	 l'usage des Administrateurs des Services.

OPER_HELP_ADMIN
	Syntaxe: ADMIN ADD surnom
	         ADMIN DEL surnom
	         ADMIN LIST
	
	Permet aux Super-usagers des Services d'ajouter ou retirer
	des surnoms de ou dans la liste des Administrateurs des
	Services.  Un usager dont le surnom apparait  la liste des
	Administrateurs des Services et qui est identifi auprs de
	%s sera capable d'accder aux commandes des
	Administrateurs des Services.
	
	Tous les Oprateurs d'IRC peuvent utiliser la forme
	ADMIN LIST de la commande.  Toutes les autres applications
	sont limites aux Super-usagers des Services.

OPER_HELP_MODE
	Syntaxe: MODE canal modes
	
	Permet aux Oprateurs des Services de dterminer un mode de
	canal pour n'importe quel canal.  Les paramtres sont les
	mmes que pour la commande normale /MODE.
	
	Limit aux Oprateurs des Services.

OPER_HELP_CLEARMODES
	Syntaxe: CLEARMODES canal [ALL]
	
	Efface tous les modes binaires (n,s,t,k,l, ainsi qu'ON) de
	mme que les bans d'un canal.  Si ALL est spcifi, efface
	galement tous les modes des usagers (comme +o et +v) sur le
	canal.
	
	Limit aux Oprateurs des Services.

OPER_HELP_CLEARCHAN
	Syntaxe: CLEARCHAN canal
	
	Expulse tous les usagers d'un canal (masskick).
	
	Limit aux Oprateurs des Services.

OPER_HELP_KICK
	Syntaxe: KICK canal user raison
	
	Permet aux Oprateurs d'IRC d'expulser un usager de
	n'importe quel canal.  Les paramtres sont les mmes que
	pour la commande /KICK normale.  Le message d'expulsion
	donnera le nom de l'Oprateur d'IRC qui a donn la commande;
	par exemple:
	
	*** SpamMan has been kicked off channel #mon_canal by
	    %S (Alcan (Flood))
	
	Limit aux Oprateurs des Services.

OPER_HELP_AKILL
	Syntaxe: AKILL ADD [+expiration] masque raison
	         AKILL DEL masque
	         AKILL LIST [masque] [NOEXPIRE]
	         AKILL VIEW [masque] [NOEXPIRE]
	         AKILL COUNT
	
	Permet aux Oprateurs des Services de manipuler la liste
	d'autokill (AKILL).  Si un usager correspondant  un masque
	d'AKILL tente de se connecter, les Services feront un KILL
	pour cet usager et, sur les types de serveurs le supportant,
	donneront l'instruction  tous les serveurs d'ahouter un ban
	(K-line) pour le masque auquel l'usager correspond.
	
	AKILL ADD ajoute le masque usager@hte donn  la liste
	d'AKILL pour la raison donne (laquelle doit tre donne.)
	AKILL DEL retire le masque donn de la liste d'AJILL si il y
	est prsent.  AKILL LIST prsente tous les AKILLs actuels;
	si le masque optionnel est donn, la liste sera limite aux
	AKILLs qui correspondent au masque donn. AKILL VIEW en dit
	plus long que la version AKILL LIST, de prsentera qui a
	ajout le AKILL, la date de l'ajout, le moment de
	l'expiration, ainsi que le masque usager@hte et la raison.
	Si l'option NOEXPIRE est spcifie, seuls les AKILLs qui
	n'expireront pas, et qui correspondent au masque usager@hte
	donn, seront affichs.  AKILL COUNT retourne seulement le
	nombre de AKILLs prsents dans la liste d'AKILL.
	
	Optionnellement, un moment d'expiration peut tre donn avec
	la commande AKILL ADD.  Le moment d'expiration prcde le
	masque usager@hte, et est spcifi comme un entier suivi
	par un d (jours), h (heures), ou m (minutes).  Les
	combinaisons (telles que 1h30m) sont galement autorises.
	Si une l'unit n'est pas spcifie, par dfaut il s'agira de
	jours (donc +30 en soit signifie 30 jours).  Pour ajouter un
	AKILL qui n'expirera pas, utilisez +0.  Si le masque
	d'usager  tre ajout commence par un +, un moment
	d'expiration de tre donn, mme s'il s'agit du mme que
	celui par dfaut.
	
	La raison peut dcrire pourquoi l'entre a t ajoute;
	dpendamment de comment les Services sont configurs, a
	peut aussi tre affich  l'usager dans le message de KILL.

OPER_HELP_AKILL_OPERMAXEXPIRY
	
	Les Oprateurs des Services peuvent seulement dterminer un
	moment d'expiration jusqu' %s; les Administrateurs
	des Services peuvent dterminer tous les moments
	d'expiration.
OPER_HELP_AKILL_END
	
	Limit aux Oprateurs des Services.

OPER_HELP_EXCLUDE
	Syntaxe: EXCLUDE ADD [+expiration] masque raison
	         EXCLUDE DEL masque
	         EXCLUDE LIST [masque] [NOEXPIRE]
	         EXCLUDE VIEW [masque] [NOEXPIRE]
	         EXCLUDE COUNT
	
	Permet aux Oprateurs des Services de manipuler la liste
	d'exclusion d'autokill.  Lorsqu'un usager donc le masque
	correspond  une entre de liste d'exclusion d'autokill se
	connecte au rseau, les Services n'mettront pas de KILL
	mme si l'usager correspond  un masque inscrit  la liste
	d'autokill.  Ceci est utile si vous avez un masque
	d'autokill vaste, et que vous dsirez continuez  vouloir
	permettre l'accs  un hte ou un usager lequel correspond
	au masque inscrit  la liste d'autokill.
	
	Les sous-commandes ADD, DEL, LIST, VIEW et COUNT
	fonctionnent de la mme manire que les sous-commandes de la
	commande AKILL; voir l'assistance (HELP) pour la commande
	AKILL afin d'avoir plus d'information.
	
	Limit aux Oprateurs des Services.

OPER_HELP_SGLINE
	Syntaxe: SGLINE ADD [+expiration] masque raison
	         SGLINE DEL masque
	         SGLINE LIST [masque] [NOEXPIRE]
	         SGLINE VIEW [masque] [NOEXPIRE]
	         SGLINE COUNT
	
	Permet aux Oprateurs des Services de manipuler la liste
	SGLINE.  Si un usager dont le "vrai nom" correspond  un
	masque SGLINE tente de se connecter, les Services mettront
	un KILL pour cet usager et, sur les types de serveurs le
	supportant, donneront l'instruction  tous les autres
	serveurs d'ajouter un ban (G-line du serveur) pour le masque
	auquel correspond l'usager.
	
	SGLINE ADD ajoute le masque de nom vritable donn  la
	liste SGLINE pour la raison donne (laquelle doit tre
	donne).  SGLINE DEL retire le masque de nom vritable donn
	de la liste SGLINE s'il y est inscrit.
	SGLINE LITS prsente toutes les entres de la liste SGLINE;
	si le masque optionnel est donn, la prsentation se limite
	aux entres correspondantes audit masque.
	SGLINE VIEW est une version plus complte de SGLINE LIST, et
	prsente qui a ajout chacunes des entres SGLINE, la date
	de l'ajout, la dernire utilisation, quand est prvue
	l'expiration, ainsi que le masque et la raison.  Si l'option
	NOEXPIRE est donne, seules les entres qui n'expireront pas
	et qui correspondent au masque donn seront prsentes.
	SGLINE COUNT retourne simplement le nombre d'entres
	inscrites  la liste SGLINE.
	
	Le paramtre masque peut tre compris dans un
	double-extrait, et doit l'tre lorsque le masque contient
	des espaces; par exemple:
	    /msg %S SGLINE ADD +0 "mauvais nom" C'est un mauvais nom
	
	Optionnellement, un moment d'expiration peut tre donn avec
	la commande SGLINE ADD.  Le moment d'expiration prcde le
	masque usager@hte, et est spcifi par un entier suivi d'un
	d (jours), h (heures), ou m (minutes).  Les combinaisons
	(telles que 1h30m) sont galement autorises.  Si aucune
	unit n'est spcifie, celle par dfaut est en jours (donc
	+30 en soit signifie 30 jours).  Pour ajouter une entre qui
	n'expirera pas, utilisez +0.  Si le masque  tre ajout
	commence par un + et qu'aucun moment d'expiration n'est
	donn, le masque doit tre inclus dans un double-extrait,
	tel que dcris ci-bas.
	
	La raison peut dcrire pourquoi l'entre a t ajoute;
	dpendamment de comment les Services sont configurs, cela
	peut galement tre affich aux usagers dans le message de
	KILL.
	
	Limit aux Oprateurs des Services.

OPER_HELP_SQLINE
	Syntaxe: SQLINE ADD [+expiration] masque raison
	         SQLINE DEL masque
	         SQLINE LIST [masque] [NOEXPIRE]
	         SQLINE VIEW [masque] [NOEXPIRE]
	         SQLINE COUNT
	
#OPER_HELP_SQLINE_KILL
#	Permet aux Oprateurs des Services de manipuler la liste
#	SQLINE.  Si un usager dont le surnom correspond  un masque
#	SQLINE tente de se connecter, les Services mettront un KILL
#	pour cet usager, et sur les types de serveurs le supportant,
#	donneront l'instruction  tous les serveurs d'ajouter un ban
#	(Q-line du serveur) pour le masque auquel l'usager correspond.
OPER_HELP_SQLINE_END
	
	Les sous-commandes ADD, DEL, LIST, VIEW, et COUNT peuvent
	tre utilises pour ajouter, suprimer, visualiser (version
	courte ou longue), ou compter le nombre d'entres dans la
	liste SQLINE.  Voir l'assistance (HELP) pour SQLINE (/msg
	%S HELP SGLINE) pour plus de dtails.
	
	Limit aux Oprateurs des Services.

OPER_HELP_SZLINE
	Syntaxe: SZLINE ADD [+expiration] masque raison
	         SZLINE DEL masque
	         SZLINE LIST [masque] [NOEXPIRE]
	         SZLINE VIEW [masque] [NOEXPIRE]
	         SZLINE COUNT
	
	Permet aux Oprateurs des Services de manipuler la liste
	SZLINE.  Si un usager dont l'adresse IP correspond  un
	masque SZLINE tente de se connecter, les Services mettront
	un KILL pour cet usager et, sur les types de serveurs le
	supportant, donneront l'instruction  tous les serveurs
	d'ajouter un ban (Z-line du serveur) pour le masque auquel
	l'usager correspond.
	
	Les sous-commandes ADD, DEL, LIST, VIEW, et COUNT peuvent
	tre utilises pour ajouter, suprimer, visualiser (version
	courte ou longue), ou compter le nombre d'entres dans la
	liste SQLINE.  Voir l'assistance (HELP) pour SQLINE (/msg
	%S HELP SGLINE) pour plus de dtails.
	
	Limit aux Oprateurs des Services.

#OPER_HELP_EXCEPTION
#	Syntaxe: EXCEPTION ADD [+expiration] masque limite raison
#	         EXCEPTION DEL {masque | liste}
#	         EXCEPTION MOVE num nouveau-num
#	         EXCEPTION LIST [masque | liste]
#	         EXCEPTION VIEW [masque | liste]
#	
#	Permet aux Administrateurs des Services de manipuler la
#	liste des htes qui ont une limitation de session
#	spcifique, permettant certains appareils, tels que les
#	serveurs coquilles (shell), de transporter plus de clients
#	que le nombre par dfaut  la fois.  Une fois qu'un hte 
#	atteint sa limitation de sessions, tous les clients qui
#	tenteront de se connecter  partir de cet hte seront
#	dbranchs.  Avant que l'usager soit dbranch, il sera
#	notifi, via /NOTICE de %S, d'une source d'aide
#	concernant la limitation de session.  Le contenu de cette
#	notice est un ajustement de configuration.
#	
#	EXCEPTION ADD ajoute le masque d'hte donn  la liste
#	d'exception.  Remarquez que les masques surnom!usager@hte
#	et usager@hte sont invalides!  Seuls les vritables masques
#	d'hte, tels que bote.hte.dom et *.hte.dom, sont
#	autoriss parce que la limitation de session ne tient pas
#	compte des surnoms ou noms d'usager dans ses compter.
#	limite doit tre un nombre supprieur ou gal  zro; ceci
#	dtermine combien de session cet hte peut transporter  la
#	fois (une valeur de zro signifie que l'hte n'a aucune
#	limitation de session).
#	
#	Optionnellement, un moment d'expiration peut tre donn avec
#	la commande EXCEPTION ADD.  Le moment d'expiration prcde
#	le masque d'hte, et est spcifi comme un entier suivi par
#	un d (jours), h (heures), ou m (minutes).  Les combinaisons
#	(telles que 1h30m) sont galement autorises.  Si aucune
#	unit n'est spcifie, celle par dfaut est en jours (donc
#	+30 en soit signifie 30 jours).  Pour ajouter une entre qui
#	n'expirera pas, utilisez +0.  Si le masque  tre ajout
#	commence par un +, un moment d'expiration doit tre donn,
#	mme s'il s'agit de la mme valeur que celle par dfaut.
#	
#	EXCEPTION DEL retire le masque donn de la liste
#	d'exception.
#	
#	EXCEPTION MOVE dplace l'exception num  nouveau-num.  Si
#	nouveau-num est dj utilis par une autre exception, son
#	numro sera augment afin de crer de l'espace.
#	
#	EXCEPTION LIST et EXCEPTION VIEW prsente toutes les
#	exceptions actuelles; si le masque optionnel est donn,
#	cette liste est limite aux exceptions correspondant audit
#	masque.  La diffrence entre les deux commandes est que
#	EXCEPTION VIEW en dit plus long, prsentant le nom de la
#	personne qui a ajoute l'exception, sa limitation de
#	session, la raison, le masque d'hte et le jout et moment
#	d'expiration, de mme que le moment de la dernire
#	utilisation de l'exception, i.c. la dernire fois qu'un
#	usager correspondant au masque d'exception s'est connect.
#	
#	Remarquez qu'un client se connectant "utilisera" la premire
#	exception correspondant  son hte.  Les exceptions trop
#	larges ou correspondant  trop de masques dgradent quelque
#	peu les performances des Services.
#	
#	Limit aux Oprateurs des Services.

#OPER_HELP_SESSION
#	Syntaxe: SESSION LIST seuil (threshold)
#	         SESSION VIEW hte
#	
#	Permet aux Administrateurs des Services de voir la liste des
#	sessions.
#	
#	SESSION LIST prsente les htes qui ont au minimum le seuil
#	des sessions.  Le seuil doit tre un nombre plus grand que
#	1, pour prvenir l'affichage accidentel d'un nombre trop
#	large de htes de session simples.
#	
#	SESSION VIEW prsente l'information dtaille relative  un
#	hte spcifique, incluant le nombre actuel de
#	comptes-session et la limitation de sessions.  La valeur
#	hte ne doit pas inclure de frimes.
#	
#	Voir l'assistance (HELP) d'EXCEPTION pour plus d'information
#	 propos de la limitation de session et comment dterminer
#	une limitation de session spcifique pour certains htes et
#	groupes d'htes.
#	
#	Limit  l'usage des Administrateurs des Services.

OPER_HELP_SU
	Syntaxe: SU mot-de-passe
	
	Permet d'accder aux fonctions qui requierrent les
	privilges de Super-Usager des Services.  Le mot-de-passe
	est le mme que celui dtermin avec la commande SET SUPASS;
	remarquez que le mot-de-passe doit tre dtermin avant
	d'utiliser cette commande.  Les privilges de Super-usager
	durent tant que vous ne quittez pas l'IRC.
	
	ATTENTION: Si vous entrez un mot-de-passe incorrect, les
	Services mettront un message d'avertissement  tous les
	Oprateurs d'IRC.
	
	Limit  l'usage des Administrateurs des Services.

OPER_HELP_SET
	Syntaxe: SET option ajustement
	
	Dtermine une varit d'option globales des Services.  Les
	noms d'options actuellement dfinis sont:
	    READONLY   Dterminer les modes lecture-seulement ou
	                     lecture-crituer
	    DEBUG      Activer ou dsactiver le mode debug
	    SUPASS     Dterminer un mot-de-passe pour la commande
	                     SU (super-usager)
	
	Limit aux Administrateurs des Services; l'option SUPASS
	peut seulement tre dtermin par le Super-Usager des
	Services.

OPER_HELP_SET_READONLY
	Syntaxe : SET READONLY (ON |OFF)
	
	Mets le mode lecture-seulement  ON ou  OFF.  En mode
	lecture-seulement, les usagers normaux ne seront pas
	autoriss  modifier aucune donne des Services, incluant
	les listes d'accs des canaux et surnoms, etc.  Les
	Oprateurs d'IRC disposant des privilges suffisants auprs
	des Services seront capables de modifier la liste d'AKILL,
	de dsenregistrer ou interdire de surnoms ou canaux, mais
	aucun de ces changements ne seront sauvegards tant que le
	mode lecture-seulement ne sera pas dsactiv et que les
	Services ne termineront pas leur session ou ne seront pas
	redmarrs.
	
	Cette option est quivalente  l'option de ligne de commande
	-readonly.
	
	Limit aux Administrateurs des Services.

OPER_HELP_SET_DEBUG
	Syntaxe : SET DEBUG (ON | OFF | num)
	
	Mets le mode dbogue  ON ou  OFF.  En mode dbogue, toutes
	les donnes expdies par ou  destination des Services
	ainsi qu'un certain nombre d'autres messages de dboguage
	sont inscris aux fichiers d'action.  Si un num est donn, le
	mode dbogue est activ, avec le niveau de dboguage
	dtermin par le num.
	
	Cette option est quivalente  l'option de ligne de commande
	-debug.

OPER_HELP_SET_SUPASS
	Syntaxe : SET SUPASS [mot-de-passe]
	
	Dtermine le mot-de-passe  tre utilis pour la commande
	SU.  Ce mot-de-passe doit tre dtermin avant d'utiliser la
	commande SU pour la premire fois.  Si aucun mot-de-passe
	n'est donn, la commande SU ne sera pas disponible.
	
	Cette option ne peut tre dtermine que pas le
	Super-usager des Services.

OPER_HELP_JUPE
	Syntaxe : JUPE serveur [raison]
	
	Demande aux Services de simuler un serveur--c'est  dire,
	de crer un faux "serveur" connect aux Services afin de
	prvenir que le serveur rel du mme nom ne se connecte.  Ce
	"faux serveur" peut tre retir en utilisant la commande
	/SQUIT ordinaire.  Si une raison est donne, elle sera
	inscrite dans le champ d'information du serveur; autrement,
	le champ d'information du serveur contiendra le texte
	"Jupitered by <surnom>", indiquant ainsi le surnom de la
	personne qui a simul le serveur.
	
	Limit aux Administrateurs des Services.

OPER_HELP_RAW
	Syntaxe: RAW texte
	
	Donne une ligne de texte directement au serveur avec lequel
	les Services sont connects.  Cette commande a un champ
	d'action vraiment limit, et peut faire des ravages sur un
	rseau ou provoquer l'arrt des services si elle est mal
	utilise.  N'UTILISEZ PAS CETTE COMMANDE si vous n'tes pas
	absolument certain de savoir comment le faire!
	
	Limit  l'usage des Super-usagers des Services.

#OPER_HELP_UPDATE
#	Syntaxe : UPDATE
#	
#	Force les Services  mettre  jour toutes les banques de
#	donnes ds que vou entrez la commande.
#	
#	Limit aux Administrateurs des Services.

OPER_HELP_QUIT
	Syntaxe : QUIT
	
	Force l'arrt immdiat des Services; les banques de donnes
	ne sont pas sauvegardes.  Cette commande ne peut pas tre
	utilise sans endommager la copie en mmoire interne des
	banques de donnes qui est perdue et ne peut pas tre
	sauvegarde.  Pour une mise  l'arrt normale, utilisez la
	commande SHUTDOWN.
	
	Limit aux Administrateurs des Services.

OPER_HELP_SHUTDOWN
	Syntaxe : SHUTDOWN
	
	Force la sauvegarde de toutes les banques de donnes suivi
	de l'arrt des Services.
	
	Limit aux Administrateurs des Services.

OPER_HELP_RESTART
	Syntaxe : RESTART
	
	Force la sauvegarde de toutes les banques de donnes suivi
	du redmarrage des Services.  (C'est  dire sortie et
	redmarrage immdiat des fichiers excutables).
	
	Limit aux Administrateurs des Services.

OPER_HELP_REHASH
	Syntaxe : REHASH
	
	Force les Services  re-lire ses fichiers de configuration
	et de mettre  jour ses ajustements actifs.  Certains
	ajustements, tels que RemoteServer (lequel dtermine le nom
	d'hte du serveur IRC auquel il est connect), ne peuvent
	pas tre changs avec REHASH, et ne prendront effet que
	lorsque les Services seront redmarrs; auquel cas, un
	message sera inscrit au fichier d'action, et une notice sera
	expdie, vous en avisant.
	
	Si des lignes LoadModule ont t ajoutes ou suprimes du
	fichier principal de configuration des Services les modules
	(%s), ne seront pas chargs ou dchargs tel que
	dsir.  Les modules n'ayant plus de ligne LoadModule seront
	dchargs dans l'ordre inverse de leur chargement; ensuite,
	aprs que les modules restant aient t remanis, les
	nouveaux modules seront chargs dans l'ordre qu'ils
	apparaissent dans le fichier de configuration.  Si une
	erreur survient  n'importe quelle tape, le remaniement
	avortera.
	
	Remarquez qu'en raison de la dpendance des modules, certain
	modules ne peuvent pas tre retirs ou chargs avec la
	commande REHASH; dans ces cas, vous aurez besoin de
	redmarrer les Services pour que les modifications prennent
	effet.
	
	Limit aux Administrateurs des Services.

OPER_HELP_KILLCLONES
	Syntaxe: KILLCLONES surnom
	
	Dconnecte tous les usagers qui ont le mme nom d'hte comme
	surnom.  Un AKILL temporaire, de forme *@hte, est ajout
	afin d'empcher le client fautif de se reconnecter
	immdiatement.  Un message WALLOPS est galement expdi
	indiquant qui a utilis la commande, quel hte a t
	affect, et combien d'usagers ont t dconnects.  C,est
	utile pour retirer les clnes nombreux du rseau.
	
	Limit aux Oprateurs des Services.


###########################################################################
#
# StatServ help messages
#
###########################################################################

STAT_HELP
	%S donnes des informations statistiques relatives au
	rseau IRC, ses serveurs et ses usagers.  Tapez /msg
	%S HELP COMMANDS pour la liste des commandes de
	%S; pour de l'information sur une commande, tapez /msg
	%S HELP commande.

STAT_HELP_COMMANDS
	Les commandes suivantes peuvent tre utilises avec
	%S:
	
	    SERVERS     Statistiques relatives aux serveurs
	    USERS       Statistics relatives aux usagers

STAT_HELP_SERVERS
	Syntaxe: SERVERS STATS
	         SERVERS LIST [masque]
	         SERVERS VIEW [masque] [ONLINE | OFFLINE]
	
	Prsente les statistiques relatives aux serveurs du rseau.
	
	SERVERS STATS prsente un bref sommaire des serveurs
	actuellement visibles (en-ligne) et invisibles (hors-ligne)
	pour les Services.
	SERVERS LIST prsente une liste des serveurs en-ligne et
	les statistiques actuelles relatives  chacun.
	SERVERS VIEW prsente une liste des serveurs en-ligne et
	hors-ligne avec des statistiques dtailles relatives  chacuns.
	Les options ONLINE et OFFLINE font en sorte,
	respectivement, que seulement les serveurs en-ligne ou
	hors-ligne soient prsents.
	
	Utilisez l'option masque pour limiter les statistiques de
	quel serveur seront prsentes.

STAT_HELP_USERS
	Syntaxe: USERS STATS
	
	Prsente les statistiques relatives aux usagers du rseau.

STAT_OPER_HELP_SERVERS
	Syntaxe: SERVERS STATS
	         SERVERS LIST [masque]
	         SERVERS VIEW [masque] [ONLINE | OFFLINE]
	         SERVERS DELETE serveur
	         SERVERS COPY serveur nouveau-nom
	         SERVERS RENAME serveur nouveau-nom
	
	Prsente les statistiques relatives aux serveurs du rseau.
	
	SERVERS STATS prsente un bref sommaire des serveurs
	actuellement visibles (en-ligne) et invisibles (hors-ligne)
	aux Services.
	SERVERS LIST prsente une liste des serveurs en-ligne et
	les statistiques actuelles relatives  chacun.
	SERVERS VIEW prsente une liste des serveurs en-ligne et
	hors-ligne avec des statistiques dtailles relatives 
	chacun. Les options ONLINE et OFFLINE donnent,
	respectivement, seulement les serveurs en-ligne et
	hors-ligne.
	
	Utilisez l'option masque pour limiter quelles statistiques
	de serveur seront prsentes.
	
	DELETE efface la statistique de serveur spcifie.
	COPY copie un ensemble de statistiques de serveur.
	RENAME renomme un ensemble de statistiques de serveur.
	Ces trois commandes sont limites aux Administrateurs des
	Services.
