/* sjoin.c header file.
 *
 * IRC Services is copyright (c) 1996-2007 Andrew Church.
 *     E-mail: <achurch@achurch.org>
 * Parts written by Andrew Kempe and others.
 * This program is free but copyrighted software; see the file COPYING for
 * details.
 */

#ifndef SJOIN_H
#define SJOIN_H

#if defined(UNREAL_HACK)  /* see comments in sjoin.c */
# define do_sjoin do_sjoin_unreal
# define init_sjoin init_sjoin_unreal
# define exit_sjoin exit_sjoin_unreal
#elif defined(BAHAMUT_HACK)
# define do_sjoin do_sjoin_bahamut
# define init_sjoin init_sjoin_bahamut
# define exit_sjoin exit_sjoin_bahamut
#endif

#define SJOIN_CONFIG \
    { "CSSetChannelTime", { { CD_SET, 0, &CSSetChannelTime } } }

extern int CSSetChannelTime;

extern void do_sjoin(const char *source, int ac, char **av);
extern int init_sjoin(Module *module_);
extern void exit_sjoin(void);

#endif
