/* Various routines to perform simple actions.
 *
 * Services is copyright (c) 1996-1998 Andy Church.
 *     E-mail: <achurch@dragonfire.net>
 * This program is free but copyrighted software; see the file COPYING for
 * details.
 */

#include "services.h"

/*************************************************************************/

/* Remove a user from the IRC network.  `source' is the nick which should
 * generate the kill, or NULL for a server-generated kill.
 */

void kill_user(const char *source, const char *user, const char *reason)
{
    char *av[2];

    if (!user || !*user)
	return;
    if (!source || !*source)
	source = server_name;
    if (!reason)
	reason = "";
    av[0] = sstrdup(user);
    av[1] = smalloc(strlen(source)+strlen(reason)+4);
    sprintf(av[1], "%s (%s)", source, reason);
    send_cmd(source, "KILL %s :%s", user, av[1]);
    do_kill(source, 2, av);
    free(av[0]);
    free(av[1]);
}

/*************************************************************************/

/* Note a bad password attempt for the given user.  If they've used up
 * their limit, toss them off.
 */

void bad_password(User *u)
{
#if BAD_PW_LIMIT == 0
    return;
#else
    time_t now = time(NULL);

# if BAD_PW_TIMEOUT > 0
    if (u->invalid_pw_time > 0 && u->invalid_pw_time < now-BAD_PW_TIMEOUT)
	u->invalid_pw_count = 0;
# endif
    u->invalid_pw_count++;
    u->invalid_pw_time = now;
    if (u->invalid_pw_count >= BAD_PW_LIMIT)
	kill_user(NULL, u->nick, "Too many invalid passwords");
#endif /* BAD_PW_LIMIT */
}

/*************************************************************************/
