/* Services configuration.
 *
 * Services is copyright (c) 1996-1998 Andy Church.
 *     E-mail: <achurch@dragonfire.net>
 * This program is free but copyrighted software; see the file COPYING for
 * details.
 */

#ifndef CONFIG_H
#define CONFIG_H


/* Should we try and deal with old (v2.x) databases?  Define this if you're
 * upgrading from v2.2.26 or earlier. */
/* #define COMPATIBILITY_V2 */


/******* General configuration *******/

/* The remote server and port to use, and the password for the link. */
#define REMOTE_SERVER	"localhost"
#define REMOTE_PORT	6667
#define PASSWORD	""	/* Not runtime-configurable */

/* For multihomed hosts or wherever else needed, the local address to bind
 * to.  If you don't know what this is or you don't need it, leave the
 * defaults as they are. */
#define LOCAL_HOST	""
#define LOCAL_PORT	0

/* Information about us as a server. */
#define SERVER_NAME	"services.localhost.net"
#define SERVER_DESC	"Services for IRC Networks"
#define SERVICES_USER	"services"
#define SERVICES_HOST	"localhost.net"

/******* End of runtime-configurable options. *******/

/* Filename options: */

/* Log filename in services directory */
#define LOG_FILENAME	"services.log"

/* File for Message of the Day (/motd command) */
#define MOTD_FILENAME	"services.motd"

/* Database filenames */
#define NICKSERV_DB	"nick.db"
#define CHANSERV_DB	"chan.db"
#define OPERSERV_DB	"oper.db"
#define AKILL_DB	"akill.db"

/* If you don't mind Services not being able to make a backup of database
 * while writing them, define this; this can allow Services to continue
 * operation under some conditions when it might otherwise fail.  (Note
 * that this can cause data loss under some error conditions, so make SURE
 * you know what you're doing if you define it!) */
/* #define NO_BACKUP_OKAY */

/* File containing process ID */
#define PID_FILE	"services.pid"

/* Subdirectory for help files */
#define HELPSERV_DIR	"helpfiles"


/* Timeouts: */

/* Delay (in seconds) between database updates */
#define UPDATE_TIMEOUT	300	/* 5 minutes */

/* Delay (in seconds) between checks for expired nicks and channels */
#define EXPIRE_TIMEOUT	1800	/* 30 minutes */

/* Minimum time (in seconds) between running the timeout list.  This
 * determines the granularity of timeouts.  This shouldn't be set any
 * higher than 10, and 1 is best if your system can handle it.  0 will
 * probably make Services take up too much CPU time in any case. */
#define TIMEOUT_CHECK	3
 
/* Delay (in seconds) before we time out on a read and do other stuff,
 * like checking timeouts.  The busier your server is, the lower this
 * should be set (though the busier your server is, the less likely that
 * this will make any difference). */
#define READ_TIMEOUT	10


/* Miscellaneous options: */

/* Maximum amount of data from/to the network to buffer (bytes). */
#define NET_BUFSIZE	65536

/* Number of invalid password tries before Services boots a user.  If a
 * user enters this many invalid passwords for any Services function or
 * combination of functions during a single IRC session, Services will kill
 * the user (but see BAD_PW_TIMEOUT below).  Set this to 0 to disable this
 * feature.
 */
#define BAD_PW_LIMIT	5

/* Time (in seconds) after which invalid password attempts are forgotten
 * about; i.e., if a user does not enter an incorrect password in this
 * amount of time, the incorrect password count will reset to 0.  If this
 * value is set to 0, the timeout is disabled, and BAD_PW_LIMIT number of
 * invalid passwords at any time during a single session will result in a
 * kill.
 */
#define BAD_PW_TIMEOUT	3600	/* 1 hour */

/* Perform more stringent checks on passwords.  If this is undefined,
 * Services will only disallow a password if it is the same as the entity
 * (nickname or channel name) to which it is connected.  Otherwise,
 * Services will also check that the nickname is at least five characters
 * long, and in the future will probably check other things as well.
 */
#define STRICT_PASSWORDS

/* Allow only IRC operators to use the ChanServ/NickServ LIST command. */
/* #define LIST_OPERS_ONLY */


/******* Services pseudo-client names *******/

#define NICKSERV_NAME		"NickServ"
#define CHANSERV_NAME		"ChanServ"
#define MEMOSERV_NAME		"MemoServ"
#define HELPSERV_NAME		"HelpServ"
#define OPERSERV_NAME		"OperServ"
#define IRCIIHELP_NAME		"IrcIIHelp"
#define GLOBAL_NOTICER_NAME	"Global"

/* Message sink--leave this undefined to not create it.  It doesn't really
 * serve a useful purpose, but can be an interesting toy at times. */
#define DEVNULL_NAME		"DevNull"

/* Real-name strings (for /whois): */
#define NICKSERV_REALNAME	"Nickname Server"
#define CHANSERV_REALNAME	"Channel Server"
#define MEMOSERV_REALNAME	"Memo Server"
#define HELPSERV_REALNAME	"Help Server"
#define OPERSERV_REALNAME	"Operator Server"
#define IRCIIHELP_REALNAME	"ircII Help Server"
#define GLOBAL_NOTICER_REALNAME	"Global Noticer"
#define DEVNULL_REALNAME	"/dev/null -- message sink"



/******* NickServ configuration *******/

/* Default language for newly registered nicks (and nicks imported from
 * old databases); see services.h for available languages (search for
 * "LANG_").  Unless you're running a regional network, you should probably
 * leave this at LANG_EN_US. */
#define DEF_LANGUAGE	LANG_EN_US

/* Minimum number of seconds between consecutive uses of the REGISTER
 * command.  Set to 0 to disable this restriction. */
#define NS_REG_DELAY	30

/* Number of days before a nick registration expires; set to zero for no
 * expiration (not recommended). */
#define NICK_EXPIRE	30

/* Maximum number of entries on a nickname's access list. */
#define NICK_ACCESS_MAX	32

/* Delay (in seconds) before a NickServ-collided nick is released. */
#define RELEASE_TIMEOUT	60

/* Define this to allow use of the KILL IMMED option. */
/* #define ALLOW_NICK_KILL_IMMED */



/******* ChanServ configuration *******/

/* Maximum number of channels a single nick is allowed to register; set to
 * zero to disable. */
#define CHANNEL_MAXREG	20

/* Number of days before a channel expires; set to zero for no expiration
 * (not recommended). */
#define CHANNEL_EXPIRE	14

/* Maximum number of entries on a channel's access list.  Channel access
 * lists may contain only registered nicks; therefore, checking each entry
 * on the list requires only a single scalar comparison instead of a
 * wildcard match, and this limit may be safely set much higher than (for
 * example) the nickname access list size limit. */
#define CHAN_ACCESS_MAX	1024

/* Maximum number of AKICKs on a single channel. */
#define AKICK_MAX	32

/* Default reason for AKICK if none is given. */
#define DEF_AKICK_REASON "User has been banned from the channel"

/* Number of seconds to stay in a channel after kicking a user from a
 * channel s/he is not permitted to be in.  This only occurs when the user
 * is the only one in the channel. */
#define CHANNEL_INHABIT	15



/******* MemoServ configuration *******/

/* What is the maximum number of memos a single nick/channel is allowed to
 * keep?  This is the default for a new nick/channel; users can change it
 * to anything lower or equal, and Services admins can change the limit to
 * any value.  Setting this to zero disables the limit (again, by default).
 */
#define DEF_MAX_MEMOS	20

/* How long (in seconds) should a user be forced to wait between
 * consecutive uses of the MemoServ SEND command?  This can help prevent
 * spam as well as denial-of-service attacks from sending large numbers of
 * memos and filling up disk space (and memory).  A 3-second wait means a
 * maximum average of 150 bytes of memo per second per use under the
 * current IRC protocol.  Setting the value to 0 will disable this feature.
 */
#define MEMO_SEND_WAIT	3



/******* OperServ configuration *******/

/* Who is the Services "super-user"?  (The super-user, or "root" as in
 * Unix terminology, is the only user who can add or delete Services
 * admins.) */
#define SERVICES_ROOT	""

/* What is the maximum number of Services admins we will allow? */
#define MAX_SERVADMINS	32

/* What is the maximum number of Services operators we will allow? */
#define MAX_SERVOPERS	64

/* Default expiry time on an autokill, in seconds */
#define AKILL_DEF_EXPIRY (30*24*60*60)

/* Send a wallops if a non-oper tries to use OperServ? */
/* #define WALL_BAD_OPERSERV */

/* Send a wallops on use of MODE/CLEARMODES/KICK? */
/* #define WALL_OS_MODE */
/* #define WALL_OS_CLEARMODES */
/* #define WALL_OS_KICK */

/* Enable code to check for clones? */
#define CHECK_CLONES

/* How big a hostname list do we keep for clone detection?  On large nets
 * (over 500 simultaneous users or so), you may want to increase this if
 * you want a good chance of catching clones. */
#define CLONE_DETECT_SIZE 16

/* How many successive connects do we have to see before we consider the
 * possibility of clones? */
#define CLONE_MIN_USERS	5

/* How much time (in seconds) has to elapse between successive users
 * before we decide they're not clones? */
#define CLONE_MAX_DELAY	10

/* How long do we wait (in seconds) between successive warnings for
 * clones between the same host? */
#define CLONE_WARNING_DELAY 30

/* Define this to enable OperServ's debugging commands (Services root
 * only).  These commands are undocumented; "use the source, Luke!" */
/* #define DEBUG_COMMANDS */



/******* Miscellaneous - it should be save to leave these untouched *******/

/* Size of input buffer (note: this is different from BUFSIZ)
 * This must be big enough to hold at least one full IRC message, or messy
 * things will happen. */
#define BUFSIZE		1024


/* Extra warning:  If you change these, your data files will be unusable! */

/* Maximum length of a channel name */
#define CHANMAX		64

/* Maximum length of a nickname */
#define NICKMAX		32

/* Maximum length of a password */
#define PASSMAX		32

/**************************************************************************/
/**************************************************************************/

/* System-specific defines */

#if !HAVE_STRICMP && HAVE_STRCASECMP
# define stricmp strcasecmp
# define strnicmp strncasecmp
#endif

/**************************************************************************/

#endif	/* CONFIG_H */
