
/*
 * Copyright (C) 1997-1998 Kai 'Oswald' Seidler <oswald@cs.tu-berlin.de>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "noteserv.h"

char *Key_getNickname(char *key)
{
    static char nickname[NICKLEN + 1];
    char *ptr;

    ptr = nickname;

    while (*key != '!')
	*ptr++ = *key++;
    *ptr = '\0';

    return nickname;
}

char *Key_getNickname2(char *key)
{
    static char nickname[NICKLEN + 1];
    char *ptr;

    ptr = nickname;

    while (*key != '!')
	*ptr++ = *key++;
    *ptr = '\0';

    return nickname;
}

int Key_casecompareNicknameinKeys(char *key, char *nickname)
{
    char *ptra = key, *ptrb = nickname;

    while (tolower(*ptra) == tolower(*ptrb) && *ptra != '!' && *ptrb != '!')
    {
	ptra++;
	ptrb++;
    }

    if (*ptra == '!' && *ptrb == '!')
	return 1;

    return 0;
}

int Key_compareNickname(char *key, char *nickname)
{
    char *ptra = key, *ptrb = nickname;

    while (*ptra == *ptrb)
    {
	ptra++;
	ptrb++;
    }

    if (*ptra == '!' && *ptrb == '\0')
	return 1;

    return 0;
}

char *Key_getUH(char *key)
{
    return strchr(key, '!') + 1;
}

char *Key_buildfromNUH(char *nick, char *user, char *host)
{
    static char key[KEYLEN + 1];

    sprintf(key, "%s!%s@%s", nick, user, host);

    return key;
}
