/*
 * Copyright (C) 1997 Kai 'Oswald' Seidler <oswald@cs.tu-berlin.de>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef SYSTIME
#include <sys/time.h>
#endif

#define MSGFILE "messages.db"
#define USERFILE "users.db"

#define WRITETIMEOUT (20*60)	/* sync every 20 minutes */

#define HOSTLEN         63
#define NICKLEN          9
#define USERLEN         10
#define PASSWDLEN       20

#define KEYLEN	 	NICKLEN + USERLEN + HOSTLEN + 3
#define EXPRLEN		KEYLEN
#define MSGLEN		512

#define SECSADAY	(60*60*24)
#define SECSANHOUR	(60*60)

#define SERVERNAMELEN	50

#define MAX_SPYS	90	/* maximum spys to query */
#define MAX_MSGS	10	/* maximum messages to send */
#define MAX_DELIVERMSGS	5	/* maximum messages to deliver at once */
#define MAX_MATCH	10	/* maximum matches a spy would accept */
#define MAX_FIND 	20	/* maximum finds */

#define SIGNON_DELAY	19	/* seconds */

#define SEND_MAXEXPIRE  8640000	/* 100 days */
#define EXPIRE_USER	31536000	/* 365 days */

struct Expression
{
    char pattern[EXPRLEN + 1];
    char comment[EXPRLEN + 1];
    time_t timeout;
    struct Expression *next;
};

struct Message
{
    char pattern[EXPRLEN + 1];
    char message[MSGLEN + 1];
    time_t timeout;
    time_t timestamp;
    struct Message *next;
};

struct Clients
{
    char key[KEYLEN + 1];
    char username[USERLEN + 1];
    char password[PASSWDLEN + 1];
    char server[SERVERNAMELEN + 1];
    int status;
    time_t timestamp;
    struct Expression *expressions;
    int expr_count;
    struct Message *messages;
    int msg_count;
    struct Clients *next;
};

struct Last
{
    char key[KEYLEN + 1];
    time_t last;
};

#include <stdarg.h>
#include "proto.h"

#define	STATUS_NEEDTOSAVE 	16
#define	STATUS_DONTSAVE		32
#define STATUS_MODE_O 		64
#define STATUS_MODE_I	       128
#define STATUS_OFFLINE 	       256
#define STATUS_KLINED	       512

#define Status_IsOper(x)	(x & STATUS_MODE_O)
#define Status_IsInvisible(x)	(x & STATUS_MODE_I)
#define Status_SaveNeeded(x)	(x & STATUS_NEEDTOSAVE)
#define Status_IsOffline(x)	(x & STATUS_OFFLINE)
#define Status_IsKlined(x)	(x & STATUS_KLINED)

#define FIND_OFFLINE 		 1
#define FIND_CONTINUE 		 2
#define FIND_USEMATCH 		 4
#define FIND_NICKNAME   	 8
#define FIND_RESPECTINVISIBLE 	16
#define FIND_EVERYTHING 	32
#define FIND_USERNAME 		64
#define FIND_KEY 	       128
#define FIND_KLINED	       256

#define Find_UseMatch(x)		(x & FIND_USEMATCH)
#define Find_Init(x)			(x & FIND_CONTINUE)
#define Find_Everything(x)		(x & FIND_EVERYTHING)
#define Find_Nickname(x)		(x & FIND_NICKNAME)
#define Find_RespectInvisible(x)	(x & FIND_RESPECTINVISIBLE)
#define Find_Username(x)		(x & FIND_USERNAME)
#define Find_Offline(x)			(x & FIND_OFFLINE)
#define Find_Key(x)			(x & FIND_KEY)
#define Find_Klined(x)			(x & FIND_KLINED)

int match(char *mask, char *name);
