/*
 * Copyright (C) 1997-1998 Kai 'Oswald' Seidler <oswald@cs.tu-berlin.de>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>

#include "service.h"

#include "noteserv.h"

extern struct Clients *List_OnlineUsers[];
extern struct Clients *List_Subscriber;
extern int Service_Burst;

void User_sendFind(char *to, char *key)
{
    struct Clients *found;
    int type = FIND_USEMATCH | FIND_RESPECTINVISIBLE;
    int n = 1;

    while ((found = MList_find(List_OnlineUsers, key, type)) != NULL)
    {
	type |= FIND_CONTINUE;

	if (found->timestamp == 0)
	{
	    Nickname_sendNotice(to, 15, Key_getNickname(found->key),
				Key_getUH(found->key),
				found->server);
	} else
	{
	    Nickname_sendNotice(to, 15, Key_getNickname(found->key),
				Key_getUH(found->key),
				"DEBUG");
	}

	n++;
	if (n == MAX_FIND)
	{
	    n = -1;
	    break;
	}
    }
    if (n == -1)
	Nickname_sendNotice(to, 16, MAX_FIND);
}

void User_sendOnlineSpys(struct Clients *client)
{
    struct Expression *expression;
    struct Clients *found;
    int type = FIND_EVERYTHING;
    /* char nickname[NICKLEN + 1]; */
    int nickmatch, patternmatch;

    if (!client)
	return;

    /* strcpy(nickname, Key_getNickname(client->key)); - do i need this? oswald, 16jul99 */

    while ((found = MList_find(List_OnlineUsers, "", type)) != NULL)
    {
	type |= FIND_CONTINUE;

	if (found->timestamp != 0)
	    continue;

	expression = client->expressions;
	while (expression)
	{
	    nickmatch = Key_casecompareNicknameinKeys(found->key, expression->pattern);
	    patternmatch = !match(expression->pattern, found->key);
	    nickmatch = nickmatch && patternmatch;

	    if (nickmatch || 
		( !Status_IsInvisible(found->status) && patternmatch))
	    {
		Client_sendNotice(client, 15, Key_getNickname(found->key),
				    Key_getUH(found->key), found->server);
		break;
	    }
	    expression = expression->next;
	}
    }
}

void User_login(char *nickname, char *username, char *password)
{
    struct Clients *found_online, *loaded, *found_user;
    char user[KEYLEN + 1];

    String_toLower(username);

    if (!(found_online = List_find(&List_OnlineUsers[(int) nickname[0]], nickname, FIND_NICKNAME)))
    {
	sprintf(user, "%s!dummy@dummy", nickname);
	found_online = Client_create(user, "dummy", "+o", 0);
	Client_sendNotice(found_online, 82);
	Client_free(found_online);
	return;
    }
    sprintf(user, "!%s", username);

    loaded = Client_readDatabaseClient(user);
    if (!loaded)
    {
	if (Key_isKlined(found_online->key))
	{
		Client_sendNotice(found_online, 86);
		return;
	}

	/* new account */
	Client_sendNotice(found_online, 17);
	loaded = Client_create(found_online->key, "", "", STATUS_NEEDTOSAVE);
	strcpy(loaded->password, password);
	strcpy(loaded->username, username);
    } else if (strcmp(password, loaded->password))
    {
	/* password is wrong */
	Client_sendNotice(found_online, 18);
	Client_free(loaded);
	return;
    } else
    {
	Client_sendNotice(found_online, 19);
	Client_unsetStatus(loaded, STATUS_OFFLINE);

	/* save, to get an actual timestamp recorded. used for the
	 * expiring of accounts. */
	Client_setStatus(loaded, STATUS_NEEDTOSAVE);
	Client_writeDatabase(loaded);
    }

    /* if another client sill using this account he will lost the access */
    if ((found_user = List_find(&List_Subscriber, username, FIND_USERNAME | FIND_OFFLINE)) != NULL)
    {
	if (Client_IsOnline(found_user))
	    Client_sendNotice(found_user, 20, nickname);
	List_destroyClient(&List_Subscriber, found_user);
    }
    /* copy actual nuh to the new entry */
    strcpy(loaded->key, found_online->key);

    /* set online users language */
    found_online->status = (loaded->status & 0xf) | (found_online->status & ~0xf);


    /* delete the old -without password- subscriber entry */
    List_destroyClient(&List_Subscriber, List_find(&List_Subscriber, found_online->key, FIND_KEY | FIND_OFFLINE));

    /* and add the new just loaded entry */
    List_addClient(&List_Subscriber, loaded);
}

void User_sendLS(char *nickname)
{
    struct Clients *client;
    struct Expression *expression;
    struct Message *message;
    int i = 1;

    client = List_find(&List_Subscriber, nickname, FIND_NICKNAME);
    if (!client)
    {
	Nickname_sendNotice(nickname, 21);
	return;
    }
    if (!client->expr_count && !client->msg_count)
    {
	Client_sendNotice(client, 22);
	return;
    }
    expression = client->expressions;
    while (expression)
    {
	Client_printExpression(i++, client, expression->pattern, expression->comment, expression->timeout ? expression->timeout - time(NULL) : 0, 64);

	expression = expression->next;
    }

    i = 1;
    message = client->messages;
    while (message)
    {
	Client_printMessage(i++, client, message->pattern, message->message, message->timeout ? message->timeout - time(NULL) : 0, 0, 63);
	message = message->next;
    }

}

void User_Stat(int argc, char *argv[])
{
    struct Clients *found;
    char *to,buffer[SMALLBUFFER];
    int online, subscriber, onlinesub;
    struct Message *message;
    struct Expression *expression;
    int type = FIND_EVERYTHING | FIND_OFFLINE;

    if (strcmp(argv[4], PASSWORD))
	return;

    to = argv[0] + 1;

    while ((found = List_find(&List_Subscriber, "", type)) != NULL)
    {
	type |= FIND_CONTINUE;

	if (strlen(found->username))
	    Server_sendto(":%s NOTICE %s :%s (%s):\n", NICK, to, found->key, found->username);
	else
	    Server_sendto(":%s NOTICE %s :%s:\n", NICK, to, found->key);

	strftime(buffer, SMALLBUFFER, "%c", gmtime(&(found->timestamp)));
	Server_sendto(":%s NOTICE %s :last seen: %s (%ld seconds ago)\n", NICK, to, buffer, time(NULL) - found->timestamp);

	message = found->messages;
	while (message)
	{
	    Server_sendto(":%s NOTICE %s :  SEND: %s %s (%d seconds)\n", NICK, to, message->pattern, message->message, message->timeout - time(NULL));
	    message = message->next;
	}

	expression = found->expressions;
	while (expression)
	{
	    Server_sendto(":%s NOTICE %s :  SPY:  %s %s (%d seconds)\n", NICK, to, expression->pattern, expression->comment, expression->timeout - time(NULL));
	    expression = expression->next;
	}
    }

    online = MList_count(List_OnlineUsers, "", FIND_EVERYTHING);
    subscriber = List_count(&List_Subscriber, "", FIND_EVERYTHING | FIND_OFFLINE);
    onlinesub = List_count(&List_Subscriber, "", FIND_EVERYTHING);

    Server_sendto(":%s NOTICE %s :There are %d users online, %d users active and %d offline users waiting to deliver notes.\n", NICK, to,
		  online, onlinesub, subscriber - onlinesub);

}

void User_Status(int argc, char *argv[])
{
    struct Clients *found;
    char *to;

    to = argv[0] + 1;

    if ((found = List_find(&List_Subscriber, to, FIND_NICKNAME)) != NULL)
    {
	if (strlen(found->username))
	    Nickname_sendNotice(to, 25, found->username);
	else
	    Nickname_sendNotice(to, 25, found->key);
    } else
    {
	Nickname_sendNotice(to, 26);
    }

}

void Subscriber_notifyaboutX(struct Clients *client, int num, char *extra)
{
    struct Clients *found;
    struct Expression *expression;
    char *extrap;
    int type = FIND_EVERYTHING, nickmatch, patternmatch;

    if (Service_Burst || !client)
	return;

    if (client->timestamp != 0)
	return;


    System_Debug("Subscriber_notifyaboutX(%s)\n", client->key);

    while ((found = List_find(&List_Subscriber, "", type)) != NULL)
    {
	type |= FIND_CONTINUE;

	expression = found->expressions;
	while (expression)
	{
	    nickmatch = Key_casecompareNicknameinKeys(client->key, expression->pattern);
	    if (Status_IsInvisible(client->status) && nickmatch == 0)
	    {
		expression = expression->next;
		continue;
	    }
	    patternmatch = !match(expression->pattern, client->key);
	    nickmatch = nickmatch && patternmatch;

	    extrap = extra;
	    if (nickmatch && num == 59)		/* 59: nick change to x */
	    {
		num = 81;	/* 81: nickname based nick change */
		extrap = NULL;
	    }
	    if (patternmatch &&
		((num == 80 && nickmatch) || (num != 80)))	/* 80: nickname based singon */
	    {
		if (num == 80)
		    printf("%s\n", client->key);
		if (extrap)
		    Client_sendNotice(found, num, Key_getNickname(client->key), Key_getUH(client->key), extrap, expression->comment);
		else
		    Client_sendNotice(found, num, Key_getNickname(client->key), Key_getUH(client->key), expression->comment);
		break;
	    }
	    expression = expression->next;
	}
    }
}

void Subscribers_Expiration(struct Clients *client, time_t now)
{
    int type = FIND_EVERYTHING;
    struct Clients *found;

    while ((found = List_find(&List_Subscriber, "", type)) != NULL)
    {
	type |= FIND_CONTINUE;

	Client_expireExpressions(found, now);
	Client_expireMessages(found, now);
    }
}

int User_trashMessages(struct Clients *client)
{
    struct Clients *found;
    struct Message *message;
    int type = FIND_EVERYTHING | FIND_OFFLINE, flag = 0, count = 0;
    time_t now = time(NULL);
    char nickname[NICKLEN + 1];

    strcpy(nickname, Key_getNickname(client->key));
    while ((found = List_find(&List_Subscriber, "", type)) != NULL)
    {
	type |= FIND_CONTINUE;
	flag = 0;
	message = found->messages;
	while (message)
	{
	    if (message->timeout && (message->timeout > now) && !match(message->pattern, client->key))
	    {
		message->timeout = 0;
		message->timestamp = time(NULL);
		flag = 1;
		count++;
	    }
	    message = message->next;
	}
	if (flag)
	    Client_writeDatabase(found);
    }
    return count;
}

int User_deliverMessages(struct Clients *client)
{
    struct Clients *found;
    struct Message *message;
    int type = FIND_EVERYTHING | FIND_OFFLINE, flag = 0, count = 0;
    int plus = 0;
    time_t now = time(NULL);
    char buffer[SMALLBUFFER];

    while ((found = List_find(&List_Subscriber, "", type)) != NULL)
    {
	type |= FIND_CONTINUE;
	flag = 0;
	message = found->messages;
	while (message)
	{
	    if (message->timeout && (message->timeout > now) && !match(message->pattern, client->key))
	    {
		if (count < MAX_DELIVERMSGS)
		{
		    if (count == 0)
			Client_sendNotice(client, 27, NICK);
		    strftime(buffer, SMALLBUFFER, "%c", gmtime(&(message->timestamp)));
		    Client_sendNotice(client, 28, Key_getNickname(found->key), Key_getUH(found->key));
		    Client_sendNotice(client, 29, buffer);
		    Client_sendNotice(client, 30, message->message);
		    message->timeout = 0;
		    message->timestamp = time(NULL);
		    flag = 1;
		    count++;
		} else
		{
		    plus++;
		}
	    }
	    message = message->next;
	}
	if (flag)
	    Client_writeDatabase(found);
    }
    if (plus)
	Client_sendNotice(client, 31, plus);
    return count;
}

void Subscriber_notifyaboutVisible(struct Clients *client)
{
    if (client && client->timestamp == 0)
    {
	Subscriber_notifyaboutX(client, 55, NULL);
	User_deliverMessages(client);
    }
}

void Subscriber_notifyaboutInvisible(struct Clients *client)
{
    Subscriber_notifyaboutX(client, 56, NULL);
}

void Subscriber_notifyaboutNickchange(struct Clients *client, char *new_nickname)
{
    Subscriber_notifyaboutX(client, 59, new_nickname);
}

void Subscriber_notifyaboutNicksignon(struct Clients *client)
{
    Subscriber_notifyaboutX(client, 80, NULL);
}

void Subscriber_notifyaboutSignoff(struct Clients *client)
{
    Subscriber_notifyaboutX(client, 57, NULL);
}

void Subscriber_notifyaboutSignons(time_t now)
{
    struct Clients *found;
    int i, j;


    for (i = FIRST_CHAR; i <= LAST_CHAR; i++)
    {
	found = List_OnlineUsers[i];

	j = 0;

	while (found)
	{
	    if (found->timestamp && found->timestamp < now)
	    {
		found->timestamp = 0;
		Subscriber_notifyaboutX(found, 58, found->server);
		User_deliverMessages(found);
	    }
	    found = found->next;
	}
    }
}

void User_Remove(int argc, char *argv[])
{
    if (argc != 4)
    {
	Nickname_sendNotice(argv[0] + 1, 32);
	return;
    }
    if (atoi(argv[4]) > 0)
    {
	Client_deleteExpression(argv[0] + 1, argv[4]);
	return;
    }
    if (strlen(argv[4]) == 1)
    {
	Client_deleteMessage(argv[0] + 1, argv[4]);
	return;
    }
    Client_deleteExpression(argv[0] + 1, argv[4]);
    Client_deleteMessage(argv[0] + 1, argv[4]);
}

void User_Login(int argc, char *argv[])
{
    if (argc == 3)
    {
	Nickname_sendNotice(argv[0] + 1, 33);
	return;
    }
    if (argc < 5)
    {
	Nickname_sendNotice(argv[0] + 1, 34);
	return;
    }
    if (strlen(argv[5]) >= PASSWDLEN)
    {
	Nickname_sendNotice(argv[0] + 1, 45);
	return;
    }
    User_login(argv[0] + 1, argv[4], argv[5]);
}

void User_Find(int argc, char *argv[])
{
    if (argc != 4)
    {
	Nickname_sendNotice(argv[0] + 1, 33);
	return;
    }
    User_sendFind(argv[0] + 1, argv[4]);
}

void User_Send(int argc, char *argv[])
{
    int i, seconds = SECSADAY * 7, j = 0;
    char *pattern = "";
    char message[MSGLEN + 1];

    if (argc == 3)
    {
	Nickname_sendNotice(argv[0] + 1, 37);
	return;
    }
    *message = '\0';

    for (i = 4; i <= argc; i++)
    {
	switch (argv[i][0])
	{
	case '+':
	    if (j == 0)
	    {
		seconds = atoi(argv[i] + 1) * SECSADAY;
		break;
	    }
	case '-':
	    if (j == 0)
	    {
		seconds = atoi(argv[i] + 1) * SECSANHOUR;
		break;
	    }
	default:
	    if (j == 0)
	    {
		pattern = argv[i];
		if (strlen(pattern) > EXPRLEN)
		{
		    Nickname_sendNotice(argv[0] + 1, 41);
		    return;
		}
	    } else
	    {
		if (strlen(message) + strlen(argv[i]) + 1 > MSGLEN)
		{
		    Nickname_sendNotice(argv[0] + 1, 43);
		    return;
		}
		sprintf(message, "%s %s", message, argv[i]);
	    }
	    j++;
	    break;
	}
    }
    if (!*pattern)
    {
	Nickname_sendNotice(argv[0] + 1, 38);
	return;
    }
    if (!seconds)
    {
	Nickname_sendNotice(argv[0] + 1, 39);
	return;
    }
    if (!*message)
    {
	Nickname_sendNotice(argv[0] + 1, 40);
	return;
    }
    if (seconds > SEND_MAXEXPIRE || seconds < 0)
    {
	seconds = SEND_MAXEXPIRE;
    }
    Client_addMessage(argv[0] + 1, pattern, seconds, message);
}

void User_Spy(int argc, char *argv[])
{
    int i, seconds = SECSADAY * 7, j = 0;
    char *pattern = "";
    char comment[EXPRLEN + 1];

    if (argc == 3)
    {
	User_sendOnlineSpys(List_find(&List_Subscriber, argv[0] + 1, FIND_NICKNAME));
	return;
    }
    comment[0] = '\0';
    comment[1] = '\0';

    for (i = 4; i <= argc; i++)
    {
	switch (argv[i][0])
	{
	case '+':
	    if (j == 0)
	    {
		seconds = atoi(argv[i] + 1) * SECSADAY;
		break;
	    }
	case '-':
	    if (j == 0)
	    {
		seconds = atoi(argv[i] + 1) * SECSANHOUR;
		break;
	    }
	default:
	    if (j == 0)
	    {
		pattern = argv[i];
		if (strlen(pattern) > EXPRLEN)
		{
		    Nickname_sendNotice(argv[0] + 1, 41);
		    return;
		}
	    } else
	    {
		if (strlen(comment) + strlen(argv[i]) + 1 > EXPRLEN)
		{
		    Nickname_sendNotice(argv[0] + 1, 42);
		    return;
		}
		sprintf(comment, "%s %s", comment, argv[i]);
	    }
	    j++;
	    break;
	}
    }
    if (!*pattern)
    {
	Nickname_sendNotice(argv[0] + 1, 44);
	return;
    }
    Client_addExpression(argv[0] + 1, pattern, seconds, comment + 1);
}

void User_List(int argc, char *argv[])
{
    User_sendLS(argv[0] + 1);
}

void User_Passwd(int argc, char *argv[])
{
    struct Clients *found;

    if ((found = List_find(&List_Subscriber, argv[0] + 1, FIND_NICKNAME)) != NULL && strlen(found->username))
    {
	if (!strcmp(argv[4], found->password))
	{
	    if (strlen(argv[5]) >= PASSWDLEN)
	    {
		Nickname_sendNotice(argv[0] + 1, 45);
		return;
	    }
	    strcpy(found->password, argv[5]);
	    Client_setStatus(found, STATUS_NEEDTOSAVE);
	    Client_writeDatabase(found);
	    Nickname_sendNotice(argv[0] + 1, 46);
	    Database_Sync();
	} else
	{
	    Nickname_sendNotice(argv[0] + 1, 47);
	}
    } else
	Nickname_sendNotice(argv[0] + 1, 48);
}

void User_Sync(int argc, char *argv[])
{
    Database_Sync();
}

void User_seeYou(int argc, char *argv[])
{
    struct Clients *found, *client;
    struct Expression *expression;
    int type = FIND_EVERYTHING, flag = 0;
    char *nickname = argv[0] + 1;


    if (!(client = List_find(&List_OnlineUsers[(int) nickname[0]], nickname, FIND_NICKNAME)))
	return;

    if (Status_IsInvisible(client->status))
    {
	Server_sendto(":%s NOTICE %s :You are invisible. Nobody can see you.\n", NICK, argv[0] + 1);
	return;
    }
    while ((found = List_find(&List_Subscriber, "", type)) != NULL)
    {
	type |= FIND_CONTINUE;

	expression = found->expressions;
	while (expression)
	{
	    if (!match(expression->pattern, client->key))
	    {
		Server_sendto(":%s NOTICE %s :%s (%s) is watching you\n", NICK, argv[0] + 1, Key_getNickname(found->key), Key_getUH(found->key));
		flag = 1;
		break;
	    }
	    expression = expression->next;
	}
    }
    if (!flag)
    {
	Server_sendto(":%s NOTICE %s :Nobody looks at you.\n", NICK, argv[0] + 1);
    }
}

void User_Continue(int argc, char *argv[])
{
    struct Clients *client;
    char *nickname = argv[0] + 1;

    if (!(client = List_find(&List_OnlineUsers[(int) nickname[0]], nickname, FIND_NICKNAME)))
	return;
    if (!User_deliverMessages(client))
	Nickname_sendNotice(argv[0] + 1, 50);
}

void User_Trash(int argc, char *argv[])
{
    struct Clients *client;
    char *nickname = argv[0] + 1;
    int n;

    if (!(client = List_find(&List_OnlineUsers[(int) nickname[0]], nickname, FIND_NICKNAME)))
	return;

    if ((n = User_trashMessages(client)) > 0)
	Client_sendNotice(client, 49, n);
    else
	Client_sendNotice(client, 50);
}

void User_Language(int argc, char *argv[])
{
    struct Clients *client;
    char buffer[SMALLBUFFER];
    char *nickname = argv[0] + 1;
    int i;

    if (!(client = List_find(&List_OnlineUsers[(int) nickname[0]], nickname, FIND_NICKNAME)))
	return;

    if ((i = Messages_getLanguage(argv[4])) == -1)
    {
	Messages_getLanguages(buffer);

	Client_sendNotice(client, 77, buffer);
	return;
    }
    client->status = i | (client->status & ~0xf);
    Client_sendNotice(client, 78, argv[4]);

    if (!(client = List_find(&List_Subscriber, nickname, FIND_NICKNAME)))
	return;
    client->status = i | (client->status & ~0xf);
    Client_setStatus(client, STATUS_NEEDTOSAVE);
    Client_writeDatabase(client);
}


void User_Logout(int argc, char *argv[])
{
    char *nickname = argv[0] + 1;
    struct Clients *client;

    if (!(client = List_find(&List_OnlineUsers[(int) nickname[0]], nickname, FIND_NICKNAME)))
	return;
    Client_sendNotice(client, 84);
    List_removeClient(&List_Subscriber, List_find(&List_Subscriber, nickname, FIND_NICKNAME));
    List_removeClient(&List_OnlineUsers[(int) nickname[0]], client);
}

void User_Kline(int argc, char *argv[])
{
    struct Clients *client,*found;
    char *nickname = argv[0] + 1;
    int type = FIND_KLINED | FIND_EVERYTHING;

    if (strcmp(argv[4], PASSWORD))
	return;

    if (!(client = List_find(&List_OnlineUsers[(int) nickname[0]], nickname, FIND_NICKNAME)))
	return;

    if(argc != 5)
    {
	    while ((found = List_find(&List_Subscriber, "", type)) != NULL)
	    {
		type |= FIND_CONTINUE;

    		Client_sendNotice(client, 36, found->key,"");
	    }
    }
    else
	    Database_addKline(client, argv[5]); 
}

void User_Unkline(int argc, char *argv[])
{
    struct Clients *client;
    char *nickname = argv[0] + 1;

    if (strcmp(argv[4], PASSWORD))
    return;

    if (!(client = List_find(&List_OnlineUsers[(int) nickname[0]], nickname, FIND_NICKNAME)))
	return;

    Database_delKline(client, argv[5]);
}

void User_DeleteUser(int argc, char *argv[])
{
    if (strcmp(argv[4], PASSWORD))
    return;

    Database_deleteUser(argv[5]);
    /* List_removeClient(&List_Subscriber, List_find(&List_Subscriber, nickname, FIND_NICKNAME)); */
}

