/* $Id: options.h.in,v 1.1.1.1 2003/07/04 02:55:55 Mysid Exp $ */

/*
 * Copyright (c) 1996-1997 Chip Norkus
 * Copyright (c) 1997 Max Byrd
 * Copyright (c) 1997 Greg Poma
 * Copyright (c) 1999 Dafydd James
 * Copyright (c) 2001 James Hess
 * Copyright (c) 2001 Portions copyright, see credits.c
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the authors nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef __OPTIONS_H
#define __OPTIONS_H

#ifndef CFGPATH
#define CFGPATH "."  /* The default path for services data */
#endif

#ifndef HELP_PATH
#define HELP_PATH "./help/" /* The default path for services helpfiles */
#endif

//#define ENABLE_GRPOPS /* GRPops - enable getrealpass ops [atm?] */

/* This is where email will be sent when akills/ignores are placed. */
/* #define AKILLMAILTO "kline@sorcery.net" */

#ifndef SENDMAIL
/*
 *   Default sendmail command.... leave the -t in. :)
 */ 
#define SENDMAIL "/usr/sbin/sendmail -t"
#endif

/*
 * Maximum lengths, including null
 */
#define NICKLEN  18	///< Nickname length + NIL
#define USERLEN  11	///< User length max + NIL
#define HOSTLEN  64	///< Host length max + NIL
#define CHANLEN  33	///< Channel length max + NIL
#define MEMOLEN 350	///< Max size for a single memo + NIL
#define URLLEN   91	///< URL length max + NIL
#define IRCBUF  513	///< length of IRC buffer + NIL -- make it >= 513!!
#define HELPTOPICBUF 25	///< Max length of a help topic
#define MAXBUF  1025    ///< Generic maxbuf
#define EMAILLEN (HOSTLEN+25) ///< Maximum length of an e-mail entry
#define PASSLEN	 15	///< Size of password area
#define AKREASON_LEN 255 ///< Max length of akill reason

/**
 * The name of the network? i.e. sorcery.net
 */
/* #define NETWORK "sorcery.net" */

/**
 * The channel to +l, or #undef for none
 */
#define PLUSLCHAN "#sorcery"

/**
 * The default nickname ID time
 */
#define DEF_NDELAY 60

/**
 * The interval at which nickserv warnings are sent for unidentified nicknames
 * (in seconds)
 */
#define NICKWARNINT 30


/**
 * We have two notices for unregistered users -
 * the friendly welcome note, and the icky
 * legally required disclaimer.
 * Not to mention the services copyright notice.
 */
#define WELCOME_NOTE \
	( \
		"Hi, welcome to " NETWORK "! You might want to " \
		"look at registering your nick while you're here - " \
		" just type \"/msg NickServ HELP\" for more information. " \
		"Also, make sure to read the disclaimer which comes next - " \
		"it's not very friendly but it's legally required. " \
		" Enjoy your stay!" \
	)

/// The Disclaimer message
#define DISCLAIMER \
	(	"NOTICE: This is a privately owned and operated IRC " \
		"network.  It is accessible to the public, but we reserve " \
		"the right to deny use of services or connection for any " \
		"reason we see fit at any time." \
	)

/**
 * Yell when someonee tries to over register? (GLOBOPS)
 */
#define REGLIMITYELL

/**
 * Show the Completed save(x) over globops?
 */
#undef GLOBOPS_TIMED_MSGS

/**
 * Send a globop when /os sync'ing?
 */ 
#undef GLOBOP_ON_SYNC

/**
 * Globop when doing /ns, /ms, or /cs save?
 */
#undef GLOBOP_ON_SAVE

/**
 * Fork services?
 */
#undef FORK_EM

/**
 * do a light XOR on passwords? (requires DB conversion)
 */
#define XORPASS

/**
 * Allow users to ghost themselves?
 */
#undef ALLOW_GHOST_YOURSELF

/**
 * default clone flags:
 * 0 for none
 * CLONE_KILLFLAG to autokill for every host
 * CLONE_IGNOREFLAG to autoignore for every host
 * CLONE_PERMTRIGGER to make ALL triggers permanet (including unchaged)
 */
#define DEFCLONEFLAGS 0

/**
 * Other MemoServ things you'll need:
 * MS_DEF_RCV_MAX = The *default* number of memos a max recieved field
 * will be set to
 * MS_RCV_MAX_HIGHEST = The highest a USER can set his max recieved field to
 * MS_SENT_MAX = The most memos a person can send out.
 */
#define MS_DEF_RCV_MAX 50
#define MS_RCV_MAX_HIGHEST 200
#define MS_SENT_MAX 8
#define MS_MAX_MBLOCK 3

/*
 * Some important NickServ limits
 */
#define ENF_MINDELAY 10     /* min nick ID time */
#define ENF_MAXDELAY 120    /* max nick ID time */

/*
 * this is a nice one, gives some allocation stats and such 
 */
#define ALLOCSTAT
#define MAXFLOODLEVEL 100
#define NICKDROPTIME (25*24*3600)
#define CHANDROPTIME (15*24*3600)
#define MEMODROPTIME (10*24*3600)
#define DEFHOSTCLONETRIGGER 8
#define DEFUSERCLONETRIGGER 3

#define SYNCTIME (15*60)
#define SHOWSYNCH

#define NEWSHEADERLEN 25
#define NEWSCONTENTLEN (MEMOLEN+1)

#define CHANDESCBUF 101

/**
 * Hash table sizes for various lists
 */

#define NICKHASHSIZE        1009  /* nicknames */
#define IDHASHSIZE          1000  /* nicknames by id number */
#define CHANHASHSIZE         523  /* channels */
#define CHANUSERHASHSIZE      53  /* users on a channel */
#define OPHASHSIZE            53  /* channel operators */
#define NICKCHANHASHSIZE      10  /* list of channels the nickname is in */
#define CLONEHASHSIZE       1009  /* hashed list of all clone records */
#define CHANTRIGHASHSIZE      25
#define ENABLE_AHURT
#define IRCD_HURTSET
#define TRACK_GECOS
#define MSG_REMSRA "delsra"

#define NPW_TH_SENDER_1 2
#define NPW_TH_TARGET_1 10

#define NPW_TH_SENDER_2 1
#define NPW_TH_TARGET_2 50

#define NPW_TH_SENDER_3 0
#define NPW_TH_TARGET_3 100

#define CPW_TH_SENDER_1 3
#define CPW_TH_TARGET_1 10

#define CPW_TH_SENDER_2 1
#define CPW_TH_TARGET_2 20

#define CPW_TH_SENDER_3 0
#define CPW_TH_TARGET_3 30

#define FLOOD_DET_HALF_PERIOD 5
#define FLOOD_DET_Z_PERIOD 10
#define FLOODVAL_BADPW 20

#ifdef __SORCERYNET__
#define NETNICK			"SorceryNet"
#define	NETNICKFOUNDERLINE	"The SorceryNet Network (sorcery@sorcery.net)"
#define IRCD_MLOCK
#endif
#endif
