#!/usr/bin/perl

###################################################################################
# 	mrtg-irc-stats.pl v0.1
#       Copyright (C) 2002 Adriaan Peeters <apeeters@lashout.net>
#
#       This program is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published by
#       the Free Software Foundation; either version 2 of the License, or
#       (at your option) any later version.
#
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#
#       You should have received a copy of the GNU General Public License
#       along with this program; if not, write to the Free Software
#       Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
#       mrtg-irc-stats.pl is a plugin for MRTG to grab all available /stats m
#       statistics from an IRC server.
#
#       More information can be found here:
#       http://dev.lashout.net/mrtg-irc-stats/
#       Please don't hesitate to mail me with suggestions/questions at
#       apeeters@lashout.net
#
###################################################################################

use strict;
use POE;
use POE::Component::IRC;

my $nick = 'mrtgbot';

sub _start {
    my ($kernel) = $_[KERNEL];

    $kernel->alias_set('anmrtgbot');
    $kernel->post('mrtgbot', 'register', 'all');
    $kernel->post('mrtgbot', 'connect', { Debug =>0,
					  Nick => $nick,
					  Server => $ARGV[0] || 'irc.krey.net',
					  Port => $ARGV[1] || 6667,
					  Username => 'mrtgbot',
					  Ircname => 'mrtgbot', }
		  );
}


sub irc_001 {
    my ($kernel) = $_[KERNEL];

    $kernel->post('mrtgbot', 'stats', 'm');
}

sub irc_212 {

#from http://vengeance.et.tudelft.nl/~smoke/irc-messages.txt
#  ; RPL_STATSCOMMANDS <command> <count> <byte count> <remote count> <command> <count> <byte count> <remote count>
#  (212 . "%c %n %b %r")


    my ($kernel, $from, $values) = @_[KERNEL, ARG0, ARG1];
    my($command, $count, $bytecount, $remotecount) = ($values =~ /^([A-Z]*) (\d+) (\d+) (\d+)$/i );

    if ($ARGV[2] eq  $command) {
	print "$count\n$remotecount\n";
    }
}

sub irc_219 {
    my ($kernel) = $_[KERNEL];

    $kernel->post( 'mrtgbot', 'quit', "I'll be back" );
    $kernel->alias_remove('anmrtgbot');
    exit 0;
}

sub irc_disconnected {
  my ($server) = $_[ARG0];
  print "Lost connection to server $server.\n";
}

sub irc_error {
  my $err = $_[ARG0];
  print "Server error occurred! $err\n";
}

sub irc_socketerr {
  my $err = $_[ARG0];
  print "Couldn't connect to server: $err\n";
}

sub _stop {
  my ($kernel) = $_[KERNEL];

  print "Control session stopped.\n";
  $kernel->post( 'mrtgbot', 'quit', "I'll be back" );
  $kernel->alias_remove('anmrtgbot');
}

POE::Component::IRC->new('mrtgbot') or die "Can't instantiate new IRC component!\n";
POE::Session->new('main' => [qw(_start _stop irc_001 irc_disconnected irc_socketerr irc_error irc_212 irc_219)] );

$poe_kernel->run();

exit 0;
